/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Container;
import savilerow.Domain;
import savilerow.Identifier;
import savilerow.IntegerDomain;
import savilerow.Range;
import savilerow.SymbolTable;

public class MatrixDomain
extends Domain {
    public static final long serialVersionUID = 1L;

    public MatrixDomain(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        arrayList2.add(new Container(new ArrayList<ASTNode>()));
        arrayList2.add(new BooleanConstant(true));
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
    }

    public MatrixDomain(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2, ASTNode aSTNode3) {
        assert (aSTNode2.numChildren() == arrayList.size() || aSTNode2.numChildren() == 0);
        assert (aSTNode2 instanceof Container);
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        arrayList2.add(aSTNode2);
        arrayList2.add(aSTNode3);
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
    }

    @Override
    public ASTNode copy() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(arrayList.subList(3, arrayList.size()));
        return new MatrixDomain(this.getChild(0), arrayList2, this.getChild(1), this.getChild(2));
    }

    @Override
    public ASTNode getDomainForId(ASTNode aSTNode) {
        if (this.getChild(1).getChildren().indexOf(aSTNode) > -1) {
            return this.getChild(this.getChild(1).getChildren().indexOf(aSTNode) + 3);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getDomainForId(aSTNode);
    }

    public ArrayList<ASTNode> getMDIndexDomains() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 3; i < this.numChildren(); ++i) {
            arrayList.add(this.getChild(i));
        }
        return arrayList;
    }

    public ASTNode getBaseDomain() {
        return this.getChild(0);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        ASTNode aSTNode;
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        for (n = 3; n < this.numChildren(); ++n) {
            aSTNode = this.getChild(n);
            if (!(aSTNode instanceof MatrixDomain) && !aSTNode.isSet()) {
                CmdFlags.println("ERROR: Expected domain in matrix domain, found: " + aSTNode);
                return false;
            }
            if (!(aSTNode instanceof MatrixDomain || aSTNode.equals(new IntegerDomain(new Range(null, null))) || aSTNode.isFiniteSet())) {
                CmdFlags.println("ERROR: Expected finite domain in matrix domain, found: " + aSTNode);
                return false;
            }
            if (aSTNode.getCategory() <= 2) continue;
            CmdFlags.println("ERROR: Expected no decision variables in index domain of matrix domain: " + aSTNode);
            return false;
        }
        for (n = 0; n < this.getChild(2).numChildren(); ++n) {
            aSTNode = this.getChild(2).getChild(n);
            if (aSTNode.isRelation() && aSTNode.getCategory() <= 2) continue;
            CmdFlags.println("ERROR: Expected relational quantifier expression in conditions of matrix domain.");
            return false;
        }
        return true;
    }

    public boolean typecheck_in_given(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < 3; ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0) instanceof Identifier) {
            CmdFlags.println("ERROR: Expected domain in matrix domain, found: " + this.getChild(0));
            return false;
        }
        for (n = 3; n < this.numChildren(); ++n) {
            ASTNode aSTNode = this.getChild(n);
            if (!(aSTNode instanceof Identifier)) continue;
            CmdFlags.println("ERROR: Expected domain in matrix domain, found: " + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
        String string = "";
        for (int i = 3; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ",";
        }
        String string2 = this.getChild(2).toString();
        String string3 = "matrix indexed by [" + string + "] of " + this.getChild(0);
        if (!string2.equals("true")) {
            string3 = string3 + " with indices " + arrayList + " and conditions " + string2;
        }
        return string3;
    }
}

