/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.BinOp;
import savilerow.CmdFlags;
import savilerow.Constants;
import savilerow.Divide;
import savilerow.Intpair;
import savilerow.Max;
import savilerow.Min;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Sat;

public class Mod
extends BinOp {
    public static final long serialVersionUID = 1L;

    public Mod(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Mod(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l = this.getChild(0).getValue();
            long l2 = this.getChild(1).getValue();
            if (l2 == 0L) {
                return null;
            }
            return NumberConstant.make(this.mod(l, l2));
        }
        return null;
    }

    public long mod(long l, long l2) {
        return Intpair.BigIntegerToLong(BigInteger.valueOf(l).subtract(BigInteger.valueOf(Divide.div(l, l2)).multiply(BigInteger.valueOf(l2))));
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        --intpair2.upper;
        ++intpair2.lower;
        if (intpair2.upper < 0L) {
            intpair2.upper = 0L;
        }
        if (intpair2.lower > 0L) {
            intpair2.lower = 0L;
        }
        return intpair2;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(1).getBoundsAST();
        pairASTNode.e1 = BinOp.makeBinOp("+", pairASTNode.e1, NumberConstant.make(1L));
        pairASTNode.e2 = BinOp.makeBinOp("-", pairASTNode.e2, NumberConstant.make(1L));
        pairASTNode.e1 = new Min((ASTNode)NumberConstant.make(0L), pairASTNode.e1);
        pairASTNode.e2 = new Max((ASTNode)NumberConstant.make(0L), pairASTNode.e2);
        return pairASTNode;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        if (Intpair.numValues(arrayList) * Intpair.numValues(arrayList2) > (long)Constants.intervallim) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    for (long i2 = arrayList2.get((int)k).lower; i2 <= arrayList2.get((int)k).upper; ++i2) {
                        long l = this.mod(j, i2);
                        arrayList3.add(new Intpair(l, l));
                    }
                }
            }
        }
        Intpair.normalise(arrayList3);
        return arrayList3;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("modulo(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("modulo(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Mod(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(",");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        assert (this.getCategory() <= 2);
        this.toDominionParam(stringBuilder);
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "%" + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint int_mod(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" mod ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.mod(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return this.mod(l, l2);
    }
}

