/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.Sat;

public class NumberConstantLong
extends NumberConstant {
    public static final long serialVersionUID = 1L;
    long num;

    public NumberConstantLong(long l) {
        this.num = l;
    }

    @Override
    public ASTNode copy() {
        return new NumberConstantLong(this.num);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NumberConstant)) {
            return false;
        }
        return this.num == ((ASTNode)object).getValue();
    }

    @Override
    public int hashCode() {
        return (int)(this.num ^ this.num >>> 32);
    }

    @Override
    public String toString() {
        return String.valueOf(this.num);
    }

    @Override
    public long getValue() {
        return this.num;
    }

    @Override
    public ArrayList<Intpair> getIntervalSet() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        arrayList.add(new Intpair(this.num, this.num));
        return arrayList;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        arrayList.add(new Intpair(this.num, this.num));
        return arrayList;
    }

    @Override
    public long directEncode(Sat sat, long l) {
        return l == this.num ? sat.getTrue() : -sat.getTrue();
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        if (this.num <= l) {
            return sat.getTrue();
        }
        return -sat.getTrue();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append(String.valueOf(this.num));
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append(this.num);
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        bufferedWriter.append(String.valueOf(this.num));
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append(this.num);
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        stringBuilder.append(this.num + "\n");
    }
}

