/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Negate;
import savilerow.Sat;
import savilerow.SymbolTable;

public class Or
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Or(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public Or(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    public Or(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    public Or(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new Or(this.getChildrenArray());
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        int n;
        boolean bl = false;
        ArrayList<ASTNode> arrayList = this.getChildren();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!(arrayList.get(n) instanceof Or)) continue;
            bl = true;
            ASTNode aSTNode = arrayList.remove(n);
            --n;
            arrayList.addAll(aSTNode.getChildren());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isConstant()) continue;
            long l = arrayList.get(n).getValue();
            if (l == 1L) {
                return new BooleanConstant(true);
            }
            bl = true;
            arrayList.remove(n);
            --n;
        }
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>(arrayList);
        if (hashSet.size() < arrayList.size()) {
            bl = true;
            arrayList.clear();
            arrayList.addAll(hashSet);
        }
        if (arrayList.size() == 0) {
            return new BooleanConstant(false);
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            return new Or(arrayList);
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(new Negate(this.getChild(i)));
        }
        return new And(arrayList);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: 'Or' contains numerical expression:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        this.normaliseInPlace();
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        this.normaliseInPlaceAlpha();
        return null;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("watched-or({");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, true);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("})");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i).toString());
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(" \\/ ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint array_bool_or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(bufferedWriter, true);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("],");
        aSTNode.toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(");");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint array_bool_or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(bufferedWriter, true);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("],");
        bufferedWriter.append("true);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(" \\/ ");
        }
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(this.getChild(i).directEncode(sat, 1L));
        }
        sat.addClause(arrayList);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(this.getChild(i).directEncode(sat, 1L));
        }
        sat.addClauseReified(arrayList, l);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

