/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.MatrixDomain;
import savilerow.QuantifiedSum;
import savilerow.SymbolTable;

public abstract class Quantifier
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Quantifier(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
        assert (aSTNode instanceof Identifier);
    }

    @Override
    public ASTNode getDomainForId(ASTNode aSTNode) {
        if (this.getChild(0).equals(aSTNode)) {
            return this.getChild(1);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getDomainForId(aSTNode);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        ASTNode aSTNode;
        if (!(this.getChild(0).typecheck(symbolTable) && this.getChild(1).typecheck(symbolTable) && this.getChild(2).typecheck(symbolTable))) {
            return false;
        }
        if (this.getChild(1).getCategory() > 2) {
            System.out.println("ERROR: In quantifier: " + this);
            System.out.println("ERROR: Decision variable in quantifier domain.");
            return false;
        }
        ASTNode aSTNode2 = this.getChild(0);
        if (!(aSTNode2 instanceof Identifier)) {
            System.out.println("ERROR: In quantifier: " + this);
            System.out.println("ERROR: Item in identifier list `" + aSTNode2 + "' is not an identifier.");
            System.out.println("ERROR: This can occur if it was replaced when substituting in parameters.");
            return false;
        }
        if (symbolTable.hasVariable(aSTNode2.toString()) || this.getParent() != null && this.getParent().getDomainForId(aSTNode2) != null) {
            System.out.println("ERROR: In quantifier: " + this);
            System.out.println("ERROR: Identifier `" + aSTNode2 + "' is already defined.");
            return false;
        }
        if (this.getChild(1).contains(aSTNode2)) {
            System.out.println("ERROR: In quantifier: " + this);
            System.out.println("ERROR: Quantifier domain contains the quantifier variable.");
            return false;
        }
        if (!this.getChild(2).contains(aSTNode2)) {
            CmdFlags.warning("Expression contained in quantifier does not contain quantifier variable: " + this);
        }
        if (!((aSTNode = this.getChild(1)) instanceof Identifier || aSTNode.isFiniteSet() || aSTNode instanceof MatrixDomain)) {
            System.out.println("ERROR: In quantifier: " + this);
            System.out.println("ERROR: Expected finite domain or matrix domain.");
            return false;
        }
        if (this.getChild(2).getDimension() > 0) {
            System.out.println("ERROR: quantifier (forAll, exists or sum) contains matrix: " + this.getChild(2));
            return false;
        }
        if (this instanceof QuantifiedSum) {
            if (!this.getChild(2).isRelation() && !this.getChild(2).isNumerical()) {
                System.out.println("ERROR: quantified sum contains expression that is not Boolean or integer: " + this.getChild(2));
                return false;
            }
        } else if (!this.getChild(2).isRelation()) {
            System.out.println("ERROR: exists or forAll contains non-Boolean expression: " + this.getChild(2));
            return false;
        }
        return true;
    }
}

