/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.Equals;
import savilerow.Identifier;
import savilerow.Model;
import savilerow.NumberConstant;
import savilerow.Top;
import savilerow.categoryentry;

public class RemoveRedundantVars {
    private TObjectIntHashMap<String> varCount;

    public void transform(Model model) {
        this.varCount = new TObjectIntHashMap();
        assert (this.varCount.getNoEntryValue() == 0);
        this.populate_varCount(model.constraints);
        if (model.objective != null) {
            this.populate_varCount(model.objective);
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        categoryentry categoryentry2 = model.global_symbols.getCategoryFirst();
        while (categoryentry2 != null) {
            if (model.global_symbols.getCategory(categoryentry2.name) == 3 && this.varCount.get(categoryentry2.name) == this.varCount.getNoEntryValue()) {
                Identifier identifier = new Identifier(model, categoryentry2.name);
                arrayList.add(new Equals((ASTNode)identifier, NumberConstant.make(((ASTNode)identifier).getBounds().lower)));
            }
            categoryentry2 = categoryentry2.next;
        }
        if (arrayList.size() > 0) {
            model.constraints.getChild(0).setParent(null);
            model.constraints = new Top(new And(model.constraints.getChild(0), new And(arrayList)));
            model.simplify();
        }
    }

    private void populate_varCount(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            String string = aSTNode.toString();
            if (this.varCount.get(string) == this.varCount.getNoEntryValue()) {
                this.varCount.put(string, 1);
            } else {
                this.varCount.put(string, this.varCount.get(string) + 1);
            }
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.populate_varCount(aSTNode.getChild(i));
            }
        }
    }
}

