/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.HashSet;
import savilerow.AMOEnc;
import savilerow.ASTNode;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.Less;
import savilerow.LessEqual;
import savilerow.Maximising;
import savilerow.Minimising;
import savilerow.Model;
import savilerow.MultiplyMapper;
import savilerow.NodeReplacement;
import savilerow.Sat;
import savilerow.ShiftMapper;
import savilerow.TreeTransformerBottomUpNoWrapper;
import savilerow.WeightedSum;

public class TransformCollectSATDirect
extends TreeTransformerBottomUpNoWrapper {
    private HashSet<String> vars = new HashSet();

    public TransformCollectSATDirect(Model model) {
        super(model);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            this.vars.add(aSTNode.toString());
            if (!aSTNode.isRelation()) {
                ASTNode aSTNode2 = aSTNode;
                while (aSTNode2.getParent() instanceof MultiplyMapper || aSTNode2.getParent() instanceof ShiftMapper) {
                    aSTNode2 = aSTNode2.getParent();
                }
                ASTNode aSTNode3 = aSTNode2.getParent();
                if (aSTNode3 instanceof LessEqual || aSTNode3 instanceof Less) {
                    this.m.global_symbols.markAsOrderSAT(aSTNode.toString());
                } else if (aSTNode3 instanceof WeightedSum) {
                    if (Sat.eligibleAMO(aSTNode3) && CmdFlags.sat_amo_encoding != AMOEnc.TREE) {
                        this.m.global_symbols.markAsDirectSAT(aSTNode.toString());
                    } else {
                        this.m.global_symbols.markAsOrderSAT(aSTNode.toString());
                    }
                } else if (aSTNode3 instanceof Minimising || aSTNode3 instanceof Maximising) {
                    this.m.global_symbols.markAsOrderSAT(aSTNode.toString());
                } else {
                    this.m.global_symbols.markAsDirectSAT(aSTNode.toString());
                }
            }
        }
        return null;
    }

    public HashSet<String> getVarsInConstraints() {
        return this.vars;
    }
}

