package savilerow;
/*

    Savile Row http://savilerow.cs.st-andrews.ac.uk/
    Copyright (C) 2014-2020 Peter Nightingale
    
    This file is part of Savile Row.
    
    Savile Row is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Savile Row is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Savile Row.  If not, see <http://www.gnu.org/licenses/>.

*/



import java.util.*;
import java.io.*;


// Reads a minion stats file, the file generated by the -tableout parameter to
// minion.

// Can handle multiple lines in the stats file, however, currently
// EPrimeTailor deletes the stats file before running minion, so there will
// always be only one entry in the stats file.

// Can be used to run minion several times, collect the results in the same
// stats file, and report a list of values instead of a single one.

// Makes all the values reported by minion available through "getValues". It
// returns the values for a given header.

// Also "report" generates a one line report for a given header. This line is
// meant to go in the solution file generated in EPrimeTailor.

// See CmdFlags.minionStatsTempFile for the filename used for the temporary
// file.

public class MinionStats extends Stats
{

    public MinionStats() {
    }

    public MinionStats(String filename) throws FileNotFoundException, IOException {
        fromFile(filename);
    }
    
    // Read Minion tableout file. 
    public void fromFile(String filename) throws FileNotFoundException, IOException {
        
        BufferedReader br = new BufferedReader(new FileReader(filename));
        
        ArrayList<String> headers = new ArrayList<String>();
        String line = br.readLine();
        for (String col : line.split(" "))
            headers.add(trim(trim(col,"#"),"\""));
        
        // Read the first line only. Other lines will be discarded. 
        // Populate the stats using headers and this one line. 
        line = br.readLine();
        int i=0;
        for(String col : line.split(" ")) {
            String colname=headers.get(i);
            
            if(colname.equals("SolveTime")) {
                putValue("SolverSolveTime", col);
            }
            else if(colname.equals("SetupTime")) {
                putValue("SolverSetupTime", col);
            }
            else if(colname.equals("TotalTime")) {
                putValue("SolverTotalTime", col);
            }
            else if(colname.equals("Nodes")) {
                putValue("SolverNodes", col);
            }
            else if(colname.equals("Satisfiable")) {
                putValue("SolverSatisfiable", col);
            }
            else if(colname.equals("SolutionsFound")) {
                putValue("SolverSolutionsFound", col);
            }
            else if(colname.equals("TimeOut")) {
                putValue("SolverTimeOut", col);
            }
            i++;
        }
    }
    
    // quite naive way to trim the quotes from header strings.
    public String trim(String st, String rem) {
        while (st.startsWith(rem))
            st = st.substring(rem.length());
        while (st.endsWith(rem))
            st = st.substring(0, st.length() - rem.length());
        return st;
    }
    
}
