/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import savilerow.AMODetect;
import savilerow.AMOPBMDDBuilder;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.AbioMDDEncoding;
import savilerow.AllDifferent;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Equals;
import savilerow.GGT;
import savilerow.Identifier;
import savilerow.Iff;
import savilerow.Intpair;
import savilerow.LessEqual;
import savilerow.MDD;
import savilerow.Max;
import savilerow.Minimising;
import savilerow.Model;
import savilerow.Negate;
import savilerow.NumberConstant;
import savilerow.OpenWBOSATSolver;
import savilerow.Pair;
import savilerow.SWC;
import savilerow.Sat;
import savilerow.SolEnum;
import savilerow.Solution;
import savilerow.SymbolTable;
import savilerow.ToVariable;
import savilerow.Top;
import savilerow.TransformCollectSATDirect;
import savilerow.TransformDecomposeMinMax;
import savilerow.TransformExtractBoolsInSums;
import savilerow.TransformSATEncoding;
import savilerow.TransformToFlat;
import savilerow.Watchdog;
import savilerow.WeightedSum;

public class AMOPB
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public AMOPB(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new AMOPB(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        return null;
    }

    public ASTNode collectAMOGroups(Model model) {
        Object object;
        Serializable serializable;
        Iterator<ASTNode> iterator;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        if (!CmdFlags.getAmoDetect()) {
            return new BooleanConstant(true);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        HashMap<String, ASTNode> hashMap = new HashMap<String, ASTNode>();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
            serializable4 = this.getChild(0).getChild(i).getChild(2);
            if (((ASTNode)serializable4).numChildren() != 2 || !((serializable3 = ((ASTNode)serializable4).getChild(1)) instanceof Identifier) && (!(serializable3 instanceof Negate) || !(((ASTNode)serializable3).getChild(0) instanceof Identifier))) continue;
            Intpair intpair = ((ASTNode)serializable3).getBounds();
            if (!((ASTNode)serializable3).isRelation() && (intpair.lower != 0L || intpair.upper != 1L)) continue;
            boolean bl = serializable3 instanceof Negate;
            if (bl) {
                serializable3 = ((ASTNode)serializable3).getChild(0);
            }
            treeSet.add(((ASTNode)serializable3).toString());
            hashMap.put(((ASTNode)serializable3).toString(), this.getChild(0).getChild(i).getChild(1).getChild(1));
            hashMap2.put(((ASTNode)serializable3).toString(), bl);
        }
        if (treeSet.size() == 0) {
            return new BooleanConstant(true);
        }
        TreeSet treeSet2 = new TreeSet(treeSet);
        serializable4 = AMODetect.buildCliques(treeSet, hashMap);
        serializable3 = this.getChild(0).getChildren(1);
        for (int i = ((ArrayList)serializable3).size() - 1; i >= 0; --i) {
            ASTNode aSTNode = ((ASTNode)((ArrayList)serializable3).get(i)).getChild(2);
            if (aSTNode.numChildren() != 2) continue;
            serializable2 = aSTNode.getChild(1);
            if (serializable2 instanceof Negate) {
                serializable2 = ((ASTNode)serializable2).getChild(0);
            }
            if (!treeSet2.contains(((ASTNode)serializable2).toString())) continue;
            ((ArrayList)serializable3).remove(i);
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < ((ArrayList)serializable4).size(); ++i) {
            Serializable serializable5;
            Object object2;
            serializable2 = (TreeSet)((ArrayList)serializable4).get(i);
            boolean bl = true;
            iterator = ((TreeSet)serializable2).iterator();
            while (iterator.hasNext()) {
                serializable = (Integer)iterator.next();
                object = AMODetect.varslist.get((Integer)serializable < 0 ? -((Integer)serializable).intValue() : (Integer)serializable);
                if ((Boolean)hashMap2.get(object) == (Integer)serializable < 0) continue;
                bl = false;
                break;
            }
            iterator = new ArrayList();
            serializable = new ArrayList();
            object = new ArrayList();
            if (bl || ((TreeSet)serializable2).size() == 1) {
                Iterator iterator2 = ((TreeSet)serializable2).iterator();
                while (iterator2.hasNext()) {
                    Integer n = (Integer)iterator2.next();
                    if (n < 0) {
                        n = -n.intValue();
                    }
                    object2 = AMODetect.varslist.get(n);
                    serializable5 = new Identifier(model, (String)object2);
                    ((ArrayList)serializable).add(serializable5);
                    ((ArrayList)((Object)iterator)).add(hashMap.get(object2));
                    ((ArrayList)object).add((Boolean)hashMap2.get(object2));
                }
                if (((ArrayList)serializable).size() > 1) {
                    this.checkEO((ArrayList<ASTNode>)serializable, (ArrayList<ASTNode>)((Object)iterator), (ArrayList<Boolean>)object);
                }
                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                    ((ArrayList)serializable).set(j, this.makeChild((ASTNode)((ArrayList)serializable).get(j), (Boolean)((ArrayList)object).get(j)));
                }
                if (((ArrayList)serializable).size() <= 0) continue;
                ((ArrayList)serializable3).add(CompoundMatrix.make(CompoundMatrix.make(iterator), CompoundMatrix.make((ArrayList<ASTNode>)serializable)));
                continue;
            }
            long l = this.getChild(1).getValue();
            object2 = ((TreeSet)serializable2).iterator();
            while (object2.hasNext()) {
                String string;
                serializable5 = (Integer)object2.next();
                if (serializable5 > 0) {
                    string = AMODetect.varslist.get((int)serializable5);
                    if (((Boolean)hashMap2.get(string)).booleanValue()) {
                        ((ArrayList)serializable).add(new Identifier(model, string));
                        ((ArrayList)((Object)iterator)).add(NumberConstant.make(-hashMap.get(string).getValue()));
                        ((ArrayList)object).add(false);
                        l -= hashMap.get(string).getValue();
                        continue;
                    }
                    ((ArrayList)serializable).add(new Identifier(model, string));
                    ((ArrayList)((Object)iterator)).add(hashMap.get(string));
                    ((ArrayList)object).add(false);
                    continue;
                }
                string = AMODetect.varslist.get(-serializable5.intValue());
                if (((Boolean)hashMap2.get(string)).booleanValue()) {
                    ((ArrayList)serializable).add(new Identifier(model, string));
                    ((ArrayList)((Object)iterator)).add(hashMap.get(string));
                    ((ArrayList)object).add(true);
                    continue;
                }
                ((ArrayList)serializable).add(new Identifier(model, string));
                ((ArrayList)((Object)iterator)).add(NumberConstant.make(-hashMap.get(string).getValue()));
                ((ArrayList)object).add(true);
                l -= hashMap.get(string).getValue();
            }
            this.setChild(1, NumberConstant.make(l));
            this.makePositive(model, arrayList, (ArrayList<ASTNode>)serializable3, (ArrayList<ASTNode>)serializable, (ArrayList<ASTNode>)((Object)iterator), (ArrayList<Boolean>)object);
        }
        this.setChild(0, CompoundMatrix.make((ArrayList<ASTNode>)serializable3));
        if (!CmdFlags.amo_detect_noamoenc) {
            Iterator iterator3 = ((ArrayList)serializable4).iterator();
            while (iterator3.hasNext()) {
                serializable2 = (TreeSet)iterator3.next();
                if (((TreeSet)serializable2).size() <= 1) continue;
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                iterator = ((TreeSet)serializable2).iterator();
                while (iterator.hasNext()) {
                    serializable = (Integer)iterator.next();
                    if ((Integer)serializable > 0) {
                        arrayList2.add(new Identifier(model, AMODetect.varslist.get((Integer)serializable)));
                        continue;
                    }
                    object = new Identifier(model, AMODetect.varslist.get(-((Integer)serializable).intValue()));
                    arrayList2.add(this.makeChild((ASTNode)object, true));
                }
                arrayList.add(new LessEqual((ASTNode)new WeightedSum(arrayList2), NumberConstant.make(1L)));
            }
        }
        return new And(arrayList);
    }

    public void makePositive(Model model, ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, ArrayList<ASTNode> arrayList3, ArrayList<ASTNode> arrayList4, ArrayList<Boolean> arrayList5) {
        if (arrayList3.size() == 1) {
            long l = arrayList4.get(0).getValue();
            assert (l < 0L);
            long l2 = this.getChild(1).getValue();
            boolean bl = arrayList5.get(0) == false;
            this.setChild(1, NumberConstant.make(l2 + l));
            arrayList4.set(0, NumberConstant.make(-l));
            arrayList3.set(0, this.makeChild(arrayList3.get(0), bl));
            arrayList2.add(CompoundMatrix.make(CompoundMatrix.make(arrayList4), CompoundMatrix.make(arrayList3)));
        } else {
            int n;
            long l = this.getChild(1).getValue();
            Identifier identifier = model.global_symbols.newAuxiliaryVariable(0L, 1L);
            ArrayList<ASTNode> arrayList6 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList6.add(this.makeChild(arrayList3.get(i), arrayList5.get(i) == false));
            }
            arrayList.add(new Iff((ASTNode)identifier, new And(arrayList6)));
            ArrayList<Long> arrayList7 = new ArrayList<Long>();
            for (int i = 0; i < arrayList4.size(); ++i) {
                arrayList7.add(arrayList4.get(i).getValue());
            }
            long l3 = (Long)Collections.min(arrayList7);
            assert (l3 < 0L);
            l -= l3;
            for (n = arrayList3.size() - 1; n >= 0; --n) {
                if (arrayList4.get(n).getValue() == l3) {
                    arrayList3.remove(n);
                    arrayList4.remove(n);
                    arrayList5.remove(n);
                    continue;
                }
                arrayList4.set(n, NumberConstant.make(arrayList4.get(n).getValue() - l3));
            }
            arrayList3.add(identifier);
            arrayList4.add(NumberConstant.make(-l3));
            arrayList5.add(false);
            for (n = 0; n < arrayList3.size(); ++n) {
                arrayList3.set(n, this.makeChild(arrayList3.get(n), arrayList5.get(n)));
            }
            arrayList2.add(CompoundMatrix.make(CompoundMatrix.make(arrayList4), CompoundMatrix.make(arrayList3)));
            this.setChild(1, NumberConstant.make(l));
        }
    }

    private void checkEO(ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, ArrayList<Boolean> arrayList3) {
        ASTNode aSTNode = null;
        ArrayList<Intpair> arrayList4 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            long l;
            ASTNode aSTNode2 = TransformExtractBoolsInSums.inverseCache.get(arrayList.get(i));
            if (aSTNode2 instanceof AllDifferent && arrayList3.get(i).booleanValue() && aSTNode2.getChild(0).numChildren() == 3 && (aSTNode2.getChild(0).getChild(1).isConstant() || aSTNode2.getChild(0).getChild(2).isConstant())) {
                aSTNode2 = new Equals(aSTNode2.getChild(0).getChild(1), aSTNode2.getChild(0).getChild(2));
                arrayList.set(i, aSTNode2);
                arrayList3.set(i, false);
            }
            if (aSTNode2 != null && aSTNode2 instanceof Equals && !arrayList3.get(i).booleanValue()) {
                ASTNode aSTNode3;
                ASTNode aSTNode4 = aSTNode2.getChild(0);
                ASTNode aSTNode5 = aSTNode2.getChild(1);
                if (aSTNode4 instanceof Identifier && aSTNode5.isConstant()) {
                    aSTNode3 = aSTNode4;
                    l = aSTNode5.getValue();
                } else if (aSTNode5 instanceof Identifier && aSTNode4.isConstant()) {
                    aSTNode3 = aSTNode5;
                    l = aSTNode4.getValue();
                } else {
                    return;
                }
                if (aSTNode == null) {
                    aSTNode = aSTNode3;
                }
                if (!aSTNode.equals(aSTNode3)) {
                    return;
                }
            } else {
                return;
            }
            arrayList4 = Intpair.union(arrayList4, Intpair.makeList(l, l));
        }
        ArrayList<Intpair> arrayList5 = Intpair.setDifference(aSTNode.getIntervalSetExp(), arrayList4);
        if (arrayList5.size() == 0) {
            long l;
            int n;
            long l2 = Long.MAX_VALUE;
            for (n = 0; n < arrayList2.size(); ++n) {
                l = arrayList2.get(n).getValue();
                if (l >= l2) continue;
                l2 = l;
            }
            for (n = arrayList2.size() - 1; n >= 0; --n) {
                l = arrayList2.get(n).getValue();
                if (l == l2) {
                    arrayList2.remove(n);
                    arrayList.remove(n);
                    arrayList3.remove(n);
                    continue;
                }
                arrayList2.set(n, NumberConstant.make(arrayList2.get(n).getValue() - l2));
            }
            this.setChild(1, NumberConstant.make(this.getChild(1).getValue() - l2));
        }
    }

    ASTNode makeChild(ASTNode aSTNode, boolean bl) {
        if (bl) {
            if (aSTNode.isRelation()) {
                return new Negate(aSTNode);
            }
            return new Equals(aSTNode, NumberConstant.make(0L));
        }
        return aSTNode;
    }

    private void cliquesByMaxsat(TreeSet<String> treeSet, ArrayList<TreeSet<String>> arrayList) {
        SymbolTable symbolTable = new SymbolTable();
        ArrayList<String> arrayList2 = new ArrayList<String>(treeSet);
        int n = arrayList.size();
        for (int i = 0; i < arrayList2.size(); ++i) {
            symbolTable.newVariable(arrayList2.get(i), Intpair.makeDomain(1L, n - 1, false), 3);
        }
        Model model = new Model();
        model.setup(new BooleanConstant(true), symbolTable, null, null, null, null, null);
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList3.add(new Identifier(model, arrayList2.get(i)));
        }
        ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            for (int j = i + 1; j < arrayList2.size(); ++j) {
                if (this.edge(arrayList2.get(i), arrayList2.get(j))) continue;
                arrayList4.add(new AllDifferent((ASTNode)arrayList3.get(i), (ASTNode)arrayList3.get(j)));
            }
        }
        symbolTable.newVariable("objvar", Intpair.makeDomain(1L, n - 1, false), 3);
        Identifier identifier = new Identifier(model, "objvar");
        model.objective = new Minimising(identifier);
        arrayList4.add(new ToVariable((ASTNode)new Max(arrayList3), identifier));
        model.constraints = new Top(new And(arrayList4));
        TransformDecomposeMinMax transformDecomposeMinMax = new TransformDecomposeMinMax(model);
        model.transform(transformDecomposeMinMax);
        TransformToFlat transformToFlat = new TransformToFlat(model, false);
        model.transform(transformToFlat);
        model.simplify();
        TransformCollectSATDirect transformCollectSATDirect = new TransformCollectSATDirect(model);
        transformCollectSATDirect.transform(model.constraints);
        SolEnum solEnum = CmdFlags.soltype;
        CmdFlags.soltype = SolEnum.MAXSAT;
        assert (model.setupSAT(transformCollectSATDirect.getVarsInConstraints()));
        TransformSATEncoding transformSATEncoding = new TransformSATEncoding(model);
        model.constraints = transformSATEncoding.transform(model.constraints);
        assert (model.toSAT());
        OpenWBOSATSolver openWBOSATSolver = new OpenWBOSATSolver(model);
        try {
            openWBOSATSolver.findSolutions("open-wbo", CmdFlags.satfile, model);
        }
        catch (Exception exception) {
            CmdFlags.errorExit("Borken: " + exception);
        }
        CmdFlags.soltype = solEnum;
        if (model.incumbentSolution != null) {
            ASTNode aSTNode = model.incumbentSolution;
            long l = ((Solution)aSTNode).optval;
            arrayList.clear();
            int n2 = 0;
            while ((long)n2 < l) {
                arrayList.add(new TreeSet());
                ++n2;
            }
            for (n2 = 0; n2 < aSTNode.numChildren(); ++n2) {
                String string = aSTNode.getChild(n2).getChild(0).toString();
                long l2 = aSTNode.getChild(n2).getChild(1).getValue();
                if (!treeSet.contains(string)) continue;
                arrayList.get((int)l2 - 1).add(string);
            }
        }
    }

    private boolean edge(String string, String string2) {
        Integer n = AMODetect.vartonum.get(string);
        Integer n2 = AMODetect.vartonum.get(string2);
        if (n == null || n2 == null) {
            return false;
        }
        return AMODetect.adjlist.get(n).contains(n2) || AMODetect.adjlist.get(n2).contains(n);
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        int n;
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            ASTNode aSTNode = this.getChild(0).getChild(n);
            arrayList.addAll(aSTNode.getChild(2).getChildren(1));
            for (int i = 1; i < aSTNode.getChild(1).numChildren(); ++i) {
                arrayList2.add(aSTNode.getChild(1).getChild(i).getValue());
            }
        }
        bufferedWriter.append("weightedsumleq([");
        for (n = 0; n < arrayList2.size(); ++n) {
            bufferedWriter.append(String.valueOf(arrayList2.get(n)));
            if (n >= arrayList2.size() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("],[");
        for (n = 0; n < arrayList.size(); ++n) {
            ((ASTNode)arrayList.get(n)).toMinion(bufferedWriter, false);
            if (n >= arrayList.size() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("],");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    private Pair<ArrayList<ArrayList<Long>>, ArrayList<ArrayList<Integer>>> unpackCoeffs(Sat sat) {
        Serializable serializable;
        Serializable serializable2;
        int n;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            serializable2 = this.getChild(0).getChild(n).getChild(2);
            for (int i = 1; i < serializable2.numChildren(); ++i) {
                long l = serializable2.getChild(i).directEncode(sat, 1L);
                arrayList3.add(l);
            }
            arrayList.add(arrayList3);
            serializable = this.getChild(0).getChild(n).getChild(1);
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            for (int i = 1; i < serializable.numChildren(); ++i) {
                arrayList4.add((int)serializable.getChild(i).getValue());
            }
            arrayList2.add(arrayList4);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            for (int i = n + 1; i < arrayList2.size(); ++i) {
                if ((Integer)Collections.max((Collection)arrayList2.get(i)) <= (Integer)Collections.max((Collection)arrayList2.get(n))) continue;
                serializable2 = (ArrayList)arrayList2.get(i);
                arrayList2.set(i, (ArrayList)arrayList2.get(n));
                arrayList2.set(n, serializable2);
                serializable = (ArrayList)arrayList.get(i);
                arrayList.set(i, (ArrayList)arrayList.get(n));
                arrayList.set(n, serializable);
            }
        }
        return new Pair<ArrayList<ArrayList<Long>>, ArrayList<ArrayList<Integer>>>(arrayList, arrayList2);
    }

    private void buildMDDEncoding(Sat sat) throws IOException {
        Pair<ArrayList<ArrayList<Long>>, ArrayList<ArrayList<Integer>>> pair = this.unpackCoeffs(sat);
        AMOPBMDDBuilder aMOPBMDDBuilder = new AMOPBMDDBuilder(pair.getSecond(), pair.getFirst(), (int)this.getChild(1).getValue(), true);
        MDD mDD = aMOPBMDDBuilder.getMDD();
        AbioMDDEncoding abioMDDEncoding = new AbioMDDEncoding(sat);
        long l = abioMDDEncoding.assertMDD(mDD);
        sat.addClause(l);
    }

    private void buildGPWEncoding(Sat sat) throws IOException {
        Pair<ArrayList<ArrayList<Long>>, ArrayList<ArrayList<Integer>>> pair = this.unpackCoeffs(sat);
        Watchdog.addAMOPBGlobalPolynomialWatchdog(pair.getSecond(), pair.getFirst(), (int)this.getChild(1).getValue(), true, sat);
    }

    private void buildSWCEncoding(Sat sat) throws IOException {
        Pair<ArrayList<ArrayList<Long>>, ArrayList<ArrayList<Integer>>> pair = this.unpackCoeffs(sat);
        SWC.addAMOPBSWC(pair.getSecond(), pair.getFirst(), (int)this.getChild(1).getValue(), sat);
    }

    private void buildGGTEncoding(Sat sat) throws IOException {
        Pair<ArrayList<ArrayList<Long>>, ArrayList<ArrayList<Integer>>> pair = this.unpackCoeffs(sat);
        GGT.addAMOPBGeneralizedTotalizer(pair.getSecond(), pair.getFirst(), (int)this.getChild(1).getValue(), sat);
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        long l = this.getChild(2).getValue();
        if (l == 1L) {
            this.buildMDDEncoding(sat);
        } else if (l == 2L) {
            this.buildGPWEncoding(sat);
        } else if (l == 3L) {
            this.buildSWCEncoding(sat);
        } else if (l == 4L) {
            this.buildGGTEncoding(sat);
        } else assert (false) : "Unknown encoding for AMO PB constraint.";
    }
}

