/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.math.BigInteger;
import savilerow.CmdFlags;
import savilerow.Intpair;

public class BitVector {
    public static int bits = 64;
    public static long highest = 0L;
    public static long lowest = 0L;

    public static void addMax(Intpair intpair) {
        if (lowest > intpair.lower) {
            lowest = intpair.lower;
        }
        if (highest < intpair.upper) {
            highest = intpair.upper;
        }
    }

    public static void determineBits() {
        int n = BitVector.bitsNeeded(lowest * -1L);
        int n2 = BitVector.bitsNeeded(highest + 1L);
        bits = n;
        if (n2 > n) {
            bits = n2;
        }
        if (++bits > 64) {
            CmdFlags.errorExit("Values are too large\n This model contains integers that requiremore than 64 bits to represent");
        }
    }

    public static int bitsNeeded(long l) {
        int n = 0;
        do {
            ++n;
        } while ((l /= 2L) != 0L);
        return n;
    }

    public static long toLong(String string) {
        long l;
        char[] cArray = string.toCharArray();
        if (cArray[1] == 'x') {
            cArray[0] = 48;
            string = String.valueOf(cArray);
            long l2 = Long.decode(string);
            return l2;
        }
        cArray = string.substring(2, string.length()).toCharArray();
        if (cArray[0] == '1') {
            cArray = BitVector.subtractOne(cArray);
            cArray = BitVector.flipBits(cArray);
            l = -1L * new BigInteger(String.valueOf(cArray), 2).longValue();
        } else {
            l = new BigInteger(String.valueOf(cArray), 2).longValue();
        }
        return l;
    }

    public static String toHexString(long l) {
        char[] cArray;
        if (l < 0L) {
            cArray = BitVector.toBinary(l * -1L);
            cArray = BitVector.flipBits(cArray);
            cArray = BitVector.addOne(cArray);
        } else {
            cArray = BitVector.toBinary(l);
        }
        if (bits % 4 == 0) {
            char[] cArray2 = BitVector.toHex(cArray);
            return "#x" + String.valueOf(cArray2);
        }
        return "#b" + String.valueOf(cArray);
    }

    public static char[] toHex(char[] cArray) {
        char[] cArray2 = new char[bits / 4];
        int n = 0;
        int n2 = 0;
        while (n < cArray2.length) {
            cArray2[n] = BitVector.hexDigit(cArray[n2], cArray[n2 + 1], cArray[n2 + 2], cArray[n2 + 3]);
            ++n;
            n2 += 4;
        }
        return cArray2;
    }

    public static char[] toBinary(long l) {
        char[] cArray = new char[bits];
        cArray[0] = 48;
        long l2 = l;
        int n = 1;
        int n2 = bits - 2;
        while (n < cArray.length - 1) {
            long l3 = l2 / BitVector.powerOfTwo(n2);
            cArray[n] = l3 == 0L ? 48 : 49;
            l2 %= BitVector.powerOfTwo(n2);
            ++n;
            --n2;
        }
        cArray[BitVector.bits - 1] = l2 == 0L ? 48 : 49;
        return cArray;
    }

    private static long powerOfTwo(int n) {
        assert (n >= 1 && n <= 62);
        return 1L << n;
    }

    public static char hexDigit(char c, char c2, char c3, char c4) {
        if (c == '1') {
            if (c2 == '1') {
                if (c3 == '1') {
                    if (c4 == '1') {
                        return 'f';
                    }
                    return 'e';
                }
                if (c4 == '1') {
                    return 'd';
                }
                return 'c';
            }
            if (c3 == '1') {
                if (c4 == '1') {
                    return 'b';
                }
                return 'a';
            }
            if (c4 == '1') {
                return '9';
            }
            return '8';
        }
        if (c2 == '1') {
            if (c3 == '1') {
                if (c4 == '1') {
                    return '7';
                }
                return '6';
            }
            if (c4 == '1') {
                return '5';
            }
            return '4';
        }
        if (c3 == '1') {
            if (c4 == '1') {
                return '3';
            }
            return '2';
        }
        if (c4 == '1') {
            return '1';
        }
        return '0';
    }

    public static char[] flipBits(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = cArray[i] == '0' ? 49 : 48;
        }
        return cArray;
    }

    public static char[] addOne(char[] cArray) {
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] != '1') {
                cArray[i] = 49;
                break;
            }
            cArray[i] = 48;
        }
        return cArray;
    }

    public static char[] subtractOne(char[] cArray) {
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] != '1') continue;
            cArray[i] = 48;
            ++i;
            while (i < cArray.length) {
                cArray[i] = 49;
                ++i;
            }
            break;
        }
        return cArray;
    }

    public static int getBits() {
        return bits;
    }
}

