/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.Model;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.Solution;
import savilerow.Solver;
import savilerow.Stats;
import savilerow.SymbolTable;

public class FznSolver
extends Solver {
    private Stats stats = null;

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        this.runFznSolver(string, string2, model);
    }

    private void runFznSolver(String string, String string2, Model model) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (CmdFlags.getFindAllSolutions()) {
                if (model.objective != null) {
                    CmdFlags.warning("Ignoring -all-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindAllSolutions(false);
                } else {
                    arrayList.add("-n");
                    arrayList.add("0");
                }
            }
            if (CmdFlags.getFindNumSolutions() > 1L) {
                if (model.objective != null) {
                    CmdFlags.warning("Ignoring -num-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindNumSolutions(1L);
                } else {
                    arrayList.add("-n");
                    arrayList.add(String.valueOf(CmdFlags.getFindNumSolutions()));
                }
            }
            if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans()) && !CmdFlags.getSolverExtraFlags().contains("-s")) {
                CmdFlags.addSolverFlag("-s");
            }
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            arrayList.add(string2);
            if (CmdFlags.getChuffedtrans()) {
                arrayList.add("-f");
            }
            double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
            this.stats = new Stats();
            this.stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.stats.putValue("SolverSatisfiable", "1");
            this.stats.putValue("SolverTimeOut", "0");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ReadFznOutput readFznOutput = new ReadFznOutput(this, model.global_symbols);
            double d2 = System.currentTimeMillis();
            int n = RunCommand.runCommand(true, arrayList, arrayList2, readFznOutput);
            d2 = ((double)System.currentTimeMillis() - d2) / 1000.0;
            this.stats.putValue("SolverTotalTime", String.valueOf(d2));
            if (arrayList2.size() != 0 || n != 0) {
                CmdFlags.println("Solver exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
                CmdFlags.rmTempFiles();
            }
            this.stats.makeInfoFiles();
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            throw interruptedException;
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            if (string.equals("Top level failure!")) {
                return null;
            }
            while (!string.equals("----------")) {
                arrayList.add(string);
                string = bufferedReader.readLine();
                if (string != null) continue;
                return null;
            }
            Solution solution = this.solverSolToAST(arrayList, symbolTable);
            return solution;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        Serializable serializable;
        Serializable serializable2 = null;
        while (true) {
            serializable = new ArrayList();
            try {
                String string = bufferedReader.readLine();
                if (string == null || string.equals("Top level failure!")) break;
                if (string.equals("=====UNSATISFIABLE=====")) {
                    this.stats.putValue("SolverSatisfiable", "0");
                    this.extractSolverStats(bufferedReader);
                    break;
                }
                if (string.contains("Time limit exceeded!")) {
                    this.stats.putValue("SolverTimeOut", "1");
                    this.stats.putValue("SolverSatisfiable", "0");
                }
                if (string.equals("==========")) {
                    this.extractSolverStats(bufferedReader);
                    break;
                }
                while (!string.equals("----------")) {
                    ((ArrayList)serializable).add(string);
                    string = bufferedReader.readLine();
                    if (string != null) continue;
                }
                serializable2 = serializable;
                if (string == null || !string.equals("----------")) continue;
                this.extractSolverStats(bufferedReader);
            }
            catch (IOException iOException) {
                break;
            }
        }
        if (serializable2 != null) {
            serializable = this.solverSolToAST((ArrayList<String>)serializable2, symbolTable);
            return serializable;
        }
        return null;
    }

    private void extractSolverStats(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("%%%mzn-stat: nodes")) continue;
                this.stats.putValue("SolverNodes", string.split("=")[1]);
            }
        }
        catch (IOException iOException) {
        }
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray;
            String string = arrayList.get(i);
            if (string.isEmpty() || (stringArray = string.split(" = ")).length != 2) continue;
            String[] stringArray2 = stringArray[1].split(";");
            String string2 = stringArray2[0].trim();
            if (string2.equals("true")) {
                hashMap.put(stringArray[0], 1L);
                continue;
            }
            if (string2.equals("false")) {
                hashMap.put(stringArray[0], 0L);
                continue;
            }
            hashMap.put(stringArray[0], Long.parseLong(string2));
        }
        return hashMap;
    }

    class ReadFznOutput
    extends ReadProcessOutput {
        BufferedReader br;
        FznSolver fs;
        SymbolTable st;

        ReadFznOutput(FznSolver fznSolver2, SymbolTable symbolTable) {
            this.fs = fznSolver2;
            this.st = symbolTable;
        }

        @Override
        public void giveInputStream(BufferedReader bufferedReader) {
            this.br = bufferedReader;
        }

        @Override
        public void run() {
            if (!(CmdFlags.getFindAllSolutions() || CmdFlags.getFindNumSolutions() != -1L && CmdFlags.getFindNumSolutions() != 1L)) {
                Solution solution = this.fs.parseLastSolverSolution(this.st, this.br);
                if (solution != null || this.st.m.incumbentSolution != null) {
                    this.fs.createSolutionFile(solution != null ? solution : this.st.m.incumbentSolution, false);
                }
            } else {
                this.fs.parseAllSolverSolutions(this.st, this.br);
            }
        }
    }
}

