/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.And;
import savilerow.BinOp;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.Equals;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.SymbolTable;

public class GlobalCard
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public GlobalCard(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        assert (this.numChildren() == 3);
        return new GlobalCard(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp() && this.getChild(2).strongProp();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 3; ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() == 1) continue;
            CmdFlags.println("ERROR: Expected one-dimensional matrix for each argument of gcc constraint: " + this);
            return false;
        }
        if (this.getChild(1).getCategory() > 2) {
            CmdFlags.println("ERROR: Expected no decision variables in second argument of gcc constraint: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        ASTNode aSTNode3 = this.getChildConst(2);
        if (aSTNode2 instanceof EmptyMatrix && aSTNode3 instanceof EmptyMatrix) {
            return new BooleanConstant(true);
        }
        if (aSTNode.isMatrixLiteral() && aSTNode2 instanceof CompoundMatrix && aSTNode3 instanceof CompoundMatrix) {
            int n;
            int n2;
            int n3;
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            ArrayList<ASTNode> arrayList2 = aSTNode2.getChildren(1);
            ArrayList<ASTNode> arrayList3 = aSTNode3.getChildren(1);
            long l = 0L;
            long l2 = 0L;
            for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                Intpair intpair = arrayList3.get(n3).getBounds();
                if (intpair.upper < 0L || intpair.lower > (long)arrayList.size()) {
                    return new BooleanConstant(false);
                }
                l += intpair.lower;
                l2 += intpair.upper;
            }
            if (l > (long)arrayList.size()) {
                return new BooleanConstant(false);
            }
            n3 = 0;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (!arrayList.get(n2).isConstant()) continue;
                for (n = 0; n < arrayList2.size(); ++n) {
                    if (!arrayList2.get(n).equals(arrayList.get(n2))) continue;
                    arrayList3.set(n, BinOp.makeBinOp("-", arrayList3.get(n), NumberConstant.make(1L)));
                }
                arrayList.remove(n2);
                --n2;
                n3 = 1;
            }
            if (arrayList.size() == 0) {
                ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
                for (n = 0; n < arrayList3.size(); ++n) {
                    arrayList4.add(new Equals(arrayList3.get(n), NumberConstant.make(0L)));
                }
                return new And(arrayList4);
            }
            if (n3 != 0) {
                if (aSTNode == this.getChild(0)) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        arrayList.get(n2).setParent(null);
                    }
                }
                if (aSTNode2 == this.getChild(1)) {
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList2.get(n2).setParent(null);
                    }
                }
                if (aSTNode3 == this.getChild(2)) {
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        arrayList3.get(n2).setParent(null);
                    }
                }
                return new GlobalCard(CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2), CompoundMatrix.make(arrayList3));
            }
        }
        return null;
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList;
        boolean bl;
        if (this.getChild(0) instanceof CompoundMatrix && (bl = GlobalCard.sortByHashcode(arrayList = this.getChild(0).getChildren(1)))) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            this.getChild(1).setParent(null);
            this.getChild(2).setParent(null);
            return new GlobalCard(new CompoundMatrix(arrayList), this.getChild(1), this.getChild(2));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        ArrayList<ASTNode> arrayList;
        boolean bl;
        if (this.getChild(0) instanceof CompoundMatrix && (bl = GlobalCard.sortByAlpha(arrayList = this.getChild(0).getChildren(1)))) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            this.getChild(1).setParent(null);
            this.getChild(2).setParent(null);
            return new GlobalCard(new CompoundMatrix(arrayList), this.getChild(1), this.getChild(2));
        }
        return null;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("gccweak(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(2).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("gcc(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("),flatten(");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append("),flatten(");
        this.getChild(2).toDominion(stringBuilder, false);
        stringBuilder.append("))");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getGecodetrans()) {
            bufferedWriter.append("constraint gecode_global_cardinality(");
        } else {
            bufferedWriter.append("constraint global_cardinality(");
        }
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(2).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(")::domain;");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("global_cardinality(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "gcc(" + this.getChild(0) + "," + this.getChild(1) + "," + this.getChild(2) + ")";
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        GlobalCard.toAlternateJSON(this, stringBuilder);
    }

    public static void toAlternateJSON(ASTNode aSTNode, StringBuilder stringBuilder) {
        aSTNode.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"children\": [\n");
        aSTNode.getChild(0).toJSON(stringBuilder);
        stringBuilder.append(",\n");
        ASTNode aSTNode2 = aSTNode.getChildConst(1);
        ASTNode aSTNode3 = aSTNode.getChildConst(2);
        int n = aSTNode2.numChildren();
        stringBuilder.append("{\n\"type\": \"pairList\",\n");
        stringBuilder.append("\"symmetricChildren\": true,\n");
        stringBuilder.append("\"children\": [");
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("\n{\n\"type\": \"pair\",\n\"symmetricChildren\": false,\n");
            stringBuilder.append("\"children\": [\n");
            aSTNode2.getChild(i).toJSON(stringBuilder);
            stringBuilder.append(",\n");
            aSTNode3.getChild(i).toJSON(stringBuilder);
            stringBuilder.append("]\n}");
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}]}");
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return n == 0;
    }
}

