/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BinOp;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Divide;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.Less;
import savilerow.NumberConstant;
import savilerow.Pair;
import savilerow.SATLiteral;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.ShiftMapper;
import savilerow.Top;
import savilerow.UnaryMinus;
import savilerow.WeightedSum;

public class LessEqual
extends BinOp {
    public static final long serialVersionUID = 1L;
    static boolean useOrderEnc = true;

    public LessEqual(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new LessEqual(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return true;
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        assert (!(this.getChild(0) instanceof WeightedSum) || !(this.getChild(1) instanceof WeightedSum));
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() > 2) {
            ((WeightedSum)this.getChild(0)).toDominionLeq(stringBuilder, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() > 2) {
            ((WeightedSum)this.getChild(1)).toDominionGeq(stringBuilder, this.getChild(0));
            return;
        }
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("leq(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public ASTNode simplify() {
        Pair<ASTNode, ASTNode> pair;
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.upper <= intpair2.lower) {
            return new BooleanConstant(true);
        }
        if (intpair.lower > intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            if (this.getChild(0).getValue() <= this.getChild(1).getValue()) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1) instanceof WeightedSum) {
            this.detachChildren();
            return new LessEqual(BinOp.makeBinOp("-", this.getChild(0), this.getChild(1)), NumberConstant.make(0L));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() == 3 && this.getChild(1).getCategory() < 3 && (pair = ((WeightedSum)this.getChild(0)).retrieveConstant()) != null) {
            this.getChild(1).setParent(null);
            return new LessEqual(pair.getSecond(), BinOp.makeBinOp("-", this.getChild(1), pair.getFirst()));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() == 3 && this.getChild(0).getCategory() < 3 && (pair = ((WeightedSum)this.getChild(1)).retrieveConstant()) != null) {
            this.getChild(0).setParent(null);
            return new LessEqual(BinOp.makeBinOp("-", this.getChild(0), pair.getFirst()), pair.getSecond());
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1).isConstant() && (pair = ((WeightedSum)this.getChild(0)).factorOutGCD()) != null) {
            long l = pair.getFirst().getValue();
            long l2 = this.getChild(1).getValue();
            long l3 = Divide.div(l2, l);
            return new LessEqual(pair.getSecond(), NumberConstant.make(l3));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(0).isConstant() && (pair = ((WeightedSum)this.getChild(1)).factorOutGCD()) != null) {
            long l = pair.getFirst().getValue();
            long l4 = this.getChild(0).getValue();
            long l5 = Divide.divceil(l4, l);
            return new LessEqual((ASTNode)NumberConstant.make(l5), pair.getSecond());
        }
        return null;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        if (!(!CmdFlags.getSattrans() || bl || CmdFlags.getSMTtrans() && this.willSMTEncode())) {
            ASTNode aSTNode = this.getParent();
            if (aSTNode instanceof Top || aSTNode instanceof And && aSTNode.getParent() instanceof Top) {
                return false;
            }
            return (!this.getChild(0).isConstant() || !(this.getChild(1) instanceof Identifier)) && (!this.getChild(1).isConstant() || !(this.getChild(0) instanceof Identifier));
        }
        return super.toFlatten(bl);
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new Less(this.getChild(1), this.getChild(0));
    }

    @Override
    public int polarity(int n) {
        return n == 0 ? -1 : 1;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        assert (!(this.getChild(0) instanceof WeightedSum) || !(this.getChild(1) instanceof WeightedSum));
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toMinionLeq(bufferedWriter, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toMinionGeq(bufferedWriter, this.getChild(0));
            return;
        }
        if (this.getChild(0) instanceof UnaryMinus) {
            WeightedSum weightedSum = new WeightedSum(this.getChild(0).getChild(0), -1L);
            weightedSum.toMinionLeq(bufferedWriter, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof UnaryMinus) {
            WeightedSum weightedSum = new WeightedSum(this.getChild(1).getChild(0), -1L);
            weightedSum.toMinionGeq(bufferedWriter, this.getChild(0));
            return;
        }
        bufferedWriter.append("ineq(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", 0)");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("<=");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "<=" + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toFlatzincLeq(bufferedWriter, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toFlatzincGeq(bufferedWriter, this.getChild(0));
            return;
        }
        bufferedWriter.append("constraint int_le(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("<=");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            if (this.getChild(1) instanceof SATLiteral) {
                assert (this.getChild(0).getValue() == 1L);
                return ((SATLiteral)this.getChild(1)).getLit();
            }
            if (this.getChild(1) instanceof Identifier) {
                return -sat.getOrderVariable(this.getChild(1).toString(), this.getChild(0).getValue() - 1L);
            }
        }
        if (this.getChild(1).isConstant()) {
            if (this.getChild(0) instanceof SATLiteral) {
                assert (this.getChild(1).getValue() == 0L);
                return -((SATLiteral)this.getChild(0)).getLit();
            }
            if (this.getChild(0) instanceof Identifier) {
                return sat.getOrderVariable(this.getChild(0).toString(), this.getChild(1).getValue());
            }
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (!(this.getChild(0) instanceof WeightedSum) || !(this.getChild(1) instanceof WeightedSum));
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toSATLeq(sat, this.getChild(1).getValue());
        } else if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toSATGeq(sat, this.getChild(0).getValue());
        } else if (useOrderEnc) {
            this.toSATOrderEnc(sat, 0L);
        } else {
            sat.supportEncodingBinary(this, this.getChild(0), this.getChild(1));
        }
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        if (this.usesSMTEncoding()) {
            sMT.addSMTClause(this.smtEncodeBool(sMT));
        } else {
            this.toSAT(sMT);
        }
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL() && this.canIDLEncode();
    }

    @Override
    public boolean canIDLEncode() {
        if (this.getChild(0) instanceof Identifier && this.getChild(1) instanceof Identifier) {
            return true;
        }
        if (this.getChild(0) instanceof ShiftMapper && this.getChild(1) instanceof Identifier) {
            return true;
        }
        if (this.getChild(0) instanceof Identifier && this.getChild(1) instanceof ShiftMapper) {
            return true;
        }
        boolean bl = this.getChild(0) instanceof NumberConstant && this.getChild(1).canIDLEncode();
        boolean bl2 = this.getChild(0).canIDLEncode() && this.getChild(1) instanceof NumberConstant;
        return bl || bl2;
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        if (CmdFlags.getUseNIA() || CmdFlags.getUseLIA()) {
            String string = "(<= ";
            string = string + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
            return string;
        }
        if (CmdFlags.getUseBV()) {
            String string = "(bvsle ";
            string = string + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")";
            return string;
        }
        if (CmdFlags.getUseIDL()) {
            String string = "(<= ";
            string = string + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
            return string;
        }
        return null;
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + SMT.toSMTBV(1L) + " " + SMT.toSMTBV(0L) + ")";
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toSATLeqWithAuxVar(sat, this.getChild(1).getValue(), l);
        } else if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toSATGeqWithAuxVar(sat, this.getChild(0).getValue(), l);
        } else if (useOrderEnc) {
            this.toSATOrderEnc(sat, -l);
            new Less(this.getChild(1), this.getChild(0)).toSATOrderEnc(sat, l);
        } else {
            sat.supportEncodingBinaryWithAuxVar(this, this.getChild(0), this.getChild(1), l);
        }
    }

    public void toSATOrderEnc(Sat sat, long l) throws IOException {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        arrayList = Intpair.union(arrayList, this.getChild(1).getIntervalSetExp());
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                if (l != 0L) {
                    sat.addClause(this.getChild(0).orderEncode(sat, i), -this.getChild(1).orderEncode(sat, i), l);
                    continue;
                }
                sat.addClause(this.getChild(0).orderEncode(sat, i), -this.getChild(1).orderEncode(sat, i));
            }
        }
    }

    @Override
    public boolean test(long l, long l2) {
        return l <= l2;
    }
}

