/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.Model;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.Solution;
import savilerow.Solver;
import savilerow.Stats;
import savilerow.SymbolTable;

public class MznSolver
extends Solver {
    private Stats stats = null;

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        this.runMznSolver(string, string2, model);
    }

    private void runMznSolver(String string, String string2, Model model) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (CmdFlags.getFindAllSolutions()) {
                if (model.objective != null) {
                    CmdFlags.warning("Ignoring -all-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindAllSolutions(false);
                } else {
                    CmdFlags.errorExit("Don't know how to do all solutions with minizinc, sorry.");
                }
            }
            if (CmdFlags.getFindNumSolutions() > 1L) {
                if (model.objective != null) {
                    CmdFlags.warning("Ignoring -num-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindNumSolutions(1L);
                } else {
                    CmdFlags.errorExit("Don't know how to do multiple solutions with minizinc, sorry.");
                }
            }
            arrayList.add(string2);
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
            this.stats = new Stats();
            this.stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.stats.putValue("SolverSatisfiable", "1");
            this.stats.putValue("SolverTimeOut", "0");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ReadGecodeOutput readGecodeOutput = new ReadGecodeOutput(this, model.global_symbols);
            double d2 = System.currentTimeMillis();
            int n = RunCommand.runCommand(true, arrayList, arrayList2, readGecodeOutput);
            d2 = ((double)System.currentTimeMillis() - d2) / 1000.0;
            this.stats.putValue("SolverTotalTime", String.valueOf(d2));
            if (d2 > (double)CmdFlags.getTimeLimit()) {
                this.stats.putValue("SolverTimeOut", "1");
            }
            if (arrayList2.size() != 0 || n != 0) {
                CmdFlags.println("Solver exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
                CmdFlags.rmTempFiles();
            }
            this.stats.makeInfoFiles();
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            System.err.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            throw interruptedException;
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            if (string.equals("Top level failure!")) {
                return null;
            }
            while (!string.equals("----------")) {
                arrayList.add(string);
                string = bufferedReader.readLine();
                if (string != null) continue;
                return null;
            }
            Solution solution = this.solverSolToAST(arrayList, symbolTable);
            return solution;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        Serializable serializable;
        Serializable serializable2 = null;
        while (true) {
            serializable = new ArrayList();
            try {
                String string = bufferedReader.readLine();
                if (string == null || string.equals("Top level failure!")) break;
                if (string.equals("=====UNSATISFIABLE=====")) {
                    this.stats.putValue("SolverSatisfiable", "0");
                    break;
                }
                if (string.equals("=====UNKNOWN=====")) {
                    this.stats.putValue("SolverTimeOut", "1");
                    this.stats.putValue("SolverSatisfiable", "0");
                }
                if (string.equals("==========")) break;
                while (!string.equals("----------")) {
                    ((ArrayList)serializable).add(string);
                    string = bufferedReader.readLine();
                    if (string != null) continue;
                }
                serializable2 = serializable;
            }
            catch (IOException iOException) {
                break;
            }
        }
        if (serializable2 != null) {
            serializable = this.solverSolToAST((ArrayList<String>)serializable2, symbolTable);
            return serializable;
        }
        return null;
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray;
            String string = arrayList.get(i);
            if (string.isEmpty() || (stringArray = string.split(";")[0].split(" = ")).length != 2 || stringArray[0].equals(stringArray[1])) continue;
            String string2 = stringArray[1].trim();
            if (string2.equals("true")) {
                hashMap.put(stringArray[0], 1L);
                continue;
            }
            if (string2.equals("false")) {
                hashMap.put(stringArray[0], 0L);
                continue;
            }
            hashMap.put(stringArray[0], Long.parseLong(string2));
        }
        return hashMap;
    }

    class ReadGecodeOutput
    extends ReadProcessOutput {
        BufferedReader br;
        MznSolver gs;
        SymbolTable st;

        ReadGecodeOutput(MznSolver mznSolver2, SymbolTable symbolTable) {
            this.gs = mznSolver2;
            this.st = symbolTable;
        }

        @Override
        public void giveInputStream(BufferedReader bufferedReader) {
            this.br = bufferedReader;
        }

        @Override
        public void run() {
            if (!CmdFlags.getFindAllSolutions() && CmdFlags.getFindNumSolutions() == 1L) {
                Solution solution = this.gs.parseLastSolverSolution(this.st, this.br);
                if (solution != null || this.st.m.incumbentSolution != null) {
                    this.gs.createSolutionFile(solution != null ? solution : this.st.m.incumbentSolution, false);
                }
            } else {
                this.gs.parseAllSolverSolutions(this.st, this.br);
            }
        }
    }
}

