/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BinOp;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Element;
import savilerow.EmptyMatrix;
import savilerow.Intpair;
import savilerow.Max;
import savilerow.Min;
import savilerow.NumberConstant;
import savilerow.PairASTNode;

public class SafeElement
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public SafeElement(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        assert (!aSTNode2.isSet());
    }

    @Override
    public ASTNode copy() {
        return new SafeElement(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        if (this.isNumerical()) {
            return true;
        }
        return super.toFlatten(bl);
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
            if (this.getChild(1).isConstant()) {
                long l = this.getChild(1).getValue();
                if (l < 0L || l >= (long)(this.getChild(0).numChildren() - 1)) {
                    return NumberConstant.make(0L);
                }
                ASTNode aSTNode2 = aSTNode.getChild((int)l + 1);
                if (aSTNode == this.getChild(0)) {
                    aSTNode2.setParent(null);
                }
                return aSTNode2;
            }
            if (aSTNode.numChildren() == 2) {
                if (aSTNode == this.getChild(0)) {
                    aSTNode.getChild(1).setParent(null);
                }
                return aSTNode.getChild(1);
            }
        }
        if (aSTNode instanceof CompoundMatrix) {
            Intpair intpair = this.getChild(1).getBounds();
            int n = aSTNode.numChildren() - 1;
            if (intpair.upper < (long)(n - 1)) {
                int n2 = (int)intpair.upper + 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(n2);
                if (aSTNode == this.getChild(0)) {
                    aSTNode.detachChildren();
                }
                this.getChild(1).setParent(null);
                for (int i = 1; i <= n2; ++i) {
                    arrayList.add(aSTNode.getChild(i));
                }
                return new SafeElement(CompoundMatrix.make(arrayList), this.getChild(1));
            }
            if (this.getChild(1).toFlatten(false) && (intpair.lower > 0L || intpair.upper < (long)(n - 1))) {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>((int)(intpair.upper - intpair.lower + 1L));
                if (intpair.lower < 0L) {
                    intpair.lower = 0L;
                }
                if (intpair.upper > (long)(n - 1)) {
                    intpair.upper = n - 1;
                }
                if (aSTNode == this.getChild(0)) {
                    aSTNode.detachChildren();
                }
                this.getChild(1).setParent(null);
                int n3 = (int)intpair.lower;
                while ((long)n3 <= intpair.upper) {
                    arrayList.add(aSTNode.getChild(n3 + 1));
                    ++n3;
                }
                return new SafeElement(CompoundMatrix.make(arrayList), BinOp.makeBinOp("-", this.getChild(1), NumberConstant.make(intpair.lower)));
            }
        }
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            int n = this.getChild(0).numChildren() - 1;
            Intpair intpair = this.getChild(1).getBounds();
            if (intpair.lower >= 0L && intpair.upper < (long)n) {
                this.detachChildren();
                return new Element(this.getChild(0), this.getChild(1));
            }
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower > 0L) {
            intpair.lower = 0L;
        }
        if (intpair.upper < 0L) {
            intpair.upper = 0L;
        }
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        pairASTNode.e1 = new Min(pairASTNode.e1, NumberConstant.make(0L));
        pairASTNode.e2 = new Max(pairASTNode.e2, NumberConstant.make(0L));
        return pairASTNode;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(1);
        arrayList.add(new Intpair(0L, 0L));
        return Intpair.union(arrayList, this.getChild(0).getIntervalSetExp());
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        assert (this.isRelation());
        this.toMinionWithAuxVar(bufferedWriter, new BooleanConstant(true));
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        if (CmdFlags.getUseBoundVars() && (aSTNode.exceedsBoundThreshold() || this.getChild(0).exceedsBoundThreshold() || this.getChild(1).exceedsBoundThreshold())) {
            bufferedWriter.append("element_undefzero(");
        } else {
            bufferedWriter.append("watchelement_undefzero(");
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("element(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }
}

