/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.AMOEnc;
import savilerow.ASTNode;
import savilerow.CmdFlags;
import savilerow.Equals;
import savilerow.Intpair;
import savilerow.LessEqual;
import savilerow.NumberConstant;
import savilerow.NumberMap;
import savilerow.SATLiteral;
import savilerow.SymbolTable;
import savilerow.ToVariable;
import savilerow.WeightedSum;
import savilerow.categoryentry;

public class Sat {
    protected long variableNumber = 1L;
    protected long numClauses = 0L;
    protected TLongObjectHashMap<NumberMap> dimacsMapping = new TLongObjectHashMap();
    public TLongObjectHashMap<NumberMap> orderMappingMin;
    public TLongObjectHashMap<NumberMap> orderMappingMid;
    public TLongObjectHashMap<NumberMap> orderMappingMax;
    private TObjectLongHashMap<NumberMap> directVarMapping = new TObjectLongHashMap();
    private TObjectLongHashMap<NumberMap> orderVarMapping = new TObjectLongHashMap();
    protected SymbolTable global_symbols;
    protected FileOutputStream fw;
    protected BufferedWriter outstream;
    protected long trueVar;
    private long top = 1000000000L;
    private long variableNumberBak;
    private long numClausesBak;
    private long filesizeBak;
    protected long numClausesBackup = 0L;
    protected long filesizeBackup = 0L;
    public static int commanderPartSize = 3;

    public Sat(SymbolTable symbolTable) {
        this.orderMappingMin = new TLongObjectHashMap();
        this.orderMappingMid = new TLongObjectHashMap();
        this.orderMappingMax = new TLongObjectHashMap();
        this.global_symbols = symbolTable;
        assert (this.directVarMapping.getNoEntryValue() == 0L);
        assert (this.orderVarMapping.getNoEntryValue() == 0L);
        try {
            String string = CmdFlags.getSMTtrans() ? CmdFlags.smtfile : CmdFlags.satfile;
            this.fw = new FileOutputStream(string);
            this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
            this.createHeader();
            this.trueVar = this.getNextVariableNumber();
            this.addClause(this.trueVar);
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Failed to open or write to SAT output file.");
        }
    }

    protected void createHeader() throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.outstream.write("          ");
        }
        this.outstream.newLine();
    }

    public void BTMark() throws IOException {
        this.variableNumberBak = this.variableNumber;
        this.numClausesBak = this.numClauses;
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.satfile, "rws");
        this.filesizeBak = randomAccessFile.length();
        randomAccessFile.close();
    }

    public void BTRestore() throws IOException {
        this.variableNumber = this.variableNumberBak;
        this.numClauses = this.numClausesBak;
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.satfile, "rws");
        randomAccessFile.setLength(this.filesizeBak);
        randomAccessFile.close();
        this.reopenFile();
        this.finaliseOutput();
    }

    public void reopenFile() throws IOException {
        this.fw = new FileOutputStream(CmdFlags.satfile, true);
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
    }

    protected long getNextVariableNumber() {
        return this.variableNumber++;
    }

    public NumberMap getDimacsMapping(long l) {
        return this.dimacsMapping.get(l);
    }

    private long createSatVariableDirect(String string, long l) {
        NumberMap numberMap = new NumberMap(l, string);
        long l2 = this.getNextVariableNumber();
        this.directVarMapping.put(numberMap, l2);
        this.dimacsMapping.put(l2, numberMap);
        return l2;
    }

    private long createSatVariableOrder(String string, long l) {
        NumberMap numberMap = new NumberMap(l, string);
        long l2 = this.getNextVariableNumber();
        this.orderVarMapping.put(numberMap, l2);
        return l2;
    }

    public long getOrderVariable(String string, long l) {
        long l2 = this.orderVarMapping.get(new NumberMap(l, string));
        if (l2 == this.orderVarMapping.getNoEntryValue()) {
            Intpair intpair = this.global_symbols.getDomain(string).getBounds();
            if (l < intpair.lower) {
                return -this.trueVar;
            }
            if (l >= intpair.upper) {
                return this.trueVar;
            }
            ArrayList<Intpair> arrayList = this.global_symbols.getDomain(string).getIntervalSet();
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                Intpair intpair2 = arrayList.get(i);
                Intpair intpair3 = arrayList.get(i + 1);
                if (l <= intpair2.upper || l >= intpair3.lower) continue;
                long l3 = this.orderVarMapping.get(new NumberMap(intpair2.upper, string));
                assert (l3 != this.orderVarMapping.getNoEntryValue());
                return l3;
            }
            assert (false);
            return 1L;
        }
        return l2;
    }

    public long getDirectVariable(String string, long l) {
        long l2 = this.directVarMapping.get(new NumberMap(l, string));
        if (l2 == this.directVarMapping.getNoEntryValue()) {
            return -this.trueVar;
        }
        return l2;
    }

    public long getTrue() {
        return this.trueVar;
    }

    public long createAuxSATVariable() {
        return this.getNextVariableNumber();
    }

    public ASTNode createAuxSATVariableAST() {
        long l = this.createAuxSATVariable();
        return new SATLiteral(l, this.global_symbols.m);
    }

    public void generateVariableEncoding(HashSet<String> hashSet) throws IOException {
        categoryentry categoryentry2 = this.global_symbols.getCategoryFirst();
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                String string = this.global_symbols.represents_ct.get(categoryentry2.name);
                if (string == null) {
                    string = "";
                }
                this.addComment("Encoding variable: " + categoryentry2.name + " with domain: " + this.global_symbols.getDomain(categoryentry2.name) + " (representing constraint " + string + ")");
                ASTNode aSTNode = this.global_symbols.getDomain(categoryentry2.name);
                ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
                long l = Intpair.numValues(arrayList);
                if (l <= 0L) {
                    this.addClause(-this.getTrue());
                } else if (l == 1L) {
                    this.generateVariableEncoding1Val(categoryentry2.name);
                } else if (l == 2L) {
                    this.generateVariableEncoding2Vals(categoryentry2.name, !hashSet.contains(categoryentry2.name));
                } else {
                    this.generateVariableEncodingNVals(categoryentry2.name);
                }
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public void generateVariableEncoding1Val(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        Intpair intpair = aSTNode.getBounds();
        assert (intpair.upper == intpair.lower);
        long l = intpair.lower;
        long l2 = this.getNextVariableNumber();
        this.addComment("Var represented with SAT variable " + l2);
        NumberMap numberMap = new NumberMap(l, string);
        this.directVarMapping.put(numberMap, this.getTrue());
        this.addClause(l2);
        this.dimacsMapping.put(l2, numberMap);
    }

    public void generateVariableEncoding2Vals(String string, boolean bl) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        Intpair intpair = aSTNode.getBounds();
        long l = intpair.lower;
        long l2 = intpair.upper;
        long l3 = this.getNextVariableNumber();
        this.addComment("Var represented with SAT variable " + l3);
        NumberMap numberMap = new NumberMap(l, string);
        NumberMap numberMap2 = new NumberMap(l2, string);
        this.directVarMapping.put(numberMap2, l3);
        this.directVarMapping.put(numberMap, -l3);
        this.orderVarMapping.put(numberMap2, this.trueVar);
        this.orderVarMapping.put(numberMap, -l3);
        this.dimacsMapping.put(l3, numberMap2);
        this.dimacsMapping.put(-l3, numberMap);
        if (bl) {
            this.addClause(l3, -l3);
        }
    }

    public void generateVariableEncodingNVals(String string) throws IOException {
        if (CmdFlags.getSMTtrans()) {
            if (this.global_symbols.isDirectSAT(string)) {
                this.generateVariableEncodingInteger(string);
            } else {
                this.generateVariableEncodingIntegerNoDirect(string);
            }
        } else if (this.global_symbols.isDirectSAT(string)) {
            if (this.global_symbols.isOrderSAT(string)) {
                this.addComment("Both direct and order encoding.");
                this.generateVariableEncodingInteger(string);
            } else {
                this.addComment("Direct encoding.");
                this.generateVariableEncodingIntegerNoOrder(string);
            }
        } else {
            this.addComment("Order encoding.");
            this.generateVariableEncodingIntegerNoDirect(string);
        }
    }

    public void generateVariableEncodingInteger(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        long l = -this.trueVar;
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                NumberMap numberMap;
                long l2;
                boolean bl = j == intpair.lower && i == 0;
                boolean bl2 = j == intpair.upper && i == arrayList.size() - 1;
                long l3 = this.trueVar;
                if (!bl2) {
                    l3 = this.createSatVariableOrder(string, j);
                    if (l != -this.trueVar) {
                        this.addClause(-l, l3);
                    }
                }
                if (bl2) {
                    l2 = -l;
                    numberMap = new NumberMap(j, string);
                    this.directVarMapping.put(numberMap, l2);
                    this.dimacsMapping.put(l2, numberMap);
                } else if (bl) {
                    l2 = l3;
                    numberMap = new NumberMap(j, string);
                    this.directVarMapping.put(numberMap, l2);
                    this.dimacsMapping.put(l2, numberMap);
                } else {
                    l2 = this.createSatVariableDirect(string, j);
                }
                if (!bl && !bl2) {
                    this.addClause(l, -l3, l2);
                    this.addClause(-l2, l3);
                    this.addClause(-l2, -l);
                }
                l = l3;
            }
        }
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                arrayList2.add(this.getDirectVariable(string, j));
            }
        }
        this.addClause(arrayList2);
    }

    public void generateVariableEncodingIntegerNoOrder(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                long l = this.createSatVariableDirect(string, j);
                arrayList2.add(new SATLiteral(l, this.global_symbols.m));
            }
        }
        this.productEncodingAMO(arrayList2, true);
    }

    public void generateVariableEncodingIntegerNoDirect(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        long l = -this.trueVar;
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                boolean bl = j == intpair.upper && i == arrayList.size() - 1;
                NumberMap numberMap = new NumberMap(j, string);
                if (!bl) {
                    long l2 = this.createSatVariableOrder(string, j);
                    if (l != -this.trueVar) {
                        this.addClause(-l, l2);
                        this.orderMappingMid.put(l2, numberMap);
                    } else {
                        this.orderMappingMin.put(l2, numberMap);
                    }
                    l = l2;
                    continue;
                }
                this.orderMappingMax.put(-l, numberMap);
            }
        }
    }

    protected void clauseStart() throws IOException {
    }

    protected void clauseEnd() throws IOException {
        this.outstream.write("0");
        this.outstream.newLine();
    }

    protected void writeLiteral(long l) throws IOException {
        this.outstream.write(String.valueOf(l));
        this.outstream.write(" ");
    }

    public void addClause(long l) throws IOException {
        this.clauseStart();
        if (CmdFlags.getMaxsattrans()) {
            this.writeLiteral(this.top);
        }
        if (l != -this.trueVar) {
            this.writeLiteral(l);
        }
        this.clauseEnd();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClause(long l, long l2) throws IOException {
        if (l == this.trueVar || l2 == this.trueVar) {
            return;
        }
        this.clauseStart();
        if (CmdFlags.getMaxsattrans()) {
            this.writeLiteral(this.top);
        }
        if (l != -this.trueVar) {
            this.writeLiteral(l);
        }
        if (l2 != -this.trueVar) {
            this.writeLiteral(l2);
        }
        this.clauseEnd();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClause(long l, long l2, long l3) throws IOException {
        if (l == this.trueVar || l2 == this.trueVar || l3 == this.trueVar) {
            return;
        }
        this.clauseStart();
        if (CmdFlags.getMaxsattrans()) {
            this.writeLiteral(this.top);
        }
        if (l != -this.trueVar) {
            this.writeLiteral(l);
        }
        if (l2 != -this.trueVar) {
            this.writeLiteral(l2);
        }
        if (l3 != -this.trueVar) {
            this.writeLiteral(l3);
        }
        this.clauseEnd();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClause(ArrayList<Long> arrayList) throws IOException {
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) != this.trueVar) continue;
            return;
        }
        this.clauseStart();
        if (CmdFlags.getMaxsattrans()) {
            this.writeLiteral(this.top);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) == -this.trueVar) continue;
            this.writeLiteral(arrayList.get(n));
        }
        this.clauseEnd();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClauseReified(ArrayList<Long> arrayList, long l) throws IOException {
        int n;
        this.clauseStart();
        if (CmdFlags.getMaxsattrans()) {
            this.writeLiteral(this.top);
        }
        this.writeLiteral(-l);
        for (n = 0; n < arrayList.size(); ++n) {
            this.writeLiteral(arrayList.get(n));
        }
        this.clauseEnd();
        ++this.numClauses;
        for (n = 0; n < arrayList.size(); ++n) {
            this.clauseStart();
            if (CmdFlags.getMaxsattrans()) {
                this.writeLiteral(this.top);
            }
            this.writeLiteral(-arrayList.get(n).longValue());
            this.writeLiteral(l);
            this.clauseEnd();
            ++this.numClauses;
        }
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addComment(String string) throws IOException {
        this.outstream.write("c ");
        this.outstream.write(string);
        this.outstream.newLine();
    }

    public void addSoftClause(long l) throws IOException {
        assert (CmdFlags.getMaxsattrans());
        this.addSoftClause(l, 1L);
    }

    public void addSoftClause(long l, long l2) throws IOException {
        assert (CmdFlags.getMaxsattrans());
        this.outstream.write(String.valueOf(l2));
        this.outstream.write(" ");
        this.outstream.write(String.valueOf(l));
        this.outstream.write(" 0");
        this.outstream.newLine();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void finaliseOutput() throws IOException {
        this.outstream.flush();
        this.fw.getFD().sync();
        this.outstream.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.satfile, "rws");
        randomAccessFile.seek(0L);
        byte[] byArray = CmdFlags.getMaxsattrans() ? ("p wcnf " + (this.variableNumber - 1L) + " " + this.numClauses + " " + this.top).getBytes() : ("p cnf " + (this.variableNumber - 1L) + " " + this.numClauses).getBytes();
        randomAccessFile.write(byArray);
        randomAccessFile.write("          ".getBytes());
        randomAccessFile.close();
    }

    public void addClauseAfterFinalise(ArrayList<Long> arrayList) throws IOException {
        this.fw = new FileOutputStream(CmdFlags.satfile, true);
        this.numClausesBackup = this.numClauses;
        this.filesizeBackup = this.fw.getChannel().position();
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.addClause(arrayList);
        this.finaliseOutput();
    }

    public void addClauseAfterFinalise(long l) throws IOException {
        this.fw = new FileOutputStream(CmdFlags.satfile, true);
        this.numClausesBackup = this.numClauses;
        this.filesizeBackup = this.fw.getChannel().position();
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.addClause(l);
        this.finaliseOutput();
    }

    public void addClauseAfterFinalise2(long l, long l2) throws IOException {
        this.fw = new FileOutputStream(CmdFlags.satfile, true);
        this.numClausesBackup = this.numClauses;
        this.filesizeBackup = this.fw.getChannel().position();
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.addClause(l);
        this.addClause(l2);
        this.finaliseOutput();
    }

    public void removeFinalClause() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.satfile, "rws");
        randomAccessFile.setLength(this.filesizeBackup);
        randomAccessFile.close();
        this.numClauses = this.numClausesBackup;
        this.fw = new FileOutputStream(CmdFlags.satfile, true);
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.finaliseOutput();
    }

    public void unaryDirectEncoding(ASTNode aSTNode, ASTNode aSTNode2) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                if (aSTNode.test(i)) continue;
                this.addClause(-aSTNode2.directEncode(this, i));
            }
        }
    }

    public void unaryDirectEncodingWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, long l) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                if (!aSTNode.test(i)) {
                    this.addClause(-l, -aSTNode2.directEncode(this, i));
                    continue;
                }
                this.addClause(l, -aSTNode2.directEncode(this, i));
            }
        }
    }

    public void directEncoding(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = aSTNode3.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (aSTNode.test(i, j)) continue;
                        this.addClause(-aSTNode2.directEncode(this, i), -aSTNode3.directEncode(this, j));
                    }
                }
            }
        }
    }

    public void directEncodingWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = aSTNode3.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (!aSTNode.test(i, j)) {
                            this.addClause(-l, -aSTNode2.directEncode(this, i), -aSTNode3.directEncode(this, j));
                            continue;
                        }
                        this.addClause(l, -aSTNode2.directEncode(this, i), -aSTNode3.directEncode(this, j));
                    }
                }
            }
        }
    }

    public void ternaryEncoding(ASTNode aSTNode, ASTNode aSTNode2) throws IOException {
        if (aSTNode2 instanceof NumberConstant) {
            this.supportEncodingBinary(aSTNode, aSTNode.getChild(0), aSTNode.getChild(1), aSTNode2.getValue());
        } else {
            this.ternaryFunctionalEncoding(aSTNode, aSTNode.getChild(0), aSTNode.getChild(1), aSTNode2);
        }
    }

    public void ternaryFunctionalEncoding(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = aSTNode3.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        long l = aSTNode.func(i, j);
                        this.addClause(-aSTNode2.directEncode(this, i), -aSTNode3.directEncode(this, j), aSTNode4.directEncode(this, l));
                    }
                }
            }
        }
    }

    public void supportEncodingBinary(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) throws IOException {
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode2, aSTNode3, false, false, 0L);
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode3, aSTNode2, true, false, 0L);
    }

    public void supportEncodingBinary(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode2, aSTNode3, false, true, l);
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode3, aSTNode2, true, true, l);
    }

    private void supportEncodingBinaryGenerateClauses(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, boolean bl, boolean bl2, long l) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = aSTNode3.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                ArrayList<Long> arrayList3 = new ArrayList<Long>();
                arrayList3.add(-aSTNode2.directEncode(this, i));
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (!(!bl2 && (!bl && aSTNode.test(i, j) || bl && aSTNode.test(j, i))) && (!bl2 || (bl || !aSTNode.test(i, j, l)) && (!bl || !aSTNode.test(j, i, l)))) continue;
                        arrayList3.add(aSTNode3.directEncode(this, j));
                    }
                }
                this.addClause(arrayList3);
            }
        }
    }

    public void supportEncodingBinaryWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        if (aSTNode2.getCategory() == 0 || aSTNode3.getCategory() == 0) {
            this.directEncodingWithAuxVar(aSTNode, aSTNode2, aSTNode3, l);
        } else {
            this.supportEncodingBinaryGenerateClausesWithAuxVar(aSTNode, aSTNode2, aSTNode3, l, false);
            this.supportEncodingBinaryGenerateClausesWithAuxVar(aSTNode, aSTNode3, aSTNode2, l, true);
        }
    }

    private void supportEncodingBinaryGenerateClausesWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l, boolean bl) throws IOException {
        ArrayList<Intpair> arrayList = aSTNode2.getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = aSTNode3.getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                ArrayList<Long> arrayList3 = new ArrayList<Long>();
                arrayList3.add(l);
                arrayList3.add(-aSTNode2.directEncode(this, i));
                ArrayList<Long> arrayList4 = new ArrayList<Long>();
                arrayList4.add(-l);
                arrayList4.add(-aSTNode2.directEncode(this, i));
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (!bl && aSTNode.test(i, j) || bl && aSTNode.test(j, i)) {
                            arrayList4.add(aSTNode3.directEncode(this, j));
                            continue;
                        }
                        arrayList3.add(aSTNode3.directEncode(this, j));
                    }
                }
                this.addClause(arrayList3);
                this.addClause(arrayList4);
            }
        }
    }

    public void ladderEncodingAMO(ArrayList<ASTNode> arrayList, boolean bl) throws IOException {
        if (!bl && !CmdFlags.getAuxNonFunctional()) {
            arrayList.add(this.createAuxSATVariableAST());
            bl = true;
        }
        this.ladderEncodingAMOinner(arrayList, bl);
    }

    public void ladderEncodingAMOinner(ArrayList<ASTNode> arrayList, boolean bl) throws IOException {
        int n;
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(arrayList.size() - 1);
        arrayList2.add(arrayList.get(0));
        for (n = 1; n < arrayList.size() - 1; ++n) {
            arrayList2.add(this.createAuxSATVariableAST());
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            this.addClause(((ASTNode)arrayList2.get(n)).directEncode(this, 0L), ((ASTNode)arrayList2.get(n + 1)).directEncode(this, 1L));
        }
        for (n = 1; n < arrayList.size(); ++n) {
            this.addClause(arrayList.get(n).directEncode(this, 0L), ((ASTNode)arrayList2.get(n - 1)).directEncode(this, 0L));
            if (n >= arrayList.size() - 1) continue;
            this.addClause(arrayList.get(n).directEncode(this, 0L), ((ASTNode)arrayList2.get(n)).directEncode(this, 1L));
        }
        if (bl) {
            this.alo(arrayList);
        }
    }

    private void alo(ArrayList<ASTNode> arrayList) throws IOException {
        ArrayList<Long> arrayList2 = new ArrayList<Long>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(arrayList.get(i).directEncode(this, 1L));
        }
        this.addClause(arrayList2);
    }

    public void productEncodingAMO(ArrayList<ASTNode> arrayList, boolean bl) throws IOException {
        if (!bl && !CmdFlags.getAuxNonFunctional()) {
            arrayList.add(this.createAuxSATVariableAST());
            bl = true;
        }
        this.productEncodingAMOinner(arrayList, bl);
    }

    public void productEncodingAMOinner(ArrayList<ASTNode> arrayList, boolean bl) throws IOException {
        int n = arrayList.size();
        if (bl) {
            this.alo(arrayList);
        }
        if (n <= 6) {
            this.AMOBinomial(arrayList, false);
        } else {
            int n2;
            int n3 = (int)Math.ceil(Math.sqrt(n));
            int n4 = (int)Math.ceil((double)n / (double)n3);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(n3);
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>(n4);
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(this.createAuxSATVariableAST());
            }
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList3.add(this.createAuxSATVariableAST());
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.addClause(arrayList.get(n2).directEncode(this, 0L), arrayList2.get(n2 % n3).directEncode(this, 1L));
                this.addClause(arrayList.get(n2).directEncode(this, 0L), arrayList3.get(n2 / n3).directEncode(this, 1L));
            }
            this.productEncodingAMOinner(arrayList2, false);
            this.productEncodingAMOinner(arrayList3, false);
        }
    }

    public void commanderEncodingAMO(ArrayList<ASTNode> arrayList, boolean bl) throws IOException {
        if (arrayList.size() <= commanderPartSize) {
            this.AMOBinomial(arrayList, bl);
        } else {
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); i += commanderPartSize) {
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>(commanderPartSize);
                for (int j = i; j < i + commanderPartSize && j < arrayList.size(); ++j) {
                    arrayList3.add(arrayList.get(j));
                }
                if (arrayList3.size() > 1) {
                    this.AMOBinomial(arrayList3, false);
                    ASTNode aSTNode = this.createAuxSATVariableAST();
                    arrayList2.add(aSTNode);
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        this.addClause(arrayList3.get(j).directEncode(this, 0L), aSTNode.directEncode(this, 1L));
                    }
                    if (!bl && CmdFlags.getAuxNonFunctional()) continue;
                    ArrayList<Long> arrayList4 = new ArrayList<Long>(arrayList3.size() + 1);
                    arrayList4.add(aSTNode.directEncode(this, 0L));
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        arrayList4.add(arrayList3.get(j).directEncode(this, 1L));
                    }
                    this.addClause(arrayList4);
                    continue;
                }
                arrayList2.add(arrayList3.get(0));
            }
            this.commanderEncodingAMO(arrayList2, bl);
        }
    }

    public void AMOBinomial(ArrayList<ASTNode> arrayList, boolean bl) throws IOException {
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                this.addClause(arrayList.get(i).directEncode(this, 0L), arrayList.get(j).directEncode(this, 0L));
            }
        }
        if (bl) {
            this.alo(arrayList);
        }
    }

    public static boolean eligibleAMO(ASTNode aSTNode) {
        if (CmdFlags.sat_amo_encoding == AMOEnc.TREE) {
            return false;
        }
        if (!aSTNode.getParent().getParent().inTopAnd()) {
            return false;
        }
        boolean bl = false;
        ASTNode aSTNode2 = aSTNode.getParent();
        if ((aSTNode2 instanceof LessEqual || aSTNode2 instanceof Equals || aSTNode2 instanceof ToVariable) && aSTNode2.getChild(0) == aSTNode && aSTNode2.getChild(1).isConstant() && aSTNode2.getChild(1).getValue() == 1L) {
            bl = true;
        } else if (aSTNode2 instanceof Equals && aSTNode2.getChild(1) == aSTNode && aSTNode2.getChild(0).isConstant() && aSTNode2.getChild(0).getValue() == 1L) {
            bl = true;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (aSTNode.getChild(i).isRelation() && ((WeightedSum)aSTNode).getWeight(i) == 1L) continue;
            bl = false;
        }
        return bl;
    }

    public long getNumVars() {
        return this.variableNumber - 1L;
    }

    public long getNumClauses() {
        return this.numClauses;
    }
}

