/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Element;
import savilerow.ElementOne;
import savilerow.Equals;
import savilerow.Identifier;
import savilerow.Iff;
import savilerow.Intpair;
import savilerow.MultiplyMapper;
import savilerow.Negate;
import savilerow.NumberConstant;
import savilerow.Or;
import savilerow.SATLiteral;
import savilerow.SMT;
import savilerow.SafeElement;
import savilerow.Sat;
import savilerow.ShiftMapper;

public class ToVariable
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ToVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ToVariable(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "=tv=" + this.getChild(1) + ")";
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof BooleanConstant || this.getChild(0) instanceof Identifier && this.getChild(0).isRelation()) {
            this.detachChildren();
            if (this.getChild(1).isRelation()) {
                return new Iff(this.getChild(0), this.getChild(1));
            }
            return new Equals(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0) instanceof NumberConstant || this.getChild(0) instanceof Identifier && this.getChild(0).isNumerical()) {
            this.detachChildren();
            return new Equals(this.getChild(0), this.getChild(1));
        }
        if (CmdFlags.getSattrans() && (this.getChild(0) instanceof ShiftMapper || this.getChild(0) instanceof MultiplyMapper)) {
            this.detachChildren();
            return new Equals(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L && this.getChild(0).isRelation()) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.lower > intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (intpair.upper < intpair2.lower) {
            return new BooleanConstant(false);
        }
        if (CmdFlags.getMiniontrans()) {
            // empty if block
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return this.getChild(1).isRelation();
    }

    @Override
    public ASTNode negation() {
        return new ToVariable(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element) && !(this.getChild(0) instanceof ElementOne)) {
            bufferedWriter.append("reify(");
            this.getChild(0).toMinion(bufferedWriter, true);
            bufferedWriter.append(", ");
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            this.getChild(0).toMinionWithAuxVar(bufferedWriter, this.getChild(1));
        }
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(0).isRelation()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("reify(");
            this.getChild(0).toDominion(stringBuilder, true);
            stringBuilder.append(", ");
            this.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            this.getChild(0).toDominionWithAuxVar(stringBuilder, this.getChild(1));
        }
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof ElementOne)) {
            if (this.getChild(0) instanceof And || this.getChild(0) instanceof Or) {
                this.getChild(0).toFlatzincWithAuxVar(bufferedWriter, this.getChild(1));
            } else {
                StringWriter stringWriter = new StringWriter();
                BufferedWriter bufferedWriter2 = new BufferedWriter(stringWriter);
                this.getChild(0).toFlatzinc(bufferedWriter2, true);
                bufferedWriter2.flush();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringWriter.toString());
                StringWriter stringWriter2 = new StringWriter();
                BufferedWriter bufferedWriter3 = new BufferedWriter(stringWriter2);
                this.getChild(1).toFlatzinc(bufferedWriter3, true);
                bufferedWriter3.flush();
                int n = stringBuffer.lastIndexOf(");");
                if (n != -1) {
                    stringBuffer.replace(n, n + 2, "," + stringWriter2.toString() + ");");
                } else {
                    n = stringBuffer.lastIndexOf(")::");
                    stringBuffer.replace(n, n + 3, "," + stringWriter2.toString() + ")::");
                }
                int n2 = stringBuffer.indexOf("(");
                stringBuffer.replace(n2, n2 + 1, "_reif(");
                bufferedWriter.append(stringBuffer);
            }
        } else {
            this.getChild(0).toFlatzincWithAuxVar(bufferedWriter, this.getChild(1));
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("( ");
        if (this.getChild(0).isRelation()) {
            this.getChild(0).toMinizinc(stringBuilder, true);
            stringBuilder.append(" <-> ");
            this.getChild(1).toMinizinc(stringBuilder, true);
        } else {
            this.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(" == ");
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        if (this.getChild(1) instanceof Identifier && ((Identifier)this.getChild(1)).isAuxiliary()) {
            stringBuilder.append(":: defines_var(");
            this.getChild(1).toMinizinc(stringBuilder, this.getChild(0).isRelation());
            stringBuilder.append(")");
        }
        stringBuilder.append(" )");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant() && (this.getChild(0) instanceof SATLiteral || this.getChild(0) instanceof Identifier)) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            if (this.getChild(1) instanceof BooleanConstant) {
                if (this.getChild(1).getValue() == 1L) {
                    this.getChild(0).toSAT(sat);
                } else {
                    assert (this.getChild(1).getValue() == 0L);
                    new Negate(this.getChild(0)).toSAT(sat);
                }
            } else {
                this.getChild(0).toSATWithAuxVar(sat, this.getChild(1).directEncode(sat, 1L));
                if (!this.getChild(1).isRelation()) {
                    ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSetExp();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                            if (j >= 0L && j <= 1L) continue;
                            sat.addClause(-this.getChild(1).directEncode(sat, j));
                        }
                    }
                }
            }
        } else {
            this.getChild(0).toSATWithAuxVar(sat, this.getChild(1));
        }
    }

    @Override
    public boolean usesSMTEncoding() {
        if (CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseBV()) {
            return this.getChild(0).usesSMTEncoding() && this.getChild(1).usesSMTEncoding();
        }
        if (CmdFlags.getUseIDL()) {
            if (this.getChild(0).isRelation()) {
                return this.getChild(0).usesSMTEncoding() && this.getChild(1).canVariableEncode();
            }
            return this.getChild(0).canVariableEncode() && this.getChild(1).canVariableEncode();
        }
        return false;
    }

    public boolean booleanBounds(Intpair intpair) {
        return intpair.lower >= 0L && intpair.upper <= 1L;
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            if (this.getChild(1) instanceof BooleanConstant) {
                if (this.getChild(1).getValue() == 1L) {
                    this.getChild(0).toSMT(sMT);
                } else {
                    assert (this.getChild(1).getValue() == 0L);
                    new Negate(this.getChild(0)).toSMT(sMT);
                }
            } else if (!this.getChild(1).isRelation()) {
                if (this.booleanBounds(this.getChild(1).getBounds())) {
                    if (this.usesSMTEncoding()) {
                        sMT.addSMTClause("(= " + this.getChild(0).smtEncodeBool(sMT) + " " + this.getChild(1).smtEncodeBool(sMT) + ")");
                    } else {
                        this.getChild(0).toSATWithAuxVar((Sat)sMT, this.getChild(1).directEncode(sMT, 1L));
                    }
                } else {
                    CmdFlags.errorExit("ToVariable Isn't Boolean");
                }
            } else {
                assert (this.getChild(1).isRelation());
                if (this.usesSMTEncoding()) {
                    sMT.addSMTClause("(= " + this.getChild(0).smtEncodeBool(sMT) + " " + this.getChild(1).smtEncodeBool(sMT) + ")");
                } else {
                    this.getChild(0).toSATWithAuxVar((Sat)sMT, this.getChild(1).directEncode(sMT, 1L));
                }
            }
        } else if (this.usesSMTEncoding()) {
            if (CmdFlags.getUseBV()) {
                sMT.addSMTClause("(= " + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")");
            } else {
                sMT.addSMTClause("(= " + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")");
            }
        } else {
            this.getChild(0).toSATWithAuxVar((Sat)sMT, this.getChild(1));
        }
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        try {
            if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
                if (this.getChild(1) instanceof BooleanConstant) {
                    if (this.getChild(1).getValue() == 1L) {
                        this.getChild(0).toSMT(sMT);
                    } else {
                        assert (this.getChild(1).getValue() == 0L);
                        new Negate(this.getChild(0)).toSMT(sMT);
                    }
                } else if (!this.getChild(1).isRelation()) {
                    if (this.booleanBounds(this.getChild(1).getBounds())) {
                        if (this.usesSMTEncoding()) {
                            sMT.addSMTClause("(= " + this.getChild(0).smtEncodeBool(sMT) + " " + this.getChild(1).smtEncodeBool(sMT) + ")");
                        } else {
                            this.getChild(0).toSATWithAuxVar((Sat)sMT, this.getChild(1).directEncode(sMT, 1L));
                        }
                    } else {
                        CmdFlags.errorExit("ToVariable Isn't Boolean");
                    }
                } else {
                    assert (this.getChild(1).isRelation());
                    if (this.usesSMTEncoding()) {
                        sMT.addSMTClause("(= " + this.getChild(0).smtEncodeBool(sMT) + " " + this.getChild(1).smtEncodeBool(sMT) + ")");
                    } else {
                        this.getChild(0).toSATWithAuxVar((Sat)sMT, this.getChild(1).directEncode(sMT, 1L));
                    }
                }
            } else {
                if (this.usesSMTEncoding()) {
                    if (CmdFlags.getUseBV()) {
                        return "(= " + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")";
                    }
                    return "(= " + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
                }
                this.getChild(0).toSATWithAuxVar((Sat)sMT, this.getChild(1));
            }
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Failed to encode ToVariable as Bool");
        }
        return "";
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            long l2;
            long l3 = sat.createAuxSATVariable();
            this.getChild(0).toSATWithAuxVar(sat, l3);
            if (this.getChild(1) instanceof SATLiteral) {
                l2 = ((SATLiteral)this.getChild(1)).getLit();
            } else {
                if (!this.getChild(1).isRelation()) {
                    System.err.println("Weird expression in output: " + this);
                }
                l2 = ((Identifier)this.getChild(1)).directEncode(sat, 1L);
            }
            sat.addClause(-l, -l3, l2);
            sat.addClause(-l, l3, -l2);
            sat.addClause(l, -l3, -l2);
            sat.addClause(l, l3, l2);
        } else {
            CmdFlags.errorExit("Missing part of toSATWithAuxVar(long) method on type ToVariable.");
        }
    }
}

