/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Equals;
import savilerow.MakeTable;
import savilerow.Mapping;
import savilerow.Model;
import savilerow.NegativeTable;
import savilerow.NodeReplacement;
import savilerow.NumberConstant;
import savilerow.Table;
import savilerow.TableShort;
import savilerow.TabulationUtils;
import savilerow.Tag;
import savilerow.TreeTransformerBottomUp;

public class TransformMakeTable
extends TreeTransformerBottomUp {
    public static boolean verbose = false;
    TabulationUtils tu;
    boolean prop;

    public TransformMakeTable(Model model, boolean bl) {
        super(model);
        this.tu = new TabulationUtils(this.m);
        this.prop = bl;
    }

    public TransformMakeTable(Model model) {
        super(model);
        this.tu = new TabulationUtils(this.m);
        this.prop = false;
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        boolean bl;
        boolean bl2 = bl = CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4;
        if (aSTNode instanceof MakeTable) {
            if (CmdFlags.make_short_tab == 0) {
                return new NodeReplacement(aSTNode.getChild(0));
            }
            TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(aSTNode.getChild(0), bl);
            if (retPair.nodereplace != null) {
                return retPair.nodereplace;
            }
            ASTNode aSTNode2 = this.tu.normalise(aSTNode.getChild(0));
            ASTNode aSTNode3 = !bl ? this.tu.makeTableLong(aSTNode2, Long.MAX_VALUE, Long.MAX_VALUE) : this.tu.makeTableShort(aSTNode2, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
            this.tu.saveToCacheNormalised(retPair.expstring, aSTNode2, aSTNode3);
            return new NodeReplacement(aSTNode3);
        }
        if (!(this.prop || CmdFlags.make_short_tab != 3 && CmdFlags.make_short_tab != 4 || aSTNode instanceof And || aSTNode.getParent() == null || !aSTNode.getParent().inTopAnd() || aSTNode instanceof Tag || !aSTNode.isRelation() || aSTNode instanceof Table || aSTNode instanceof TableShort || aSTNode instanceof NegativeTable || aSTNode instanceof BooleanConstant)) {
            if (this.heuristic(aSTNode)) {
                if (verbose) {
                    System.out.println("Trying ct:" + aSTNode);
                }
                TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(aSTNode, bl);
                if (retPair.nodereplace != null) {
                    return retPair.nodereplace;
                }
                if (this.tu.tryFailCache(retPair.expstring)) {
                    return new NodeReplacement(new Tag(aSTNode));
                }
                ASTNode aSTNode4 = this.tu.normalise(aSTNode);
                ASTNode aSTNode5 = CmdFlags.make_short_tab == 3 ? this.tu.makeTableLong(aSTNode4, 10000L, 100000L) : this.tu.makeTableShort(aSTNode4, 10000L, 100000L, 100000L);
                if (aSTNode5 == null) {
                    this.tu.saveToFailCache(retPair.expstring);
                    if (verbose) {
                        System.out.println("Adding to failCache:" + retPair.expstring);
                    }
                    return new NodeReplacement(new Tag(aSTNode));
                }
                if (CmdFlags.tabulate_diagnostics) {
                    CmdFlags.println("Tabulated: " + aSTNode);
                }
                this.tu.saveToCacheNormalised(retPair.expstring, aSTNode4, aSTNode5);
                return new NodeReplacement(aSTNode5);
            }
        } else if (!this.prop && (CmdFlags.make_short_tab == 3 || CmdFlags.make_short_tab == 4) && CmdFlags.tabulate_num && aSTNode.isNumerical() && !(aSTNode instanceof Mapping) && aSTNode.getDimension() == 0 && !(aSTNode instanceof NumberConstant) && aSTNode.toFlatten(false)) {
            ASTNode aSTNode6;
            System.out.println("Trying numerical expression:" + aSTNode);
            ASTNode aSTNode7 = this.m.global_symbols.newAuxHelper(aSTNode);
            Equals equals = new Equals(aSTNode, aSTNode7);
            for (aSTNode6 = aSTNode.getParent(); aSTNode6 != null && !aSTNode6.isRelation(); aSTNode6 = aSTNode6.getParent()) {
            }
            if (aSTNode6.strongProp() && !((ASTNode)equals).strongProp() || this.heuristic(equals)) {
                if (verbose) {
                    System.out.println("Trying ct:" + equals);
                }
                TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(equals, bl);
                if (retPair.nodereplace != null) {
                    this.m.global_symbols.deleteSymbol(aSTNode7.toString());
                    System.out.println("exit 1");
                    return retPair.nodereplace;
                }
                if (this.tu.tryFailCache(retPair.expstring)) {
                    this.m.global_symbols.deleteSymbol(aSTNode7.toString());
                    System.out.println("exit 2");
                    return new NodeReplacement(new Tag(aSTNode));
                }
                ASTNode aSTNode8 = this.tu.normalise(equals);
                ASTNode aSTNode9 = CmdFlags.make_short_tab == 3 ? this.tu.makeTableLong(aSTNode8, 10000L, 100000L) : this.tu.makeTableShort(aSTNode8, 10000L, 100000L, 100000L);
                if (aSTNode9 == null) {
                    this.tu.saveToFailCache(retPair.expstring);
                    if (verbose) {
                        System.out.println("Adding to failCache:" + retPair.expstring);
                    }
                    this.m.global_symbols.deleteSymbol(aSTNode7.toString());
                    System.out.println("exit 3");
                    return new NodeReplacement(new Tag(aSTNode));
                }
                if (CmdFlags.tabulate_diagnostics) {
                    CmdFlags.println("Tabulated: " + equals);
                }
                CmdFlags.warning("Extracting numerical expression: " + aSTNode + " before its containing constraint -- wrong order.");
                System.out.println("exit 4: ");
                return new NodeReplacement(aSTNode7, null, aSTNode9);
            }
            this.m.global_symbols.deleteSymbol(aSTNode7.toString());
        }
        return null;
    }

    private boolean heuristic(ASTNode aSTNode) {
        ASTNode aSTNode2;
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesDup(aSTNode);
        if (arrayList.size() < arrayList2.size() && arrayList.size() <= 10) {
            if (verbose) {
                System.out.println("H1");
            }
            return true;
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            if (verbose) {
                System.out.println("H2");
            }
            return true;
        }
        if (!aSTNode.strongProp() && arrayList.size() <= 10 && (aSTNode2 = this.m.constraints.getChild(0)) instanceof And) {
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (!aSTNode3.strongProp()) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!aSTNode3.contains(arrayList.get(j))) continue;
                    if (verbose) {
                        System.out.println("H3");
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

