/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.Model;
import savilerow.NoTransformBox;
import savilerow.NodeReplacement;
import savilerow.Top;
import savilerow.TreeTransformer;

public abstract class TreeTransformerBottomUp
extends TreeTransformer {
    Model m;
    private ArrayList<ASTNode> newConstraints;
    public ASTNode relContextConstraint;

    TreeTransformerBottomUp(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode getContextCts() {
        if (this.relContextConstraint.equals(new BooleanConstant(true))) {
            return null;
        }
        return this.relContextConstraint;
    }

    @Override
    public ASTNode transform(ASTNode aSTNode) {
        this.changedTree = false;
        assert (aSTNode != null);
        ASTNode aSTNode2 = aSTNode.getParent();
        int n = aSTNode.getChildNo();
        aSTNode.setParent(null);
        NoTransformBox noTransformBox = new NoTransformBox(aSTNode);
        this.newConstraints = new ArrayList();
        this.relContextConstraint = new BooleanConstant(true);
        this.recursiveSearch(noTransformBox);
        aSTNode = ((ASTNode)noTransformBox).getChild(0);
        if (this.newConstraints.size() == 0) {
            aSTNode.setParent(aSTNode2);
            aSTNode.setChildNo(n);
            return aSTNode;
        }
        if (!(aSTNode instanceof Top)) {
            this.relContextConstraint = new And(this.relContextConstraint, new And(this.newConstraints));
        } else {
            this.newConstraints.add(aSTNode.getChild(0));
            And and = new And(this.newConstraints);
            aSTNode.setChild(0, and);
            aSTNode.setParent(aSTNode2);
            aSTNode.setChildNo(n);
        }
        return aSTNode;
    }

    boolean recursiveSearch(ASTNode aSTNode) {
        if (aSTNode.isDetached()) {
            return false;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            boolean bl = this.recursiveSearch(aSTNode.getChild(i));
            if (aSTNode.isDetached()) {
                assert (!bl);
                return false;
            }
            if (bl) continue;
            --i;
        }
        assert (!aSTNode.isDetached());
        NodeReplacement nodeReplacement = this.processNode(aSTNode);
        if (nodeReplacement != null) {
            this.changedTree = true;
            aSTNode = this.replaceCurrentNode(aSTNode, nodeReplacement.current_node);
            this.addToRelationalContext(aSTNode, nodeReplacement.rel_context);
            this.addToConstraints(nodeReplacement.new_constraint);
        }
        return !aSTNode.isDetached();
    }

    protected ASTNode replaceCurrentNode(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode2 == null) {
            return aSTNode;
        }
        assert (!aSTNode.isDetached());
        ASTNode aSTNode3 = aSTNode.getParent();
        int n = aSTNode.getChildNo();
        assert (aSTNode3.getChild(n) == aSTNode);
        aSTNode3.setChild(n, aSTNode2);
        assert (!aSTNode3.getChild(n).isDetached());
        return aSTNode3.getChild(n);
    }

    protected void addToRelationalContext(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode2 == null) {
            return;
        }
        while (!(aSTNode == null || aSTNode.isRelation() && aSTNode.getDimension() == 0)) {
            assert (!aSTNode.isDetached());
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode == null) {
            this.relContextConstraint = new And(this.relContextConstraint, aSTNode2);
        } else {
            aSTNode.getParent().setChild(aSTNode.getChildNo(), new And(aSTNode2, aSTNode));
            assert (aSTNode.isDetached());
        }
    }

    protected void addToConstraints(ASTNode aSTNode) {
        if (aSTNode == null) {
            return;
        }
        this.newConstraints.add(aSTNode);
    }
}

