package savilerow;

import java.util.ArrayList;

public class CadicalStats extends Stats{
    public CadicalStats(ArrayList<String> stdout_lines) {
        // Pull out # decisions and CPU time.
        for(int i=0; i<stdout_lines.size(); i++) {
            String[] tmp=stdout_lines.get(i).trim().split(" +");

            //if(tmp[0].equals("decisions")) {
            //    putValue("SolverNodes", tmp[2]);
            //}
            if (stdout_lines.get(i).contains("c total real time since initialization:")) {
                putValue("SolverTotalTime", tmp[6]);
            }
            // Is the problem satisfiable, unsatisfiable or timed out?
            if(tmp[0].equals("s") && tmp[1].equals("SATISFIABLE")) {
                putValue("SolverTimeOut", "0");
                putValue("SolverMemOut", "0");
                putValue("SolverSatisfiable", "1");
            }
            if(tmp[0].equals("s") && tmp[1].equals("UNSATISFIABLE")) {
                putValue("SolverTimeOut", "0");
                putValue("SolverMemOut", "0");
                putValue("SolverSatisfiable", "0");
            }
            if(tmp[0].equals("s") && tmp[1].equals("INDETERMINATE")) {
                putValue("SolverTimeOut", "1");
                putValue("SolverMemOut", "0");
                putValue("SolverSatisfiable", "0");
            }
        }

        // For very large problems, it outputs 'INDETERMINATE' without times or decisions
        // Assume this means out of memory.

        if(getValue("SolverNodes").equals("NA") && getValue("SolverTotalTime").equals("NA") && getValue("SolverTimeOut").equals("1")) {
            putValue("SolverNodes", "0");
            putValue("SolverTotalTime", "0");
            putValue("SolverMemOut", "1");
            putValue("SolverTimeOut", "0");
        }
    }
}
