/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.BinOp;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.Range;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.SymbolTable;

public class InSet
extends BinOp {
    public static final long serialVersionUID = 1L;

    public InSet(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new InSet(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).getCategory() == 0) {
            if (this.getChild(1).containsValue(this.getChild(0).getValue())) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(1).getCategory() == 0) {
            Object object;
            Object object2;
            ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSet();
            if (arrayList.size() == 0) {
                return new BooleanConstant(false);
            }
            if (arrayList.size() == 1) {
                object2 = arrayList.get(0);
                object = this.getChild(0).getBounds();
                if (((Intpair)object2).upper < ((Intpair)object).lower || ((Intpair)object2).lower > ((Intpair)object).upper) {
                    return new BooleanConstant(false);
                }
                if (((Intpair)object).lower >= ((Intpair)object2).lower && ((Intpair)object).upper <= ((Intpair)object2).upper) {
                    return new BooleanConstant(true);
                }
            }
            if (this.getChild(0) instanceof Identifier && this.getChild(0).getCategory() == 3 && ((ASTNode)(object2 = this.getChild((int)0).getModel().global_symbols.getDomain(this.getChild(0).toString()))).getCategory() == 0 && ((ArrayList)(object = Intpair.setDifference(((ASTNode)object2).getIntervalSet(), arrayList))).size() == 0) {
                return new BooleanConstant(true);
            }
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable) || !this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).isSet()) {
            CmdFlags.println("ERROR: Expected set on right hand side of 'in' operator: " + this);
            return false;
        }
        if (this.getChild(0).getDimension() > 0 || this.getChild(0).isSet()) {
            CmdFlags.println("ERROR: Expected integer or boolean expression on left hand side of 'in' operator: " + this);
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " in " + this.getChild(1) + ")";
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("w-inintervalset(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(",[");
        ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            bufferedWriter.append(String.valueOf(arrayList.get((int)i).lower));
            bufferedWriter.append(",");
            bufferedWriter.append(String.valueOf(arrayList.get((int)i).upper));
            if (i >= arrayList.size() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("])");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("inlist(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",[");
        stringBuilder.append(Intpair.printValues(this.getChild(1).getIntervalSet()));
        stringBuilder.append("])");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Or([");
        ArrayList<ASTNode> arrayList = this.getChild(1).getChild(0).getChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            if (aSTNode instanceof Range) {
                stringBuilder.append("And([(");
                this.getChild(0).toDominionParam(stringBuilder);
                stringBuilder.append(">=");
                aSTNode.getChild(0).toDominionParam(stringBuilder);
                stringBuilder.append("),(");
                this.getChild(0).toDominionParam(stringBuilder);
                stringBuilder.append("<=");
                aSTNode.getChild(1).toDominionParam(stringBuilder);
                stringBuilder.append(")])");
            } else {
                stringBuilder.append("(");
                this.getChild(0).toDominionParam(stringBuilder);
                stringBuilder.append("=");
                aSTNode.toDominionParam(stringBuilder);
                stringBuilder.append(")");
            }
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint set_in(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",{");
        bufferedWriter.append(Intpair.printValues(this.getChild(1).getIntervalSet()));
        bufferedWriter.append("});");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" in {");
        stringBuilder.append(Intpair.printValues(this.getChild(1).getIntervalSet()));
        stringBuilder.append("})");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        sat.unaryDirectEncoding(this, this.getChild(0));
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        sat.unaryDirectEncodingWithAuxVar(this, this.getChild(0), l);
    }

    @Override
    public boolean test(long l) {
        return this.getChild(1).containsValue(l);
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL();
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(or");
        String string = "";
        string = CmdFlags.getUseBV() ? this.getChild(0).smtEncodeBV(sMT) : this.getChild(0).smtEncodeInt(sMT);
        ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                stringBuilder.append(" (= ");
                stringBuilder.append(string);
                stringBuilder.append(" ");
                if (CmdFlags.getUseBV()) {
                    stringBuilder.append(SMT.toSMTBV(j));
                } else {
                    stringBuilder.append(SMT.toSMTInt(j));
                }
                stringBuilder.append(")");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + SMT.toSMTBV(1L) + " " + SMT.toSMTBV(0L) + ")";
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }
}

