/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.Intpair;
import savilerow.Min;
import savilerow.NegInfinity;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.PosInfinity;
import savilerow.SymbolTable;

public class MinVector
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public MinVector(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new MinVector(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in min function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
            if (aSTNode instanceof EmptyMatrix) {
                return NumberConstant.make(0L);
            }
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            if (aSTNode == this.getChild(0)) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).setParent(null);
                }
            }
            return new Min(arrayList);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(new NegInfinity(), new PosInfinity());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String toString() {
        return "min(" + this.getChild(0) + ")";
    }
}

