/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;
import savilerow.CmdFlags;
import savilerow.EPrimeSyntaxException;
import savilerow.Intpair;

public final class EPrimeTokenizer {
    private int ln;
    private char[] file;
    private int idx;
    private ArrayDeque<Integer> markStack;
    private ArrayDeque<String> markNames;
    private int commitMark;
    private String commitMsg;
    public int tokenType;
    public static final int TT_WORD = 0;
    public static final int TT_WORD_PRIME = 1;
    public static final int TT_OTHER = 2;
    public static final int TT_INT = 3;
    public static final int TT_EOF = 4;
    public String wordToken;
    public String otherToken;
    public long intToken;
    public String token;
    static final boolean VB_TOKENS = false;

    public EPrimeTokenizer(String string, boolean bl) {
        if (bl) {
            File file = new File(string);
            this.ln = (int)file.length();
            this.file = new char[this.ln];
            try {
                FileReader fileReader = new FileReader(string);
                int n = fileReader.read(this.file, 0, this.ln);
                fileReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                CmdFlags.errorExit("File not found: " + string);
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Unable to read file: " + string);
            }
        } else {
            this.ln = string.length();
            this.file = new char[this.ln];
            for (int i = 0; i < this.ln; ++i) {
                this.file[i] = string.charAt(i);
            }
        }
        this.idx = 0;
        this.markStack = new ArrayDeque();
        this.markNames = new ArrayDeque();
    }

    public void mark() {
        this.markStack.push(this.idx);
        this.markNames.push("moo");
    }

    public void mark(String string) {
        this.markStack.push(this.idx);
        this.markNames.push(string);
    }

    public void eraseMark() {
        this.markStack.pop();
        String string = this.markNames.pop();
        assert (string.equals("moo"));
    }

    public void eraseMark(String string) {
        this.markStack.pop();
        String string2 = this.markNames.pop();
        if (!string.equals(string2)) {
            System.out.println(string + ", " + string2);
        }
        assert (string.equals(string2));
    }

    public void reset() {
        this.idx = this.markStack.pop();
        if (this.idx < this.commitMark) {
            this.raiseError();
        }
        String string = this.markNames.pop();
        assert (string.equals("moo"));
    }

    public void reset(String string) {
        String string2;
        this.idx = this.markStack.pop();
        if (this.idx < this.commitMark) {
            this.raiseError();
        }
        if (!string.equals(string2 = this.markNames.pop())) {
            System.out.println(string + ", " + string2);
        }
        assert (string.equals(string2));
    }

    public void raiseError() {
        Intpair intpair = this.linecolNumber(this.commitMark);
        this.printMarker(intpair.lower, intpair.upper);
        if (this.commitMsg != null) {
            CmdFlags.errorExit(this.commitMsg, "Failed when parsing rest of structure following line:" + intpair.lower + " column:" + intpair.upper);
        } else {
            CmdFlags.errorExit("Failed when parsing rest of structure following line:" + intpair.lower + " column:" + intpair.upper);
        }
    }

    public void commit(String string) {
        this.commitMark = this.idx;
        this.commitMsg = string;
    }

    public String toString() {
        switch (this.tokenType) {
            case 0: {
                return "Token[" + this.wordToken + "]";
            }
            case 3: {
                return "Token[" + this.intToken + "]";
            }
            case 2: {
                return "Token[" + this.otherToken + "]";
            }
            case 4: {
                return "EOF";
            }
        }
        return "Unknown token type!!";
    }

    public Intpair linecolNumber(int n) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < n; ++n2) {
            if (this.file[n2] != '\n') continue;
            ++n3;
        }
        n2 = 1;
        for (int i = 0; i < n; ++i) {
            ++n2;
            if (this.file[i] != '\n') continue;
            n2 = 0;
        }
        return new Intpair(n3, n2);
    }

    public void printMarker(long l, long l2) {
        int n;
        int n2 = 1;
        for (n = 0; n < this.file.length; ++n) {
            if ((long)n2 == l) {
                System.err.print(this.file[n]);
            }
            if (this.file[n] != '\n') continue;
            ++n2;
        }
        System.err.println("");
        n = 0;
        while ((long)n < l2) {
            System.err.print("-");
            ++n;
        }
        System.err.println("^");
    }

    public void nextToken() throws EPrimeSyntaxException {
        this.skipWS();
        if (this.tokenType == 4 && this.idx >= this.ln - 1) {
            return;
        }
        char c = this.file[this.idx];
        if ('A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
            this.nextWordToken();
        } else if ('0' <= c && '9' >= c) {
            this.nextIntToken();
        } else {
            this.nextOtherToken();
        }
        this.skipWSaftertoken();
    }

    private void nextWordToken() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (this.idx < this.ln && (this.file[this.idx] >= '0' && this.file[this.idx] <= '9' || this.file[this.idx] >= 'A' && this.file[this.idx] <= 'Z' || this.file[this.idx] >= 'a' && this.file[this.idx] <= 'z' || this.file[this.idx] == '_' || this.file[this.idx] == '\'')) {
            stringBuilder.append(this.file[this.idx]);
            if (this.file[this.idx] == '\'') {
                bl = true;
            }
            ++this.idx;
        }
        this.token = this.wordToken = stringBuilder.toString();
        this.tokenType = !bl ? 0 : 1;
    }

    private void nextIntToken() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.idx < this.ln && this.file[this.idx] >= '0' && this.file[this.idx] <= '9') {
            stringBuilder.append(this.file[this.idx]);
            ++this.idx;
        }
        try {
            this.token = stringBuilder.toString();
            this.intToken = Long.parseLong(stringBuilder.toString());
            this.tokenType = 3;
        }
        catch (NumberFormatException numberFormatException) {
            CmdFlags.errorExit("Number exceeds 64-bit integer range: " + stringBuilder.toString());
        }
    }

    private void nextOtherToken() throws EPrimeSyntaxException {
        switch (this.file[this.idx++]) {
            case ',': {
                this.otherToken = ",";
                break;
            }
            case ':': {
                this.otherToken = ":";
                break;
            }
            case ';': {
                this.otherToken = ";";
                break;
            }
            case '[': {
                this.otherToken = "[";
                break;
            }
            case ']': {
                this.otherToken = "]";
                break;
            }
            case '(': {
                this.otherToken = "(";
                break;
            }
            case ')': {
                this.otherToken = ")";
                break;
            }
            case '{': {
                this.otherToken = "{";
                break;
            }
            case '}': {
                this.otherToken = "}";
                break;
            }
            case '@': {
                this.otherToken = "@";
                break;
            }
            case '`': {
                this.otherToken = "`";
                break;
            }
            case '*': {
                if (this.ln > this.idx && this.file[this.idx] == '*') {
                    ++this.idx;
                    this.otherToken = "**";
                    break;
                }
                this.otherToken = "*";
                break;
            }
            case '+': {
                this.otherToken = "+";
                break;
            }
            case '-': {
                if (this.ln > this.idx && this.file[this.idx] == '>') {
                    ++this.idx;
                    this.otherToken = "->";
                    break;
                }
                this.otherToken = "-";
                break;
            }
            case '|': {
                this.otherToken = "|";
                break;
            }
            case '%': {
                this.otherToken = "%";
                break;
            }
            case '/': {
                if (this.ln > this.idx && this.file[this.idx] == '\\') {
                    ++this.idx;
                    this.otherToken = "/\\";
                    break;
                }
                this.otherToken = "/";
                break;
            }
            case '\\': {
                if (this.ln > this.idx && this.file[this.idx] == '/') {
                    ++this.idx;
                    this.otherToken = "\\/";
                    break;
                }
                throw new EPrimeSyntaxException("Expected OtherToken, found unknown token beginning with '\\'");
            }
            case '.': {
                if (this.ln > this.idx && this.file[this.idx] == '.') {
                    ++this.idx;
                    this.otherToken = "..";
                    break;
                }
                this.otherToken = ".";
                break;
            }
            case '>': {
                if (this.ln > this.idx + 2 && this.file[this.idx] == 'l' && this.file[this.idx + 1] == 'e' && this.file[this.idx + 2] == 'x') {
                    this.idx += 3;
                    this.otherToken = ">lex";
                    break;
                }
                if (this.ln > this.idx + 3 && this.file[this.idx] == '=' && this.file[this.idx + 1] == 'l' && this.file[this.idx + 2] == 'e' && this.file[this.idx + 3] == 'x') {
                    this.idx += 4;
                    this.otherToken = ">=lex";
                    break;
                }
                if (this.ln > this.idx && this.file[this.idx] == '=') {
                    ++this.idx;
                    this.otherToken = ">=";
                    break;
                }
                this.otherToken = ">";
                break;
            }
            case '<': {
                if (this.ln > this.idx + 2 && this.file[this.idx] == 'l' && this.file[this.idx + 1] == 'e' && this.file[this.idx + 2] == 'x') {
                    this.idx += 3;
                    this.otherToken = "<lex";
                    break;
                }
                if (this.ln > this.idx + 3 && this.file[this.idx] == '=' && this.file[this.idx + 1] == 'l' && this.file[this.idx + 2] == 'e' && this.file[this.idx + 3] == 'x') {
                    this.idx += 4;
                    this.otherToken = "<=lex";
                    break;
                }
                if (this.ln > this.idx + 1 && this.file[this.idx] == '=' && this.file[this.idx + 1] == '>') {
                    this.idx += 2;
                    this.otherToken = "<=>";
                    break;
                }
                if (this.ln > this.idx + 1 && this.file[this.idx] == '-' && this.file[this.idx + 1] == '>') {
                    this.idx += 2;
                    this.otherToken = "<->";
                    break;
                }
                if (this.ln > this.idx && this.file[this.idx] == '=') {
                    ++this.idx;
                    this.otherToken = "<=";
                    break;
                }
                this.otherToken = "<";
                break;
            }
            case '!': {
                if (this.ln > this.idx && this.file[this.idx] == '=') {
                    ++this.idx;
                    this.otherToken = "!=";
                    break;
                }
                this.otherToken = "!";
                break;
            }
            case '=': {
                if (this.ln > this.idx && this.file[this.idx] == '>') {
                    ++this.idx;
                    this.otherToken = "=>";
                    break;
                }
                this.otherToken = "=";
                break;
            }
            default: {
                throw new EPrimeSyntaxException("Expected OtherToken, found unknown token beginning with " + Character.toString(this.file[this.idx - 1]));
            }
        }
        this.tokenType = 2;
        this.token = this.otherToken;
    }

    private void skipWS() {
        boolean bl = false;
        while (this.idx < this.ln) {
            if (bl) {
                if (this.file[this.idx] == '\n' || this.file[this.idx] == '\r') {
                    bl = false;
                }
                ++this.idx;
                continue;
            }
            if (this.file[this.idx] == '$') {
                bl = true;
            } else if (this.file[this.idx] > ' ') {
                return;
            }
            ++this.idx;
        }
        this.tokenType = 4;
        this.token = "";
    }

    private void skipWSaftertoken() {
        boolean bl = false;
        while (this.idx < this.ln) {
            if (bl) {
                if (this.file[this.idx] == '\n' || this.file[this.idx] == '\r') {
                    bl = false;
                }
                ++this.idx;
                continue;
            }
            if (this.file[this.idx] == '$') {
                bl = true;
            } else if (this.file[this.idx] > ' ') {
                return;
            }
            ++this.idx;
        }
    }
}

