/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import savilerow.ASTNode;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.LogicBinOp;
import savilerow.Negate;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.SymbolTable;

public class Iff
extends LogicBinOp {
    public static final long serialVersionUID = 1L;

    public Iff(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Iff(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 1L) {
            this.getChild(1).setParent(null);
            return this.getChild(1);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 0L) {
            this.getChild(1).setParent(null);
            return new Negate(this.getChild(1));
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 0L) {
            this.getChild(0).setParent(null);
            return new Negate(this.getChild(0));
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0) instanceof Negate && this.getChild(0).getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(false);
        }
        if (this.getChild(1) instanceof Negate && this.getChild(1).getChild(0).equals(this.getChild(0))) {
            return new BooleanConstant(false);
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        if (this.getChild(0) instanceof Identifier) {
            return new Iff((ASTNode)new Negate(this.getChild(0)), this.getChild(1));
        }
        if (this.getChild(1) instanceof Identifier) {
            return new Iff(this.getChild(0), new Negate(this.getChild(1)));
        }
        if (this.getChild(0).isNegatable()) {
            return new Iff((ASTNode)new Negate(this.getChild(0)), this.getChild(1));
        }
        return new Iff(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public ASTNode normalise() {
        if (this.getChild(0).hashCode() > this.getChild(1).hashCode()) {
            this.detachChildren();
            return new Iff(this.getChild(1), this.getChild(0));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        if (this.getChild(0).toString().compareTo(this.getChild(1).toString()) > 0) {
            this.detachChildren();
            return new Iff(this.getChild(1), this.getChild(0));
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: Iff contains non-relation expression:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("eq(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("eq(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("=");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint bool_eq(");
        this.getChild(0).toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append("<->");
        this.getChild(1).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant()) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        long l = this.getChild(0).directEncode(sat, 1L);
        long l2 = this.getChild(1).directEncode(sat, 1L);
        sat.addClause(-l, l2);
        sat.addClause(l, -l2);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        long l2 = this.getChild(0).directEncode(sat, 1L);
        long l3 = this.getChild(1).directEncode(sat, 1L);
        sat.addClause(-l2, -l3, l);
        sat.addClause(-l2, l3, -l);
        sat.addClause(l2, -l3, -l);
        sat.addClause(l2, l3, l);
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL();
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        sMT.addSMTClause(this.smtEncodeBool(sMT));
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        String string = this.getChild(0).smtEncodeBool(sMT);
        String string2 = this.getChild(1).smtEncodeBool(sMT);
        return "(and (or (not " + string + ") " + string2 + ") (or " + string + " (not " + string2 + ")))";
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + SMT.toSMTBV(1L) + " " + SMT.toSMTBV(0L) + ")";
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " <-> " + this.getChild(1) + ")";
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

