/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Concatenate;
import savilerow.ConstantMatrixStore;
import savilerow.EmptyMatrix;
import savilerow.FilteredDomainStore;
import savilerow.Find;
import savilerow.Flatten;
import savilerow.Identifier;
import savilerow.MatrixDomain;
import savilerow.Maximising;
import savilerow.Minimising;
import savilerow.Negate;
import savilerow.ReplaceASTNode;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.SymbolTable;
import savilerow.Top;
import savilerow.TransformFixSTRef;
import savilerow.TransformSimplify;
import savilerow.TransformSimplifyExtended;
import savilerow.TreeTransformer;

public class Model {
    public ASTNode constraints;
    public SymbolTable global_symbols;
    public FilteredDomainStore filt;
    public ConstantMatrixStore cmstore;
    public ASTNode objective;
    public ASTNode branchingon;
    public String heuristic;
    public ASTNode sns;
    public ASTNode preserveVariables;
    public Sat satModel;
    public ASTNode incumbentSolution;

    public void setup(ASTNode aSTNode, SymbolTable symbolTable, ASTNode aSTNode2, ASTNode aSTNode3, String string, ASTNode aSTNode4, ASTNode aSTNode5) {
        assert (aSTNode != null);
        assert (symbolTable != null);
        this.constraints = aSTNode;
        this.global_symbols = symbolTable;
        symbolTable.m = this;
        this.objective = aSTNode2;
        this.branchingon = aSTNode3;
        this.heuristic = string;
        this.setDefaultBranchingOn();
        this.filt = new FilteredDomainStore(this.global_symbols);
        this.cmstore = new ConstantMatrixStore(this);
        this.sns = aSTNode4;
        this.preserveVariables = aSTNode5;
    }

    public void setup(ASTNode aSTNode, SymbolTable symbolTable, FilteredDomainStore filteredDomainStore, ConstantMatrixStore constantMatrixStore, ASTNode aSTNode2, ASTNode aSTNode3, String string, ASTNode aSTNode4, ASTNode aSTNode5) {
        assert (aSTNode != null);
        assert (symbolTable != null);
        this.constraints = aSTNode;
        this.global_symbols = symbolTable;
        symbolTable.m = this;
        this.objective = aSTNode2;
        this.branchingon = aSTNode3;
        this.heuristic = string;
        this.setDefaultBranchingOn();
        this.filt = filteredDomainStore;
        this.cmstore = constantMatrixStore;
        constantMatrixStore.m = this;
        this.sns = aSTNode4;
        this.preserveVariables = aSTNode5;
    }

    private void setDefaultBranchingOn() {
        if (this.branchingon == null) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(this.global_symbols.lettings_givens);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Find)) continue;
                if (arrayList.get(i).getChild(1) instanceof MatrixDomain) {
                    arrayList2.add(new Flatten(arrayList.get(i).getChild(0)));
                    continue;
                }
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                arrayList3.add(arrayList.get(i).getChild(0));
                arrayList2.add(new CompoundMatrix(arrayList3));
            }
            this.branchingon = new Concatenate(arrayList2);
        }
    }

    public void simplify() {
        TransformSimplify transformSimplify = new TransformSimplify();
        boolean bl = this.global_symbols.simplify();
        if (!bl) {
            this.constraints = new Top(new BooleanConstant(false));
        } else if (CmdFlags.getUseDeleteVars()) {
            TransformSimplifyExtended transformSimplifyExtended = new TransformSimplifyExtended(this);
            this.constraints = transformSimplifyExtended.transform(this.constraints);
        } else {
            this.constraints = transformSimplify.transform(this.constraints);
        }
        if (this.objective != null) {
            this.objective = transformSimplify.transform(this.objective);
            if (this.objective.getChild(0).isConstant()) {
                CmdFlags.println("Dropping objective: " + this.objective);
                this.objective = null;
            }
        }
        if (this.branchingon != null) {
            this.branchingon = transformSimplify.transform(this.branchingon);
        }
        if (this.preserveVariables != null) {
            this.preserveVariables = transformSimplify.transform(this.preserveVariables);
        }
        if (this.sns != null) {
            this.sns = transformSimplify.transform(this.sns);
        }
        this.filt.simplify();
    }

    public void substitute(ASTNode aSTNode, ASTNode aSTNode2) {
        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode, aSTNode2);
        this.constraints = replaceASTNode.transform(this.constraints);
        if (this.objective != null) {
            this.objective = replaceASTNode.transform(this.objective);
        }
        if (this.branchingon != null) {
            this.branchingon = replaceASTNode.transform(this.branchingon);
        }
        if (this.sns != null) {
            this.sns = replaceASTNode.transform(this.sns);
        }
        this.global_symbols.substitute(aSTNode, aSTNode2);
    }

    public boolean typecheck() {
        if (this.branchingon != null && this.branchingon.getDimension() != 1) {
            CmdFlags.println("ERROR: 'branching on' statement may only contain 1-dimensional matrices of decision variables.");
            return false;
        }
        if (this.objective != null) {
            if (!this.objective.typecheck(this.global_symbols)) {
                return false;
            }
            if (!(this.objective instanceof Maximising) && !(this.objective instanceof Minimising)) {
                CmdFlags.println("ERROR: Objective: " + this.objective);
                CmdFlags.println("ERROR: should be either minimising or maximising.");
                return false;
            }
            if (!this.objective.getChild(0).isNumerical() && !this.objective.getChild(0).isRelation()) {
                CmdFlags.println("ERROR: Objective must be numerical or relational.");
                return false;
            }
        }
        if (this.sns != null && !this.sns.typecheck(this.global_symbols)) {
            return false;
        }
        if (!this.constraints.typecheck(this.global_symbols)) {
            return false;
        }
        if (!this.global_symbols.typecheck()) {
            return false;
        }
        return this.cmstore.typecheck();
    }

    public boolean transform(TreeTransformer treeTransformer) {
        if (CmdFlags.getVerbose()) {
            System.out.println("Rule:" + treeTransformer.getClass().getName());
        }
        boolean bl = false;
        assert (this.constraints instanceof Top);
        this.constraints = treeTransformer.transform(this.constraints);
        boolean bl2 = bl = bl || treeTransformer.changedTree;
        if (this.objective != null) {
            this.objective = treeTransformer.transform(this.objective);
            boolean bl3 = bl = bl || treeTransformer.changedTree;
        }
        if (treeTransformer.getContextCts() != null) {
            this.constraints.getChild(0).setParent(null);
            this.constraints = new Top(new And(this.constraints.getChild(0), treeTransformer.getContextCts()));
            bl = true;
        }
        assert (this.branchingon != null);
        this.branchingon = treeTransformer.transform(this.branchingon);
        boolean bl4 = bl = bl || treeTransformer.changedTree;
        if (treeTransformer.getContextCts() != null) {
            this.constraints.getChild(0).setParent(null);
            this.constraints = new Top(new And(this.constraints.getChild(0), treeTransformer.getContextCts()));
            bl = true;
        }
        if (this.sns != null) {
            this.sns = treeTransformer.transform(this.sns);
            boolean bl5 = bl = bl || treeTransformer.changedTree;
            if (treeTransformer.getContextCts() != null) {
                this.constraints.getChild(0).setParent(null);
                this.constraints = new Top(new And(this.constraints.getChild(0), treeTransformer.getContextCts()));
                bl = true;
            }
        }
        if (this.preserveVariables != null) {
            this.preserveVariables = treeTransformer.transform(this.preserveVariables);
            boolean bl6 = bl = bl || treeTransformer.changedTree;
        }
        if (CmdFlags.getVerbose() && bl) {
            System.out.println("Model has changed. Model after rule application:\n" + this.toString());
        }
        if (bl) {
            this.simplify();
            if (CmdFlags.getVerbose()) {
                System.out.println("Model after rule application and simplify:\n" + this.toString());
            }
        }
        assert (this.constraints instanceof Top);
        return bl;
    }

    public int hashCode() {
        return this.constraints.hashCode() ^ this.global_symbols.hashCode() ^ this.filt.hashCode() ^ this.cmstore.hashCode() ^ (this.objective == null ? 0 : this.objective.hashCode()) ^ this.branchingon.hashCode() ^ (this.heuristic == null ? 0 : this.heuristic.hashCode()) ^ (this.incumbentSolution == null ? 0 : this.incumbentSolution.hashCode()) ^ (this.sns == null ? 0 : this.sns.hashCode()) ^ (this.preserveVariables == null ? 0 : this.preserveVariables.hashCode());
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Model model = (Model)object;
        if (!model.constraints.equals(this.constraints)) {
            return false;
        }
        if (!model.global_symbols.equals(this.global_symbols)) {
            return false;
        }
        if (!model.filt.equals(this.filt)) {
            return false;
        }
        if (!model.cmstore.equals(this.cmstore)) {
            return false;
        }
        if (!(this.objective != null ? this.objective.equals(model.objective) : model.objective == null)) {
            return false;
        }
        if (!(this.preserveVariables != null ? this.preserveVariables.equals(model.preserveVariables) : model.preserveVariables == null)) {
            return false;
        }
        if (!this.branchingon.equals(model.branchingon)) {
            return false;
        }
        if (!(this.heuristic != null ? this.heuristic.equals(model.heuristic) : model.heuristic == null)) {
            return false;
        }
        if (!(this.incumbentSolution != null ? this.incumbentSolution.equals(model.incumbentSolution) : model.incumbentSolution == null)) {
            return false;
        }
        return this.sns != null ? this.sns.equals(model.sns) : model.sns == null;
    }

    public Model copy() {
        Model model = new Model();
        SymbolTable symbolTable = this.global_symbols.copy(model);
        FilteredDomainStore filteredDomainStore = this.filt.copy(symbolTable);
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model);
        ASTNode aSTNode = transformFixSTRef.transform(this.constraints.copy());
        ASTNode aSTNode2 = null;
        if (this.objective != null) {
            aSTNode2 = transformFixSTRef.transform(this.objective.copy());
        }
        ASTNode aSTNode3 = transformFixSTRef.transform(this.branchingon.copy());
        ConstantMatrixStore constantMatrixStore = this.cmstore.copy(model);
        ASTNode aSTNode4 = null;
        if (this.sns != null) {
            aSTNode4 = transformFixSTRef.transform(this.sns.copy());
        }
        ASTNode aSTNode5 = null;
        if (this.preserveVariables != null) {
            aSTNode5 = transformFixSTRef.transform(this.preserveVariables.copy());
        }
        model.setup(aSTNode, symbolTable, filteredDomainStore, constantMatrixStore, aSTNode2, aSTNode3, this.heuristic, aSTNode4, aSTNode5);
        if (this.incumbentSolution != null) {
            model.incumbentSolution = transformFixSTRef.transform(this.incumbentSolution.copy());
        }
        return model;
    }

    void dedupBranchingOn() {
        assert (this.branchingon instanceof CompoundMatrix || this.branchingon instanceof EmptyMatrix);
        ArrayList<ASTNode> arrayList = this.branchingon.getChildren(1);
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            if (aSTNode instanceof Negate) {
                aSTNode = aSTNode.getChild(0);
            }
            if (aSTNode.getCategory() != 3 || hashSet.contains(aSTNode)) continue;
            hashSet.add(aSTNode);
            arrayList2.add(arrayList.get(i));
        }
        this.branchingon = CompoundMatrix.make(arrayList2);
    }

    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        this.toMinion(bufferedWriter, bl, null);
    }

    public void toMinion(BufferedWriter bufferedWriter, boolean bl, ArrayList<ASTNode> arrayList) throws IOException {
        bufferedWriter.append("MINION 3\n");
        for (String string : CmdFlags.stats.keySet()) {
            bufferedWriter.append("# " + string + " = " + CmdFlags.stats.get(string) + "\n");
        }
        bufferedWriter.append("**VARIABLES**\n");
        this.global_symbols.toMinion(bufferedWriter);
        this.cmstore.toMinion(bufferedWriter);
        bufferedWriter.append("**SEARCH**\n");
        if (arrayList == null) {
            this.global_symbols.printPrintStmt(bufferedWriter);
        } else {
            bufferedWriter.append("PRINT [");
            for (int i = 0; i < arrayList.size(); ++i) {
                bufferedWriter.append("[");
                arrayList.get(i).toMinion(bufferedWriter, false);
                bufferedWriter.append("]");
                if (i >= arrayList.size() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("]\n");
        }
        if (this.objective != null) {
            this.objective.toMinion(bufferedWriter, false);
        }
        if (arrayList != null) {
            bufferedWriter.append("VARORDER [");
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).toMinion(bufferedWriter, false);
                if (i >= arrayList.size() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("]\n");
        }
        if (!bl && arrayList == null) {
            this.dedupBranchingOn();
            bufferedWriter.append("VARORDER ");
            if (this.heuristic != null) {
                bufferedWriter.append(this.heuristic);
            } else {
                bufferedWriter.append("STATIC");
            }
            bufferedWriter.append(" ");
            this.branchingon.toMinion(bufferedWriter, false);
            bufferedWriter.append("\n");
        }
        bufferedWriter.append("**CONSTRAINTS**\n");
        this.constraints.toMinion(bufferedWriter, true);
        if (this.sns != null) {
            this.sns.toMinion(bufferedWriter, false);
        }
        bufferedWriter.append("**EOF**\n");
    }

    public void toDominion(StringBuilder stringBuilder) {
        stringBuilder.append("language Dominion 0.0\n");
        this.global_symbols.toDominion(stringBuilder);
        if (this.objective != null) {
            this.objective.toDominion(stringBuilder, false);
        }
        stringBuilder.append("such that\n");
        this.constraints.toDominion(stringBuilder, true);
        stringBuilder.append("\n");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("language ESSENCE' 1.0\n");
        stringBuilder.append(this.global_symbols.toString());
        if (this.objective != null) {
            stringBuilder.append(this.objective.toString());
        }
        if (this.sns != null) {
            stringBuilder.append(this.sns.toString());
        }
        stringBuilder.append("such that\n");
        stringBuilder.append(this.constraints.toString());
        return stringBuilder.toString();
    }

    public void toFlatzinc(BufferedWriter bufferedWriter) throws IOException {
        if (CmdFlags.getChuffedtrans()) {
            bufferedWriter.append("predicate all_different_int(array [int] of var int: xs);\n");
        }
        if (CmdFlags.getGecodetrans()) {
            bufferedWriter.append("predicate gecode_global_cardinality(array[int] of var int: x, array[int] of int: cover, array[int] of var int: counts);");
        }
        this.cmstore.toFlatzinc(bufferedWriter);
        this.global_symbols.toFlatzinc(bufferedWriter);
        this.constraints.toFlatzinc(bufferedWriter, true);
        bufferedWriter.append("solve :: int_search(");
        if (this.branchingon instanceof EmptyMatrix) {
            bufferedWriter.append("[1]");
        } else {
            this.branchingon.toFlatzinc(bufferedWriter, false);
        }
        bufferedWriter.append(", input_order, indomain_min, complete)\n");
        if (this.objective != null) {
            this.objective.toFlatzinc(bufferedWriter, false);
        } else {
            bufferedWriter.append(" satisfy;\n");
        }
    }

    public void toMinizinc(StringBuilder stringBuilder) {
        stringBuilder.append("% Minizinc model produced by Savile Row from Essence Prime file " + CmdFlags.eprimefile);
        if (CmdFlags.paramfile != null) {
            stringBuilder.append(" and parameter file " + CmdFlags.paramfile);
        }
        stringBuilder.append("\n");
        stringBuilder.append("include \"globals.mzn\";\n");
        if (CmdFlags.getMznLNS()) {
            stringBuilder.append("include \"minisearch.mzn\";\n");
        }
        this.global_symbols.toMinizinc(stringBuilder);
        this.cmstore.toMinizinc(stringBuilder);
        this.constraints.toMinizinc(stringBuilder, true);
        if (CmdFlags.getMznLNS()) {
            assert (this.objective != null);
            stringBuilder.append("solve search adaptive_lns_");
            if (this.objective instanceof Minimising) {
                stringBuilder.append("min(");
            } else {
                stringBuilder.append("max(");
            }
            this.objective.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(", [");
            this.global_symbols.printAllVariablesFlatzincExcept(stringBuilder, 3, this.objective.getChild(0).toString());
            stringBuilder.append("], 1000000, 10, 5000);\n");
        } else {
            stringBuilder.append("solve :: int_search([");
            this.global_symbols.printAllVariablesFlatzinc(stringBuilder, 3);
            stringBuilder.append("], input_order, indomain_min, complete)\n");
            if (this.objective != null) {
                this.objective.toMinizinc(stringBuilder, false);
            } else {
                stringBuilder.append(" satisfy;\n");
            }
        }
    }

    public boolean setupSAT(HashSet<String> hashSet) {
        try {
            this.satModel = new Sat(this.global_symbols);
            this.satModel.generateVariableEncoding(hashSet);
            return true;
        }
        catch (IOException iOException) {
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }

    public boolean toSAT() {
        try {
            this.constraints.toSAT(this.satModel);
            if (CmdFlags.getMaxsattrans() && this.objective != null) {
                this.objective.toSAT(this.satModel);
            }
            this.satModel.finaliseOutput();
            return true;
        }
        catch (IOException iOException) {
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }

    public boolean toSMT() {
        try {
            this.constraints.toSMT((SMT)this.satModel);
            this.satModel.finaliseOutput();
            return true;
        }
        catch (IOException iOException) {
            File file = new File(CmdFlags.smtfile);
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }

    public boolean setupSMT(HashSet<String> hashSet) {
        try {
            this.satModel = new SMT(this.global_symbols);
            if (this.objective != null) {
                if (CmdFlags.getUseBV()) {
                    this.global_symbols.markAsBitVector(((Identifier)this.objective.getChild(0)).getName());
                } else {
                    this.global_symbols.markAsInteger(((Identifier)this.objective.getChild(0)).getName());
                }
            }
            this.satModel.generateVariableEncoding(hashSet);
            if (this.objective != null && CmdFlags.getSMTEncodeObjective()) {
                ((SMT)this.satModel).addObjective(this.objective);
            }
            return true;
        }
        catch (IOException iOException) {
            File file = new File(CmdFlags.smtfile);
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }
}

