/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Equals;
import savilerow.MakeTable;
import savilerow.Mapping;
import savilerow.Model;
import savilerow.NegativeTable;
import savilerow.NumberConstant;
import savilerow.Table;
import savilerow.TableShort;
import savilerow.TabulationUtils;
import savilerow.Tag;

public class Tabulation {
    private static boolean verbose = false;
    private Model m;
    private TabulationUtils tu;

    public Tabulation(Model model) {
        this.m = model;
        this.tu = new TabulationUtils(this.m);
    }

    public void process(boolean bl) {
        this.processMakeTable(this.m.constraints);
        if (!(bl || CmdFlags.make_short_tab != 3 && CmdFlags.make_short_tab != 4)) {
            this.identicalScopes(this.m.constraints);
            this.applyHeuristicsBool(this.m.constraints);
            if (CmdFlags.tabulate_num) {
                this.applyHeuristicsNumerical(this.m.constraints);
            }
        }
    }

    private void processMakeTable(ASTNode aSTNode) {
        if (aSTNode instanceof MakeTable) {
            if (CmdFlags.make_short_tab == 0) {
                ASTNode aSTNode2 = aSTNode.getParent();
                int n = aSTNode.getChildNo();
                aSTNode.getChild(0).setParent(null);
                aSTNode2.setChild(n, aSTNode.getChild(0));
                this.processMakeTable(aSTNode2.getChild(n));
            } else {
                ASTNode aSTNode3 = this.tabulate(aSTNode.getChild(0), Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
                aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
            }
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.processMakeTable(aSTNode.getChild(i));
            }
        }
    }

    private void identicalScopes(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList;
        HashMap hashMap = new HashMap();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                Map.Entry entry = aSTNode2.getChild(i);
                if (entry instanceof Table || entry instanceof TableShort || entry instanceof NegativeTable || entry instanceof Tag) continue;
                assert (((ASTNode)((Object)entry)).isRelation());
                arrayList = TabulationUtils.getVariablesOrdered((ASTNode)((Object)entry));
                ASTNode.sortByAlpha(arrayList);
                if (!hashMap.containsKey(arrayList)) {
                    hashMap.put(arrayList, new ArrayList());
                }
                ((ArrayList)hashMap.get(arrayList)).add(entry);
            }
        }
        boolean bl = CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4;
        for (Map.Entry entry : hashMap.entrySet()) {
            ASTNode aSTNode3;
            arrayList = (ArrayList<ASTNode>)entry.getValue();
            if (arrayList.size() <= 1) continue;
            And and = new And(arrayList);
            if (verbose) {
                System.out.println("H4");
                System.out.println("Trying ct:" + and);
            }
            if ((aSTNode3 = this.tabulate(and, 10000L, 100000L, 100000L)) == null) continue;
            this.replaceConstraintSet(arrayList, aSTNode3);
        }
    }

    private void replaceConstraintSet(ArrayList<ASTNode> arrayList, ASTNode aSTNode) {
        ASTNode aSTNode2 = arrayList.get(0);
        aSTNode2.getParent().setChild(aSTNode2.getChildNo(), aSTNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i);
            aSTNode2.getParent().setChild(aSTNode2.getChildNo(), new BooleanConstant(true));
        }
    }

    private void applyHeuristicsBool(ASTNode aSTNode) {
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3;
                ASTNode aSTNode4 = aSTNode2.getChild(i);
                if (aSTNode4 instanceof And || !aSTNode4.isRelation() || aSTNode4 instanceof Table || aSTNode4 instanceof TableShort || aSTNode4 instanceof NegativeTable || aSTNode4 instanceof BooleanConstant || !this.heuristic(aSTNode4) || (aSTNode3 = this.tabulate(aSTNode4, 10000L, 100000L, 100000L)) == null) continue;
                aSTNode2.setChild(i, aSTNode3);
            }
        }
    }

    private void applyHeuristicsNumerical(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                ArrayList<ASTNode> arrayList2 = aSTNode3.getChildren();
                while (arrayList2.size() > 0) {
                    ASTNode aSTNode4 = arrayList2.remove(arrayList2.size() - 1);
                    if (aSTNode4 instanceof CompoundMatrix) {
                        arrayList2.addAll(aSTNode4.getChildren(1));
                        continue;
                    }
                    if (!aSTNode4.isNumerical() || aSTNode4 instanceof Mapping || aSTNode4.getDimension() != 0 || aSTNode4 instanceof NumberConstant || !aSTNode4.toFlatten(false)) continue;
                    ASTNode aSTNode5 = this.m.global_symbols.newAuxHelper(aSTNode4);
                    Equals equals = new Equals(aSTNode4.copy(), aSTNode5);
                    ASTNode aSTNode6 = aSTNode4.getParent();
                    aSTNode6.setChild(aSTNode4.getChildNo(), aSTNode5);
                    boolean bl = aSTNode3.strongProp();
                    aSTNode4.setParent(null);
                    aSTNode6.setChild(aSTNode4.getChildNo(), aSTNode4);
                    if (bl && !((ASTNode)equals).strongProp() || this.heuristic(equals)) {
                        ASTNode aSTNode7 = this.tabulate(equals, 10000L, 100000L, 100000L);
                        if (aSTNode7 != null) {
                            arrayList.add(aSTNode7);
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), aSTNode5);
                            continue;
                        }
                        this.m.global_symbols.deleteSymbol(aSTNode5.toString());
                        continue;
                    }
                    this.m.global_symbols.deleteSymbol(aSTNode5.toString());
                }
            }
            aSTNode.getChild(0).setParent(null);
            aSTNode.setChild(0, new And(aSTNode.getChild(0), new And(arrayList)));
        }
    }

    private boolean heuristic(ASTNode aSTNode) {
        ASTNode aSTNode2;
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesDup(aSTNode);
        if (arrayList.size() < arrayList2.size() && arrayList.size() <= 10) {
            if (verbose) {
                System.out.println("H1");
            }
            return true;
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            if (verbose) {
                System.out.println("H2");
            }
            return true;
        }
        if (!aSTNode.strongProp() && arrayList.size() <= 10 && (aSTNode2 = this.m.constraints.getChild(0)) instanceof And) {
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (!aSTNode3.strongProp()) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!aSTNode3.contains(arrayList.get(j))) continue;
                    if (verbose) {
                        System.out.println("H3");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private ASTNode tabulate(ASTNode aSTNode, long l, long l2, long l3) {
        ASTNode aSTNode2;
        boolean bl = CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4;
        TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(aSTNode, bl);
        if (retPair.nodereplace != null) {
            return retPair.nodereplace.current_node;
        }
        ASTNode aSTNode3 = this.tu.normalise(aSTNode);
        if (!bl) {
            double d = this.tu.probeLong(aSTNode3, 10L, 100L);
            if (verbose) {
                System.out.println("estimated coverage with 1000 node limit:" + d);
            }
            if (d * (double)l2 / 1000.0 > 0.5) {
                aSTNode2 = this.tu.makeTableLong(aSTNode3, l, l2);
                if (aSTNode2 == null && verbose) {
                    System.out.println("Ouch!");
                    System.out.println("coverage: " + d + " constraint:" + aSTNode3);
                }
            } else {
                aSTNode2 = null;
            }
        } else {
            aSTNode2 = this.tu.makeTableShort(aSTNode3, l, l2, l3);
        }
        if (aSTNode2 == null) {
            this.tu.saveToFailCache(retPair.expstring);
            if (verbose) {
                System.out.println("Adding to failCache:" + retPair.expstring);
            }
        } else {
            this.tu.saveToCacheNormalised(retPair.expstring, aSTNode3, aSTNode2);
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("Tabulated: " + aSTNode3);
            }
        }
        return aSTNode2;
    }
}

