/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import java.util.Collections;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BooleanDomain;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.EmptyRange;
import savilerow.IntegerDomain;
import savilerow.IntegerDomainConcreteArray;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Range;
import savilerow.SymbolTable;

public class ToSet
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ToSet(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new ToSet(this.getChild(0));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public boolean isFiniteSet() {
        return true;
    }

    @Override
    public boolean isFiniteSetUpper() {
        return true;
    }

    @Override
    public boolean isFiniteSetLower() {
        return true;
    }

    @Override
    public boolean isBooleanSet() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            System.out.println("ERROR: Expected one-dimensional matrix inside toSet function: " + this);
            return false;
        }
        if (this.getChild(0).getCategory() == 3) {
            System.out.println("ERROR: toSet function contains a decision variable: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if ((aSTNode instanceof EmptyMatrix || aSTNode instanceof CompoundMatrix) && aSTNode.getCategory() == 0) {
            if (aSTNode instanceof EmptyMatrix) {
                return new IntegerDomain(new EmptyRange());
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                arrayList.add(aSTNode.getChild(i).getValue());
            }
            Collections.sort(arrayList);
            if (!aSTNode.isRelation()) {
                ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    long l = (Long)arrayList.get(i);
                    long l2 = (Long)arrayList.get(i);
                    while (i < arrayList.size() - 1 && (Long)arrayList.get(i + 1) <= l2 + 1L) {
                        l2 = (Long)arrayList.get(i + 1);
                        ++i;
                    }
                    arrayList2.add(new Intpair(l, l2));
                }
                return new IntegerDomainConcreteArray(arrayList2);
            }
            if (arrayList.size() == 0) {
                return new BooleanDomain(new EmptyRange());
            }
            return new BooleanDomain(new Range((ASTNode)NumberConstant.make((Long)arrayList.get(0)), NumberConstant.make((Long)arrayList.get(arrayList.size() - 1))));
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public String toString() {
        return "toSet(" + this.getChild(0) + ")";
    }
}

