package savilerow;

import java.io.IOException;
import java.util.ArrayList;

public class CadicalSATSolver extends SATSolver {

    public CadicalSATSolver(Model _m) {
        super(_m);
    }
    public Pair<ArrayList<String>, Stats> runSatSolver(String satSolverName, String filename, Model m, Stats statssofar) throws IOException,  InterruptedException
    {
        CmdFlags.runningSolver=true;  // Prevents SR's timeout from kicking in.

        try
        {
            ArrayList<String> command = new ArrayList<String>();
            command.add(satSolverName);
            command.addAll(CmdFlags.getSolverExtraFlags());
            command.add(filename);
            //command.add("-model");

            ArrayList<String> stderr_lines=new ArrayList<String>();
            ArrayList<String> stdout_lines=new ArrayList<String>();

            ReadProcessOutput rpo=new ReadProcessOutput(stdout_lines);

            double solvertime=System.currentTimeMillis();

            int exitValue=RunCommand.runCommand(true, command, stderr_lines, rpo);

            solvertime=(((double) System.currentTimeMillis() - solvertime) / 1000);

            Stats stats=new CadicalStats(stdout_lines);

            if(exitValue==10) {
                // Satisfiable -- for Cadical

                // Find the line beginning "v " in stdout.
                ArrayList<String> fileContents=new ArrayList<String>();

                for(int i=0; i<stdout_lines.size(); i++) {
                    if(stdout_lines.get(i).startsWith("v ")) {
                        // Split on space to get solution literals.
                        String[] tmp=stdout_lines.get(i).trim().split(" ");
                        // Trim off the trailing 0 and starting v.
                        for(int l=1; l<tmp.length; l++) {
                            fileContents.add(tmp[l]);
                        }
                    }
                }

                return new Pair<ArrayList<String>, Stats>(fileContents, stats);
            }
            else if(exitValue==20) {
                // Unsat.
                return new Pair<ArrayList<String>, Stats>(null, stats);
            }
            else if(stderr_lines.size()!=0 || (exitValue!=10 && exitValue!=20)) {
                CmdFlags.println("SAT solver exited with error code:"+exitValue+" and message:");
                CmdFlags.println(stderr_lines);
            }
            return new Pair<ArrayList<String>, Stats>(null, stats);
        }
        catch(IOException e1) {
            System.err.println("IOException");
            e1.printStackTrace();
            CmdFlags.rmTempFiles();
            return new Pair<ArrayList<String>, Stats>(null, null);
        }
        catch(InterruptedException e2) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            return new Pair<ArrayList<String>, Stats>(null, null);
        }
    }
}
