/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BinOp;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Divide;
import savilerow.EmptyMatrix;
import savilerow.Equals;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.Pair;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.SymbolTable;
import savilerow.WeightedSum;

public class AllDifferent
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public AllDifferent(ASTNode aSTNode) {
        super(aSTNode);
    }

    public AllDifferent(ASTNode aSTNode, ASTNode aSTNode2) {
        super(CompoundMatrix.make(aSTNode, aSTNode2));
    }

    @Override
    public ASTNode copy() {
        return new AllDifferent(this.getChild(0));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in allDiff constraint: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof EmptyMatrix) {
            return new BooleanConstant(true);
        }
        if (aSTNode instanceof CompoundMatrix) {
            int n;
            int n2;
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                for (n2 = i + 1; n2 < aSTNode.numChildren(); ++n2) {
                    if (aSTNode.getChild(i).equals(aSTNode.getChild(n2))) {
                        return new BooleanConstant(false);
                    }
                    if (!aSTNode.getChild(i).isConstant() || !aSTNode.getChild(n2).isConstant() || aSTNode.getChild(i).getValue() != aSTNode.getChild(n2).getValue()) continue;
                    return new BooleanConstant(false);
                }
            }
            if (aSTNode.numChildren() < 3) {
                return new BooleanConstant(true);
            }
            if (aSTNode.getCategory() == 0) {
                return new BooleanConstant(true);
            }
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                if (!arrayList.get(n).isConstant()) continue;
                boolean bl = false;
                long l = arrayList.get(n).getValue();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ASTNode aSTNode2;
                    if (n == i) continue;
                    Intpair intpair = arrayList.get(i).getBounds();
                    if (l < intpair.lower || l > intpair.upper) continue;
                    if (arrayList.get(i) instanceof Identifier && (aSTNode2 = ((Identifier)arrayList.get(i)).getDomain()).isConstantSet()) {
                        if (!aSTNode2.containsValue(l)) continue;
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.remove(n);
                --n;
                n2 = 1;
            }
            if (n2 != 0) {
                for (n = 0; n < arrayList.size(); ++n) {
                    arrayList.get(n).setParent(null);
                }
                return new AllDifferent(CompoundMatrix.make(arrayList));
            }
            if (aSTNode.numChildren() == 3 && CmdFlags.getAfterAggregate()) {
                long l;
                long l2;
                long l3;
                long l4;
                Pair<ASTNode, ASTNode> pair;
                Pair<ASTNode, ASTNode> pair2;
                Pair<ASTNode, ASTNode> pair3;
                Pair<ASTNode, ASTNode> pair4;
                ASTNode aSTNode3 = aSTNode.getChild(1);
                ASTNode aSTNode4 = aSTNode.getChild(2);
                Intpair intpair = aSTNode3.getBounds();
                Intpair intpair2 = aSTNode4.getBounds();
                if (intpair.lower > intpair2.upper) {
                    return new BooleanConstant(true);
                }
                if (intpair.upper < intpair2.lower) {
                    return new BooleanConstant(true);
                }
                if (aSTNode3 instanceof WeightedSum && aSTNode4 instanceof WeightedSum) {
                    aSTNode3.setParent(null);
                    aSTNode4.setParent(null);
                    return new AllDifferent(CompoundMatrix.make(BinOp.makeBinOp("-", aSTNode3, aSTNode4), NumberConstant.make(0L)));
                }
                if (aSTNode3 instanceof WeightedSum && aSTNode3.getCategory() == 3 && aSTNode4.getCategory() < 3 && (pair4 = ((WeightedSum)aSTNode3).retrieveConstant()) != null) {
                    aSTNode4.setParent(null);
                    return new AllDifferent(CompoundMatrix.make(pair4.getSecond(), BinOp.makeBinOp("-", aSTNode4, pair4.getFirst())));
                }
                if (aSTNode4 instanceof WeightedSum && aSTNode4.getCategory() == 3 && aSTNode3.getCategory() < 3 && (pair3 = ((WeightedSum)aSTNode4).retrieveConstant()) != null) {
                    aSTNode3.setParent(null);
                    return new AllDifferent(CompoundMatrix.make(pair3.getSecond(), BinOp.makeBinOp("-", aSTNode3, pair3.getFirst())));
                }
                if (aSTNode3 instanceof WeightedSum && aSTNode4.isConstant() && (pair2 = ((WeightedSum)aSTNode3).factorOutGCD()) != null) {
                    long l5 = pair2.getFirst().getValue();
                    long l6 = aSTNode4.getValue();
                    long l7 = Divide.div(l6, l5);
                    if (l7 * l5 != l6) {
                        return new BooleanConstant(true);
                    }
                    return new AllDifferent(CompoundMatrix.make(pair2.getSecond(), NumberConstant.make(l7)));
                }
                if (aSTNode4 instanceof WeightedSum && aSTNode3.isConstant() && (pair = ((WeightedSum)aSTNode4).factorOutGCD()) != null) {
                    long l8 = pair.getFirst().getValue();
                    long l9 = aSTNode3.getValue();
                    long l10 = Divide.div(l9, l8);
                    if (l10 * l8 != l9) {
                        return new BooleanConstant(true);
                    }
                    return new AllDifferent(CompoundMatrix.make(pair.getSecond(), NumberConstant.make(l10)));
                }
                if (aSTNode3 instanceof WeightedSum && aSTNode3.numChildren() == 2 && aSTNode4.isConstant() && aSTNode4.getValue() == 0L && (l4 = ((WeightedSum)aSTNode3).getWeight(0)) + (l3 = ((WeightedSum)aSTNode3).getWeight(1)) == 0L) {
                    aSTNode3.getChild(0).setParent(null);
                    aSTNode3.getChild(1).setParent(null);
                    return new AllDifferent(CompoundMatrix.make(aSTNode3.getChild(0), aSTNode3.getChild(1)));
                }
                if (aSTNode4 instanceof WeightedSum && aSTNode4.numChildren() == 2 && aSTNode3.isConstant() && aSTNode3.getValue() == 0L && (l2 = ((WeightedSum)aSTNode4).getWeight(0)) + (l = ((WeightedSum)aSTNode4).getWeight(1)) == 0L) {
                    aSTNode4.getChild(0).setParent(null);
                    aSTNode4.getChild(1).setParent(null);
                    return new AllDifferent(CompoundMatrix.make(aSTNode4.getChild(0), aSTNode4.getChild(1)));
                }
            }
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3;
    }

    @Override
    public ASTNode negation() {
        assert (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3);
        return new Equals(this.getChild(0).getChild(1), this.getChild(0).getChild(2));
    }

    @Override
    public ASTNode normalise() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = AllDifferent.sortByHashcode(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            return new AllDifferent(new CompoundMatrix(arrayList));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return null;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = AllDifferent.sortByAlpha(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            return new AllDifferent(new CompoundMatrix(arrayList));
        }
        return null;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            bufferedWriter.append("diseq(");
            aSTNode.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(",");
            aSTNode.getChild(2).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            String string = "gacalldiff";
            if (aSTNode instanceof CompoundMatrix) {
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (!CmdFlags.getUseBoundVars() || !aSTNode.getChild(i).exceedsBoundThreshold()) continue;
                    string = "alldiff";
                    break;
                }
            }
            bufferedWriter.append(string);
            bufferedWriter.append("(");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        assert (this.getChild(0) instanceof CompoundMatrix);
        assert (this.getChild(0).numChildren() == 3);
        stringBuilder.append("(");
        this.getChild(0).getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("!=");
        this.getChild(0).getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getCategory() <= 2) {
            this.toDominionParam(stringBuilder);
            return;
        }
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        stringBuilder.append(CmdFlags.getCtName() + " ");
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("noteq(");
            aSTNode.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            aSTNode.getChild(2).toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("alldiff(flatten(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append("))");
        }
    }

    @Override
    public String toString() {
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            return "(" + this.getChild(0).getChild(1) + " != " + this.getChild(0).getChild(2) + ")";
        }
        return "allDiff(" + this.getChild(0) + ")";
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            bufferedWriter.append("constraint int_ne(");
            aSTNode.getChild(1).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            aSTNode.getChild(2).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(");");
        } else {
            bufferedWriter.append("constraint all_different_int(");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(")::domain;");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("(");
            aSTNode.getChild(1).toMinizinc(stringBuilder, false);
            stringBuilder.append("!=");
            aSTNode.getChild(2).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("all_different(");
            this.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        assert (this.getChild(0).numChildren() == 3);
        ASTNode aSTNode = this.getChild(0).getChild(1);
        ASTNode aSTNode2 = this.getChild(0).getChild(2);
        if (aSTNode.isConstant()) {
            return -aSTNode2.directEncode(sat, aSTNode.getValue());
        }
        if (aSTNode2.isConstant()) {
            return -aSTNode.directEncode(sat, aSTNode2.getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (this.getChild(0).numChildren() == 3);
        ASTNode aSTNode = this.getChild(0);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = i + 1; j < aSTNode.numChildren(); ++j) {
                sat.directEncoding(this, aSTNode.getChild(i), aSTNode.getChild(j));
            }
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        assert (this.getChild(0).numChildren() == 3);
        new Equals(this.getChild(0).getChild(1), this.getChild(0).getChild(2)).toSATWithAuxVar(sat, -l);
    }

    @Override
    public boolean test(long l, long l2) {
        return l != l2;
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Children\": [");
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            this.getChild(0).getChild(1).toJSON(stringBuilder);
            stringBuilder.append(", ");
            this.getChild(0).getChild(2).toJSON(stringBuilder);
        } else {
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append("\n");
                this.getChild(i).toJSON(stringBuilder);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean usesSMTEncoding() {
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            return true;
        }
        return !CmdFlags.SMTDecompAlldiff();
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        sMT.addSMTClause(this.smtEncodeBool(sMT));
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        String string = "(distinct";
        for (ASTNode aSTNode : this.getChildren()) {
            if (CmdFlags.getUseBV()) {
                string = string + " " + aSTNode.smtEncodeBV(sMT);
                continue;
            }
            string = string + " " + aSTNode.smtEncodeInt(sMT);
        }
        return string + ")";
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + SMT.toSMTBV(1L) + " " + SMT.toSMTBV(0L) + ")";
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3;
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return !(this.getChild(0) instanceof CompoundMatrix) || this.getChild(0).numChildren() != 3;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return this.isMyOnlyOtherSiblingEqualZero(n);
    }
}

