/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CadicalStats;
import savilerow.CmdFlags;
import savilerow.Model;
import savilerow.Pair;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.SATSolver;
import savilerow.Stats;

public class CadicalSATSolver
extends SATSolver {
    public CadicalSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
            if (stats != null && (n = arrayList2.indexOf("-t")) != -1) {
                int n2 = Integer.parseInt(arrayList2.get(n + 1));
                int n3 = n2 - (int)Math.floor(Double.valueOf(stats.getValue("SolverTotalTime"))) + 1;
                if (n3 > n2) {
                    n3 = n2;
                }
                if (n3 < 1) {
                    n3 = 1;
                }
                arrayList2.set(n + 1, String.valueOf(n3));
            }
            arrayList.addAll(arrayList2);
            arrayList.add(string2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList4);
            double d = System.currentTimeMillis();
            int n4 = RunCommand.runCommand(true, arrayList, arrayList3, readProcessOutput);
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            CadicalStats cadicalStats = new CadicalStats(arrayList4);
            if (n4 == 10) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                for (int i = 0; i < arrayList4.size(); ++i) {
                    if (!arrayList4.get(i).startsWith("v ")) continue;
                    String[] stringArray = arrayList4.get(i).trim().split(" ");
                    for (int j = 1; j < stringArray.length; ++j) {
                        arrayList5.add(stringArray[j]);
                    }
                }
                return new Pair<ArrayList<String>, Stats>(arrayList5, cadicalStats);
            }
            if (n4 == 20) {
                return new Pair<Object, CadicalStats>(null, cadicalStats);
            }
            if (arrayList3.size() != 0 || n4 != 10 && n4 != 20) {
                int n5;
                CmdFlags.println("SAT solver exited with error code:" + n4 + " and message:");
                CmdFlags.println(arrayList3);
                int n6 = arrayList2.indexOf("-t");
                if (n6 != -1 && d > (double)(n5 = Integer.parseInt(arrayList2.get(n6 + 1)))) {
                    cadicalStats.putValue("SolverTimeOut", "1");
                }
            }
            return new Pair<Object, CadicalStats>(null, cadicalStats);
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }
}

