/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BooleanDomain;
import savilerow.CmdFlags;
import savilerow.EmptyMatrix;
import savilerow.EmptyRange;
import savilerow.IntegerDomain;
import savilerow.IntegerDomainConcrete;
import savilerow.Intpair;
import savilerow.MatrixDomain;
import savilerow.Max;
import savilerow.Min;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Range;
import savilerow.SMT;
import savilerow.SimpleDomain;
import savilerow.SymbolTable;

public class CompoundMatrix
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public CompoundMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        super(aSTNode, arrayList.toArray(new ASTNode[arrayList.size()]));
        assert (aSTNode != null);
        assert (arrayList.size() > 0);
    }

    public CompoundMatrix(ASTNode aSTNode, ASTNode[] aSTNodeArray) {
        super(aSTNode, aSTNodeArray);
        assert (aSTNode != null);
        assert (aSTNodeArray.length > 0);
    }

    public CompoundMatrix(ArrayList<ASTNode> arrayList) {
        IntegerDomainConcrete integerDomainConcrete = new IntegerDomainConcrete(1, arrayList.size());
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(integerDomainConcrete);
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
        assert (arrayList.size() > 0);
    }

    public CompoundMatrix(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
        assert (aSTNodeArray[0] != null);
    }

    public static ASTNode make(ASTNode aSTNode, ArrayList<ASTNode> arrayList, boolean bl) {
        if (arrayList.size() > 0) {
            return new CompoundMatrix(aSTNode, arrayList);
        }
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        SimpleDomain simpleDomain = bl ? new BooleanDomain(new EmptyRange()) : new IntegerDomain(new EmptyRange());
        return new EmptyMatrix(new MatrixDomain((ASTNode)simpleDomain, arrayList2));
    }

    public static ASTNode make(ArrayList<ASTNode> arrayList) {
        if (arrayList.size() == 0) {
            return CompoundMatrix.make((ASTNode)new IntegerDomain(new EmptyRange()), arrayList, false);
        }
        return CompoundMatrix.make((ASTNode)new IntegerDomain(new Range((ASTNode)NumberConstant.make(1L), NumberConstant.make(arrayList.size()))), arrayList, false);
    }

    public static ASTNode make(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        return new CompoundMatrix(arrayList);
    }

    public static ASTNode make(ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(aSTNode2);
        return new CompoundMatrix(arrayList);
    }

    public static ASTNode make(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(aSTNode2);
        arrayList.add(aSTNode3);
        return new CompoundMatrix(arrayList);
    }

    @Override
    public boolean isRelation() {
        boolean bl = true;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).isRelation()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean strongProp() {
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumerical() {
        boolean bl = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (!this.getChild(i).isNumerical()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean isSet() {
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).isSet()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASTNode copy() {
        return new CompoundMatrix(this.getChildrenArray());
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(1).getBounds();
        for (int i = 2; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            if (intpair2.lower < intpair.lower) {
                intpair.lower = intpair2.lower;
            }
            if (intpair2.upper <= intpair.upper) continue;
            intpair.upper = intpair2.upper;
        }
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 1; i < this.numChildren(); ++i) {
            PairASTNode pairASTNode = this.getChild(i).getBoundsAST();
            arrayList.add(pairASTNode.e1);
            arrayList2.add(pairASTNode.e2);
        }
        return new PairASTNode(new Min(arrayList), new Max(arrayList2));
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSetExp();
        for (int i = 2; i < this.numChildren(); ++i) {
            ArrayList<Intpair> arrayList2 = this.getChild(i).getIntervalSetExp();
            arrayList = Intpair.union(arrayList, arrayList2);
        }
        return arrayList;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        n = this.getChild(1).getDimension();
        for (int i = 2; i < this.numChildren(); ++i) {
            if (this.getChild(i).getDimension() == n) continue;
            System.out.println("ERROR: In matrix literal: " + this);
            System.out.println("ERROR: Elements in matrix literal have different numbers of dimensions.");
            return false;
        }
        if (!this.getChild(0).isFiniteSet()) {
            System.out.println("ERROR: In matrix literal: " + this);
            System.out.println("ERROR: Index set is not a finite set.");
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        if (this.numChildren() == 1) {
            assert (false) : "CompoundMatrix type must have non-zero size.";
            return 1;
        }
        return 1 + this.getChild(1).getDimension();
    }

    @Override
    public boolean isRegularMatrix() {
        if (this.getDimension() > 1) {
            for (int i = 1; i < this.numChildren(); ++i) {
                if (this.getChild(i).isRegularMatrix()) continue;
                return false;
            }
            ArrayList<ASTNode> arrayList = this.getChild(1).getIndexDomains();
            for (int i = 2; i < this.numChildren(); ++i) {
                if (this.getChild(i).getIndexDomains().equals(arrayList)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        ArrayList<Object> arrayList;
        assert (this.numChildren() >= 2);
        if (this.getDimension() > 1) {
            arrayList = this.getChild(1).getIndexDomains();
            if (arrayList == null) {
                return null;
            }
        } else {
            arrayList = new ArrayList();
        }
        arrayList.add(0, this.getChild(0));
        return arrayList;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomainsIrregular() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(this.getChild(0));
        if (this.getDimension() > 1) {
            for (int i = 1; i < this.numChildren(); ++i) {
                ArrayList<ASTNode> arrayList2 = this.getChild(i).getIndexDomainsIrregular();
                if (i == 1) {
                    arrayList.addAll(arrayList2);
                    continue;
                }
                for (int j = 1; j < arrayList.size(); ++j) {
                    if (arrayList2.get(j - 1).equals(arrayList.get(j))) continue;
                    arrayList.set(j, new IntegerDomain(new Range(null, null)));
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean isMatrixLiteral() {
        if (this.getDimension() > 1) {
            for (int i = 1; i < this.numChildren(); ++i) {
                if (this.getChild(i).isMatrixLiteral()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        bufferedWriter.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(", ");
        }
        bufferedWriter.append("]");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i).toString());
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
            if (!(this.getChild(i) instanceof CompoundMatrix) && !(this.getChild(i) instanceof EmptyMatrix)) continue;
            stringBuilder.append("\n");
        }
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSet();
        if (arrayList == null || arrayList.size() != 1 || arrayList.get((int)0).lower != 1L || Intpair.numValues(arrayList) != (long)(this.numChildren() - 1)) {
            stringBuilder.append(";");
            stringBuilder.append(this.getChild(0).toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String toStringSimpleMatrix() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i) instanceof CompoundMatrix) {
                stringBuilder.append(((CompoundMatrix)this.getChild(i)).toStringSimpleMatrix());
            } else if (this.getChild(i) instanceof EmptyMatrix) {
                stringBuilder.append("[ ]");
            } else {
                stringBuilder.append(this.getChild(i).toString());
            }
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
            if (!(this.getChild(i) instanceof CompoundMatrix) && !(this.getChild(i) instanceof EmptyMatrix)) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(bufferedWriter, bl);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(", ");
        }
        bufferedWriter.append("]");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, bl);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Domain\":");
        this.getChild(0).toJSON(stringBuilder);
        stringBuilder.append(",\n");
        stringBuilder.append("\"Children\": [");
        int n = this.numChildren();
        for (int i = 1; i < this.numChildren(); ++i) {
            stringBuilder.append("\n");
            this.getChild(i).toJSON(stringBuilder);
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        String string = "";
        if (this.numChildren() >= 2) {
            string = string + this.getChild(1).smtEncodeInt(sMT);
            for (int i = 2; i < this.numChildren(); ++i) {
                string = string + " " + this.getChild(i).smtEncodeInt(sMT);
            }
        }
        return string;
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        String string = "";
        if (this.numChildren() >= 2) {
            string = string + this.getChild(1).smtEncodeBV(sMT);
            for (int i = 2; i < this.numChildren(); ++i) {
                string = string + " " + this.getChild(i).smtEncodeBV(sMT);
            }
        }
        return string;
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getParent().isChildSymmetric(this.getChildNo());
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL();
    }
}

