/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.IntegerDomain;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Range;
import savilerow.SymbolTable;

public class CompoundMatrixConst
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    int[] data;

    public CompoundMatrixConst(int[] nArray) {
        assert (nArray.length > 0);
        this.data = nArray;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public ASTNode copy() {
        int[] nArray = new int[this.data.length];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        return new CompoundMatrixConst(nArray);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public Intpair getBounds() {
        int n = this.data[0];
        int n2 = this.data[0];
        for (int i = 1; i < this.data.length; ++i) {
            int n3 = this.data[i];
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return new Intpair(n, n2);
    }

    @Override
    public PairASTNode getBoundsAST() {
        Intpair intpair = this.getBounds();
        return new PairASTNode(NumberConstant.make(intpair.lower), NumberConstant.make(intpair.upper));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        return true;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean isRegularMatrix() {
        return true;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(new IntegerDomain(new Range((ASTNode)NumberConstant.make(1L), NumberConstant.make(this.data.length))));
        return arrayList;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomainsIrregular() {
        return this.getIndexDomains();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        bufferedWriter.append("[");
        for (int i = 0; i < this.data.length; ++i) {
            bufferedWriter.append(String.valueOf(this.data[i]));
            if (i >= this.data.length - 1) continue;
            bufferedWriter.append(", ");
        }
        bufferedWriter.append("]");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append(this.data[i]);
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("[");
        for (int i = 0; i < this.data.length; ++i) {
            bufferedWriter.append(String.valueOf(this.data[i]));
            if (i >= this.data.length - 1) continue;
            bufferedWriter.append(", ");
        }
        bufferedWriter.append("]");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Domain\":");
        this.getIndexDomains().get(0).toJSON(stringBuilder);
        stringBuilder.append(",\n");
        stringBuilder.append("\"Children\": [");
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.data[i] + "\n");
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getParent().isChildSymmetric(this.getChildNo());
    }
}

