/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.GlucoseStats;
import savilerow.Model;
import savilerow.Pair;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.SATSolver;
import savilerow.Stats;

public class GlucoseSATSolver
extends SATSolver {
    public GlucoseSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            arrayList.add(string2);
            arrayList.add("-model");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList3);
            double d = System.currentTimeMillis();
            int n = RunCommand.runCommand(true, arrayList, arrayList2, readProcessOutput);
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            GlucoseStats glucoseStats = new GlucoseStats(arrayList3);
            if (n == 10) {
                ArrayList<String> arrayList4 = null;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    if (!arrayList3.get(i).startsWith("v ")) continue;
                    String[] stringArray = arrayList3.get(i).trim().split(" ");
                    arrayList4 = new ArrayList<String>(stringArray.length - 2);
                    for (int j = 1; j < stringArray.length - 1; ++j) {
                        arrayList4.add(stringArray[j]);
                    }
                    break;
                }
                return new Pair<Object, GlucoseStats>(arrayList4, glucoseStats);
            }
            if (n == 20) {
                return new Pair<Object, GlucoseStats>(null, glucoseStats);
            }
            if (arrayList2.size() != 0 || n != 10 && n != 20) {
                CmdFlags.println("SAT solver exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
            }
            return new Pair<Object, GlucoseStats>(null, glucoseStats);
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }
}

