/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import savilerow.CmdFlags;
import savilerow.InteractiveSMT;
import savilerow.Model;

public class InteractiveRunCommand {
    Model model;
    Process process;
    BufferedReader input;
    public BufferedWriter output;
    ConcurrentLinkedQueue<String> outputContents;
    public ArrayList<String> stdout_lines;
    CountDownLatch isSolverDone;
    AtomicInteger solverResult;
    String smtLastVar;

    public InteractiveRunCommand(Model model, ArrayList<String> arrayList) {
        try {
            this.model = model;
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.output = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            this.isSolverDone = new CountDownLatch(1);
            this.solverResult = new AtomicInteger(0);
            this.outputContents = new ConcurrentLinkedQueue();
            this.stdout_lines = new ArrayList();
            this.startOutputHandlerThread();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("IRC failure");
            iOException.printStackTrace();
        }
    }

    private void startOutputHandlerThread() throws IOException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            String string;
                            if ("sat".equals(string = InteractiveRunCommand.this.input.readLine()) || "unsat".equals(string) || "unknown".equals(string) || string.contains(InteractiveRunCommand.this.smtLastVar)) {
                                if ("sat".equals(string.trim())) {
                                    InteractiveRunCommand.this.solverResult.set(1);
                                } else if ("unsat".equals(string.trim())) {
                                    InteractiveRunCommand.this.solverResult.set(2);
                                } else {
                                    InteractiveRunCommand.this.solverResult.set(3);
                                }
                                InteractiveRunCommand.this.isSolverDone.countDown();
                            }
                            InteractiveRunCommand.this.outputContents.add(string);
                        }
                    }
                    catch (IOException iOException) {
                        CmdFlags.errorExit("IRC BR failure");
                        iOException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        thread.start();
    }

    private String getCheckCommand() {
        if (((InteractiveSMT)this.model.satModel).activeAssumptions.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(check-sat-assuming (");
            for (String string : ((InteractiveSMT)this.model.satModel).activeAssumptions) {
                stringBuilder.append(string);
                stringBuilder.append(" ");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("))");
            return stringBuilder.toString();
        }
        return "(check-sat)";
    }

    public int processCurrentModel() {
        this.smtLastVar = ((InteractiveSMT)this.model.satModel).getLastVarPrefix();
        try {
            this.output.write(this.getCheckCommand());
            this.output.newLine();
            this.output.flush();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Output stream failure");
        }
        try {
            this.isSolverDone.await();
        }
        catch (InterruptedException interruptedException) {
            CmdFlags.errorExit("Thread interrupred");
        }
        int n = this.solverResult.get();
        this.outputContents.clear();
        try {
            if (n == 1) {
                this.isSolverDone = new CountDownLatch(1);
                ((InteractiveSMT)this.model.satModel).requestVariableStream();
                this.isSolverDone.await();
            }
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Output stream failure");
        }
        catch (InterruptedException interruptedException) {
            CmdFlags.errorExit("Thread interrupred");
        }
        this.stdout_lines.clear();
        while (this.outputContents.size() > 0) {
            String string = this.outputContents.poll();
            if (string.contains("(error")) continue;
            this.stdout_lines.add(string);
        }
        this.isSolverDone = new CountDownLatch(1);
        this.solverResult.set(0);
        if (n == 0) {
            CmdFlags.errorExit("Solver state is unset. Probably a bug");
        }
        return n * 10;
    }
}

