/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.InteractiveBoolectorSolver;
import savilerow.InteractiveSMTSolver;
import savilerow.InteractiveYicesSolver;
import savilerow.InteractiveZ3Solver;
import savilerow.Model;
import savilerow.SMT;

public class InteractiveSMT
extends SMT {
    private InteractiveSMTSolver iSolver;
    private long assumptionCount;
    public HashSet<String> activeAssumptions;

    public InteractiveSMT(Model model) {
        super(model.global_symbols);
        this.initInteractiveSolver(model);
        this.outstream = this.iSolver.outputStream;
        this.assumptionCount = 0L;
        this.activeAssumptions = new HashSet();
        try {
            this.createHeader();
            this.trueVar = this.getNextVariableNumber();
            this.addClause(this.trueVar);
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Failed to pipe into SMT solver");
        }
    }

    private void initInteractiveSolver(Model model) {
        if (CmdFlags.usingZ3()) {
            CmdFlags.addSolverFlag("-in");
            this.iSolver = new InteractiveZ3Solver(model);
        } else if (CmdFlags.usingBoolector()) {
            CmdFlags.addSolverFlag("-i");
            this.iSolver = new InteractiveBoolectorSolver(model);
        } else {
            assert (CmdFlags.usingYices2());
            CmdFlags.addSolverFlag("--incremental");
            this.iSolver = new InteractiveYicesSolver(model);
        }
    }

    public InteractiveSMTSolver getInteractiveSolver() {
        return this.iSolver;
    }

    @Override
    public void removeFinalClause() {
    }

    @Override
    public void removeSolvingInstructions() {
    }

    @Override
    public void addClauseAfterFinalise(ArrayList<Long> arrayList) throws IOException {
        super.addClause(arrayList);
    }

    @Override
    public void addClauseAfterFinalise(long l, boolean bl) throws IOException {
        if (bl) {
            this.addAssumption(l);
        } else {
            super.addClauseAfterFinalise(l, false);
        }
    }

    @Override
    public void addClauseAfterFinalise2(long l, long l2, boolean bl) throws IOException {
        if (bl) {
            this.addAssumption(l);
            this.addAssumption(l2);
        } else {
            super.addClauseAfterFinalise2(l, l2, false);
        }
    }

    @Override
    public void addSMTClauseAfterFinalise(String string, boolean bl) throws IOException {
        if (bl) {
            this.addSMTAssumption(string);
        } else {
            this.addSMTClause(string);
        }
    }

    @Override
    public void addSMTClauseAfterFinalise2(String string, String string2, boolean bl) throws IOException {
        if (bl) {
            this.addSMTAssumption(string);
            this.addSMTAssumption(string2);
        } else {
            this.addSMTClause(string);
            this.addSMTClause(string2);
        }
    }

    @Override
    public void finaliseOutput() throws IOException {
    }

    public void requestVariableStream() throws IOException {
        if (!CmdFlags.usingBoolector()) {
            this.outstream.write("(get-info :all-statistics)");
            this.outstream.newLine();
        }
        for (String string : this.variables) {
            this.outstream.write("(get-value (" + string + "))");
            this.outstream.newLine();
        }
        this.outstream.flush();
    }

    public String getLastVarPrefix() {
        return "((" + (String)this.variables.get(this.variables.size() - 1) + " ";
    }

    public void addAssumption(long l) throws IOException {
        String string = "sr_assumption_" + this.assumptionCount;
        this.outstream.write("(declare-const " + string + " Bool)");
        this.outstream.newLine();
        this.outstream.write("(assert (= " + string + " ");
        if (l != -this.trueVar) {
            this.writeLiteral(l);
        } else {
            this.outstream.write("false");
        }
        this.outstream.write("))");
        this.outstream.newLine();
        this.activeAssumptions.add(string);
        ++this.numClauses;
        ++this.assumptionCount;
    }

    public void addSMTAssumption(String string) throws IOException {
        String string2 = "sr_assumption_" + this.assumptionCount;
        this.outstream.write("(declare-const " + string2 + " Bool)");
        this.outstream.newLine();
        if (string == null) {
            this.outstream.close();
            System.exit(0);
        }
        assert (InteractiveSMT.checkParenthesis(string));
        this.outstream.write("(assert (= " + string2 + " ");
        this.outstream.write(string);
        this.outstream.write("))");
        this.outstream.newLine();
        this.activeAssumptions.add(string2);
        ++this.numClauses;
        ++this.assumptionCount;
    }
}

