/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.ComprehensionForall;
import savilerow.ComprehensionMatrix;
import savilerow.EmptyMatrix;
import savilerow.Identifier;
import savilerow.Indices;
import savilerow.IntegerDomain;
import savilerow.Intpair;
import savilerow.MatrixDeref;
import savilerow.MatrixDomain;
import savilerow.Model;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Range;
import savilerow.SafeMatrixDeref;
import savilerow.SymbolTable;
import savilerow.Unpack;

public class MatrixSlice
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    protected transient Model m;

    public MatrixSlice(Model model, ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        super(aSTNode, arrayList.toArray(new ASTNode[arrayList.size()]));
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode copy() {
        return new MatrixSlice(this.m, this.getChild(0), this.getChildren(1));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (aSTNode.typecheck(symbolTable)) continue;
            return false;
        }
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() <= 2) continue;
        }
        if (this.numChildren() - 1 != this.getChild(0).getDimension()) {
            CmdFlags.println("ERROR: Number of indices in matrix slice does not match dimensions of matrix:");
            CmdFlags.println("ERROR: " + this);
            return false;
        }
        return true;
    }

    @Override
    public boolean typecheck2(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck2(symbolTable)) continue;
            return false;
        }
        for (n = 1; n < this.numChildren(); ++n) {
            if (this.getChild(n) instanceof Unpack || this.getChild(n).getDimension() <= 0) continue;
            System.out.println("ERROR: In matrix slice " + this + ", index \"" + this.getChild(n) + "\" is a matrix. Scalar types int and bool are allowed here.");
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode;
        int n;
        for (n = 1; n < this.numChildren(); ++n) {
            if (!(this.getChild(n) instanceof Unpack)) continue;
            ArrayList<ASTNode> arrayList = ((Unpack)this.getChild(1)).items();
            if (arrayList != null) {
                int n2;
                this.detachChildren();
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(this.numChildren() + arrayList.size() - 2);
                for (n2 = 1; n2 < n; ++n2) {
                    arrayList2.add(this.getChild(n2));
                }
                arrayList2.addAll(arrayList);
                for (n2 = n + 1; n2 < this.numChildren(); ++n2) {
                    arrayList2.add(this.getChild(n2));
                }
                return new MatrixSlice(this.m, this.getChild(0), arrayList2);
            }
            return null;
        }
        n = 1;
        boolean bl = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            int n3 = this.getChild(i).getCategory();
            if (n3 > 0) {
                n = 0;
            }
            if (n3 != 3) continue;
            bl = true;
        }
        if (n != 0 && ((aSTNode = this.getChildConst(0)) instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix)) {
            ASTNode aSTNode2 = MatrixSlice.evaluateSlice(aSTNode, this.getChildren(1));
            return aSTNode2 == null ? null : aSTNode2;
        }
        if (bl) {
            ASTNode aSTNode3;
            ArrayList<ASTNode> arrayList = MatrixSlice.list();
            ArrayList<ASTNode> arrayList3 = MatrixSlice.list();
            for (int i = 1; i < this.numChildren(); ++i) {
                if (this.getChild(i).isSet()) {
                    aSTNode3 = new Identifier(this.m, this.m.global_symbols.newAuxId());
                    arrayList.add(aSTNode3);
                    arrayList3.add(aSTNode3);
                    continue;
                }
                arrayList.add(null);
                arrayList3.add(this.getChild(i));
            }
            this.getChild(0).setParent(null);
            ASTNodeC aSTNodeC = new SafeMatrixDeref(this.getChild(0), arrayList3);
            aSTNode3 = new Indices(this.getChild(0));
            for (int i = this.numChildren() - 1; i >= 1; --i) {
                if (!this.getChild(i).isSet()) continue;
                MatrixDeref matrixDeref = new MatrixDeref(aSTNode3, MatrixSlice.list(NumberConstant.make(i)));
                aSTNodeC = new ComprehensionMatrix((ASTNode)aSTNodeC, MatrixSlice.list(new ComprehensionForall(arrayList.get(i - 1), matrixDeref)), (ASTNode)new BooleanConstant(true), (ASTNode)matrixDeref);
            }
            return aSTNodeC;
        }
        return null;
    }

    public static ASTNode evaluateSlice(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        long l;
        if (arrayList.size() == 0) {
            assert (!(aSTNode instanceof CompoundMatrix) && !(aSTNode instanceof EmptyMatrix));
            return aSTNode;
        }
        ASTNode aSTNode2 = arrayList.get(0);
        if (aSTNode instanceof EmptyMatrix) {
            ASTNode aSTNode3 = aSTNode.getChild(0);
            ArrayList<ASTNode> arrayList2 = aSTNode3.getChildren(3);
            assert (arrayList2.size() == arrayList.size());
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                if (arrayList.get(i).equals(new IntegerDomain(new Range(null, null)))) continue;
                arrayList2.remove(i);
            }
            return new EmptyMatrix(new MatrixDomain(aSTNode.getChild(0).getChild(0), arrayList2));
        }
        if (aSTNode2.isSet()) {
            assert (!aSTNode2.isFiniteSetUpper() && !aSTNode2.isFiniteSetLower());
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>(arrayList);
            arrayList4.remove(0);
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode4 = MatrixSlice.evaluateSlice(aSTNode.getChildConst(i), arrayList4);
                if (aSTNode4 == null) {
                    return null;
                }
                arrayList3.add(aSTNode4);
            }
            return new CompoundMatrix(aSTNode.getChild(0), arrayList3);
        }
        ArrayList<Intpair> arrayList5 = aSTNode instanceof CompoundMatrix ? aSTNode.getChild(0).getIntervalSet() : (aSTNode instanceof EmptyMatrix ? new ArrayList() : null);
        long l2 = Intpair.location(arrayList5, l = aSTNode2.getValue());
        if (l2 == -1L) {
            return null;
        }
        ArrayList<ASTNode> arrayList6 = new ArrayList<ASTNode>(arrayList);
        arrayList6.remove(0);
        return MatrixSlice.evaluateSlice(aSTNode.getChildConst((int)l2 + 1), arrayList6);
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        ASTNode aSTNode;
        if (this.getChild(0) instanceof Identifier && this.getChild(0).getCategory() == 3 && (aSTNode = this.m.global_symbols.getDomain(this.getChild(0).toString())) != null && aSTNode instanceof MatrixDomain) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(3);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 1; i < this.numChildren(); ++i) {
                ArrayList<Intpair> arrayList3 = this.getChild(i).getIntervalSet();
                if (arrayList3 == null || arrayList3.size() != 1 || arrayList3.get((int)0).lower != Long.MIN_VALUE || arrayList3.get((int)0).upper != Long.MAX_VALUE) continue;
                arrayList2.add(arrayList.get(i - 1));
            }
            return arrayList2;
        }
        return null;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("]");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        this.toDominionParam(stringBuilder);
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public int getDimension() {
        int n = 0;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (!this.getChild(i).isSet()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String toString() {
        String string = this.getChild(0).toString() + "[";
        for (int i = 1; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ",";
        }
        return string + "]";
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).isSet() || this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }
}

