/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import savilerow.AMODetect;
import savilerow.ASTNode;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.EmptyRange;
import savilerow.Find;
import savilerow.Identifier;
import savilerow.IntegerDomain;
import savilerow.Intpair;
import savilerow.MatrixDomain;
import savilerow.MinionStats;
import savilerow.Model;
import savilerow.NumberConstant;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.Solution;
import savilerow.Solver;
import savilerow.SymbolTable;
import savilerow.Table;
import savilerow.categoryentry;

public class MinionSolver
extends Solver {
    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        CmdFlags.createTempFiles();
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        this.runMinion(string, string2, model, false, -1);
        MinionStats minionStats = null;
        boolean bl = model.objective != null ? true : (CmdFlags.getFindAllSolutions() ? false : CmdFlags.getFindNumSolutions() <= 1L);
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
            Solution solution = this.parseLastSolverSolution(model.global_symbols, bufferedReader);
            minionStats = this.addStatisticsToSolution(solution, d);
            if (solution != null || model.incumbentSolution != null) {
                this.createSolutionFile(solution != null ? solution : model.incumbentSolution, false);
            }
        } else {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
            this.parseAllSolverSolutions(model.global_symbols, bufferedReader);
            bufferedReader = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
            Solution solution = this.parseLastSolverSolution(model.global_symbols, bufferedReader);
            minionStats = this.addStatisticsToSolution(solution, d);
        }
        if (minionStats != null) {
            minionStats.makeInfoFiles();
        }
        CmdFlags.rmTempFiles();
    }

    public ArrayList<ASTNode> reduceDomains(String string, String string2, Model model) throws IOException, InterruptedException {
        AMODetect.init();
        long l = 0L;
        ArrayList<String> arrayList = this.runMinion(string, string2, model, true, -1);
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            String[] stringArray;
            String string3 = arrayList.get(i);
            if (string3.length() >= 4 && string3.substring(0, 4).equals("find")) {
                stringArray = string3.split("\\s");
                String string4 = stringArray[1];
                assert (stringArray[2].equals(":"));
                String string5 = stringArray[3].substring(4, stringArray[3].length() - 1);
                if (string5.equals("")) {
                    arrayList2.add(new Find((ASTNode)new Identifier(model, string4), new IntegerDomain(new EmptyRange())));
                    continue;
                }
                String[] stringArray2 = string5.split(",");
                ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>(stringArray2.length);
                for (n = 0; n < stringArray2.length; ++n) {
                    String[] stringArray3 = stringArray2[n].split("\\.\\.");
                    arrayList3.add(new Intpair(Long.parseLong(stringArray3[0]), Long.parseLong(stringArray3[1])));
                }
                arrayList2.add(new Find((ASTNode)new Identifier(model, string4), Intpair.makeDomain(arrayList3, false)));
                continue;
            }
            if (string3.length() >= 3 && string3.substring(0, 3).equals("AMO") && !string3.trim().equals("AMO 0")) {
                int n2;
                int n3 = string3.length();
                for (n2 = 4; n2 < n3 && string3.charAt(n2) != ' '; ++n2) {
                }
                int n4 = 0;
                int n5 = 0;
                boolean bl = false;
                n = string3.charAt(++n2);
                block3: while (true) {
                    n4 = 0;
                    if (n == 45) {
                        bl = true;
                        n = string3.charAt(++n2);
                    }
                    while (n != 32) {
                        n4 = 10 * n4 + (n - 48);
                        if (++n2 >= n3) break block3;
                        n = string3.charAt(n2);
                    }
                    if (bl) {
                        n4 = -n4;
                        bl = false;
                    }
                    n = string3.charAt(++n2);
                    n5 = 0;
                    if (n == 45) {
                        bl = true;
                        n = string3.charAt(++n2);
                    }
                    while (n != 32) {
                        n5 = 10 * n5 + (n - 48);
                        if (++n2 >= n3) break;
                        n = string3.charAt(n2);
                    }
                    if (bl) {
                        n5 = -n5;
                        bl = false;
                    }
                    AMODetect.addEdge(n4, n5);
                    ++l;
                    if (++n2 >= n3) break;
                    n = string3.charAt(n2);
                }
                arrayList.set(i, null);
                continue;
            }
            if (string3.length() < 9 || !string3.substring(0, 9).equals("BOOLNAMES")) continue;
            stringArray = string3.split("\\s+");
            for (int j = 1; j < stringArray.length; ++j) {
                int n6 = AMODetect.add_variable_amo(stringArray[j]);
                assert (n6 == j);
            }
        }
        if (CmdFlags.amo_detect) {
            System.out.println("Found " + l + " mutexes");
        }
        return arrayList2;
    }

    public ASTNode makeTable(Model model, ArrayList<ASTNode> arrayList) throws IOException, InterruptedException {
        Object object;
        Closeable closeable;
        Model model2 = model.copy();
        model2.objective = null;
        assert (CmdFlags.minionfile != null);
        try {
            closeable = new BufferedWriter(new FileWriter(CmdFlags.minionfile));
            model2.toMinion((BufferedWriter)closeable, false, arrayList);
            ((BufferedWriter)closeable).close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for Minion output.");
            CmdFlags.exit();
        }
        CmdFlags.println("Created output file for table generation " + CmdFlags.minionfile);
        this.runMinion(CmdFlags.getMinion(), CmdFlags.minionfile, model2, false, arrayList.size());
        closeable = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        try {
            object = ((BufferedReader)closeable).readLine();
            while (object != null) {
                String[] stringArray = ((String)object).split("\\s");
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList3.add(NumberConstant.make(Long.valueOf(stringArray[i])));
                }
                assert (arrayList3.size() == arrayList.size());
                arrayList2.add(CompoundMatrix.make(arrayList3));
                object = ((BufferedReader)closeable).readLine();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            object = new File(CmdFlags.getMinionSolsTempFile());
            ((File)object).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Table(model, CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2));
    }

    public Solution optWarmStart(Model model) throws IOException, InterruptedException {
        Object object;
        Object object2;
        try {
            object2 = new FileOutputStream(CmdFlags.minionfile);
            object = new BufferedWriter(new OutputStreamWriter((OutputStream)object2));
            model.toMinion((BufferedWriter)object, false);
            ((BufferedWriter)object).flush();
            ((FileOutputStream)object2).getFD().sync();
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for Minion output.");
            CmdFlags.exit();
        }
        CmdFlags.println("Created output file for optimisation warm start: " + CmdFlags.minionfile);
        object2 = CmdFlags.getSolverExtraFlags();
        object = new ArrayList();
        ((ArrayList)object).add("-nodelimit");
        ((ArrayList)object).add(String.valueOf(model.global_symbols.category.size() * 10));
        CmdFlags.setSolverExtraFlags((ArrayList<String>)object);
        this.runMinion(CmdFlags.getMinion(), CmdFlags.minionfile, model, false, -1);
        CmdFlags.setSolverExtraFlags((ArrayList<String>)object2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
        Solution solution = this.parseLastSolverSolution(model.global_symbols, bufferedReader);
        return solution;
    }

    private ArrayList<String> runMinion(String string, String string2, Model model, boolean bl, int n) throws IOException, InterruptedException {
        if (!bl) {
            CmdFlags.runningSolver = true;
        }
        try {
            ArrayList<String> arrayList;
            String string3 = CmdFlags.getPreprocess() != null ? CmdFlags.getPreprocess() : "SACBounds_limit";
            if (n == -1) {
                if (bl) {
                    arrayList = new ArrayList<String>(Arrays.asList(string, string2, "-preprocess", string3, "-outputCompressedDomains"));
                    if (CmdFlags.getTimeLimit() != 0L) {
                        arrayList.add("-cpulimit");
                        long l = System.currentTimeMillis() - CmdFlags.startTime;
                        long l2 = CmdFlags.getTimeLimit() - l;
                        int n2 = (int)Math.ceil((double)l2 / 1000.0);
                        arrayList.add(String.valueOf(n2));
                    }
                    if (CmdFlags.amo_detect) {
                        arrayList.add("-X-AMO");
                    }
                } else {
                    arrayList = new ArrayList<String>(Arrays.asList(string, string2, "-printsolsonly", "-preprocess", string3, "-tableout", CmdFlags.getMinionStatsTempFile(), "-solsout", CmdFlags.getMinionSolsTempFile(), "-noprintsols"));
                }
            } else {
                arrayList = new ArrayList<String>(Arrays.asList(string, string2, "-printsolsonly", "-tableout", CmdFlags.getMinionStatsTempFile(), "-solsout", CmdFlags.getMinionSolsTempFile(), "-noprintsols", "-varorder", "staticlimited", String.valueOf(n), "-skipautoaux", "-findallsols"));
            }
            if (CmdFlags.getFindAllSolutions() && !bl && n == -1) {
                if (model.objective != null) {
                    CmdFlags.println("WARNING: Ignoring -all-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindAllSolutions(false);
                } else {
                    arrayList.add("-findallsols");
                }
            }
            if (CmdFlags.getFindNumSolutions() > 1L && !bl && n == -1) {
                if (model.objective != null) {
                    CmdFlags.println("WARNING: Ignoring -num-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindNumSolutions(1L);
                } else {
                    arrayList.add("-sollimit");
                    arrayList.add("" + CmdFlags.getFindNumSolutions());
                }
            }
            if (!bl && n == -1) {
                arrayList.addAll(CmdFlags.getSolverExtraFlags());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList2);
            int n3 = RunCommand.runCommand(true, arrayList, arrayList3, readProcessOutput);
            if (arrayList3.size() != 0 || n3 != 0) {
                // empty if block
            }
            return arrayList2;
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            throw interruptedException;
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            Solution solution = this.solverSolToAST(arrayList, symbolTable);
            return solution;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        Solution solution = null;
        try {
            String string = null;
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) {
                    if (string != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        solution = this.solverSolToAST(arrayList, symbolTable);
                    }
                    break;
                }
                string = string2;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not open or parse Minion solution file. " + iOException);
        }
        return solution;
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        String string;
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(Arrays.asList(arrayList.get(0).split("\\s")));
        categoryentry categoryentry2 = symbolTable.getCategoryFirst();
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            int n = categoryentry2.cat;
            if (n == 3) {
                ASTNode aSTNode = symbolTable.getDomain(string);
                if (aSTNode instanceof MatrixDomain) {
                    assert (false) : "Internal error : matrix domain in symbol table at solver output time";
                } else {
                    assert (aSTNode.isFiniteSet());
                    String string2 = arrayDeque.removeFirst();
                    long l = Long.parseLong(string2.trim());
                    hashMap.put(string, l);
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        if (symbolTable.m != null && symbolTable.m.objective != null) {
            string = arrayDeque.removeFirst();
            long l = Long.parseLong(string.trim());
            hashMap.put(symbolTable.m.objective.getChild(0).toString(), l);
        }
        return hashMap;
    }

    private MinionStats addStatisticsToSolution(Solution solution, double d) {
        MinionStats minionStats;
        try {
            minionStats = new MinionStats(CmdFlags.getMinionStatsTempFile());
            minionStats.putValue("SavileRowTotalTime", String.valueOf(d));
        }
        catch (Exception exception) {
            minionStats = new MinionStats();
            minionStats.putValue("SavileRowTotalTime", String.valueOf(d));
            minionStats.putValue("SolverTimeOut", "1");
        }
        if (solution != null) {
            if (minionStats != null) {
                solution.addComment(minionStats.report("SolverNodes"));
                solution.addComment(minionStats.report("SolverTotalTime"));
                solution.addComment(minionStats.report("SolverTimeOut"));
            }
            solution.addComment("Savile Row TotalTime: " + d);
        }
        return minionStats;
    }
}

