/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import savilerow.ACCSE;
import savilerow.ACCSEActiveSum;
import savilerow.ACCSEActiveSum2;
import savilerow.ASTNode;
import savilerow.AllMinisatSATSolver;
import savilerow.And;
import savilerow.BitVector;
import savilerow.BooleanConstant;
import savilerow.BoolectorSolver;
import savilerow.CSE;
import savilerow.CSEActive;
import savilerow.CSEClassIdentical;
import savilerow.CSETopLevel;
import savilerow.CadicalSATSolver;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.ConstantMatrixStore;
import savilerow.DominanceModelContainer;
import savilerow.ElementGAC;
import savilerow.EmptyMatrix;
import savilerow.FactorEncoding;
import savilerow.FilteredDomainStore;
import savilerow.Find;
import savilerow.FznSolver;
import savilerow.Given;
import savilerow.GlucoseSATSolver;
import savilerow.ICSEProduct;
import savilerow.ICSESum;
import savilerow.Identifier;
import savilerow.InteractiveSMT;
import savilerow.InteractiveSat;
import savilerow.Intersect;
import savilerow.Intpair;
import savilerow.Less;
import savilerow.LessEqual;
import savilerow.Letting;
import savilerow.LingelingSATSolver;
import savilerow.MatrixDeref;
import savilerow.MatrixDomain;
import savilerow.MaxSATObjective;
import savilerow.Minimising;
import savilerow.MinionSolver;
import savilerow.MinisatSATSolver;
import savilerow.Model;
import savilerow.MultiplyMapper;
import savilerow.MznSolver;
import savilerow.NumberConstant;
import savilerow.OpenWBOSATSolver;
import savilerow.Pair;
import savilerow.PairASTNode;
import savilerow.RemoveRedundantVars;
import savilerow.ReplaceASTNode;
import savilerow.SATSolver;
import savilerow.SNS;
import savilerow.SNSIncumbentMapping;
import savilerow.SafeMatrixDeref;
import savilerow.Solution;
import savilerow.Solver;
import savilerow.Stats;
import savilerow.SymmetryBreaker;
import savilerow.Tabulation;
import savilerow.Times;
import savilerow.ToVariable;
import savilerow.Top;
import savilerow.TransformAbsReify;
import savilerow.TransformAlldiffExcept;
import savilerow.TransformAlldiffGCCSum;
import savilerow.TransformAlldiffToSums;
import savilerow.TransformBreakupSum2;
import savilerow.TransformBreakupSum2SMT;
import savilerow.TransformCollectAlldiff;
import savilerow.TransformCollectBool;
import savilerow.TransformCollectGCC;
import savilerow.TransformCollectSATDirect;
import savilerow.TransformCollectSMT;
import savilerow.TransformConstMatrixClass;
import savilerow.TransformCountToSum;
import savilerow.TransformDecomposeAlldiff;
import savilerow.TransformDecomposeLex2;
import savilerow.TransformDecomposeMinMax;
import savilerow.TransformDecomposeNegativeTable;
import savilerow.TransformDecomposeReifLex2;
import savilerow.TransformDeleteFuncVars;
import savilerow.TransformDivToTable;
import savilerow.TransformElementForSAT2;
import savilerow.TransformEncodeSumSpecial;
import savilerow.TransformEqual;
import savilerow.TransformEqualClass;
import savilerow.TransformEqualConst;
import savilerow.TransformEqualConstClass;
import savilerow.TransformExistsVar;
import savilerow.TransformExpandShortTable;
import savilerow.TransformExtractBoolsInSums;
import savilerow.TransformFixSTRef;
import savilerow.TransformForBoundVars;
import savilerow.TransformForallAndToAndForall;
import savilerow.TransformGCAssignClique;
import savilerow.TransformGCCSum;
import savilerow.TransformGCCToSums;
import savilerow.TransformLexAlldiff;
import savilerow.TransformMakeSafe;
import savilerow.TransformMappingToTable;
import savilerow.TransformMatrixDeref;
import savilerow.TransformMatrixDerefClass;
import savilerow.TransformMatrixIndexedMatrix;
import savilerow.TransformMatrixIndicesClass;
import savilerow.TransformMatrixToAtoms;
import savilerow.TransformModToTable;
import savilerow.TransformNormalise;
import savilerow.TransformOccurrence;
import savilerow.TransformOccurrenceToSum;
import savilerow.TransformPBToNil;
import savilerow.TransformPowToTable;
import savilerow.TransformProductToMult;
import savilerow.TransformProductToMultInQSum;
import savilerow.TransformQuantifiedExpression;
import savilerow.TransformReifyAlldiff;
import savilerow.TransformReifyMin;
import savilerow.TransformRemoveSafeTypes;
import savilerow.TransformSATEncoding;
import savilerow.TransformSafeElementOne;
import savilerow.TransformShiftToIDL;
import savilerow.TransformShortTableSquash;
import savilerow.TransformSimplify;
import savilerow.TransformSizeBV;
import savilerow.TransformSumEq;
import savilerow.TransformSumEqToSum;
import savilerow.TransformSumEqualSum;
import savilerow.TransformSumForSAT;
import savilerow.TransformSumLeq;
import savilerow.TransformSumLess;
import savilerow.TransformSumToAMOPB;
import savilerow.TransformSumToShift;
import savilerow.TransformTableReify;
import savilerow.TransformTableToElement;
import savilerow.TransformTableToShortTable;
import savilerow.TransformTimes;
import savilerow.TransformToFlat;
import savilerow.TransformToFlatClass;
import savilerow.TransformToFlatGecode;
import savilerow.TransformToFlatSMT;
import savilerow.TransformTrimElement;
import savilerow.TransformWSumToSum;
import savilerow.TransformXor;
import savilerow.TreeTransformer;
import savilerow.TreeTransformerBottomUp;
import savilerow.TreeTransformerBottomUpNoWrapper;
import savilerow.TreeTransformerTopdown;
import savilerow.WeightedSum;
import savilerow.Where;
import savilerow.YicesSolver;
import savilerow.Z3Solver;
import savilerow.categoryentry;

public class ModelContainer {
    public Model m;
    public ArrayList<ASTNode> parameters;

    public ModelContainer(Model model, ArrayList<ASTNode> arrayList) {
        this.m = model;
        this.parameters = arrayList;
    }

    public void process() {
        this.processPreamble();
        if (CmdFlags.getDominiontrans()) {
            this.classLevelFlattening();
        } else {
            this.instancePreFlattening1();
            if (CmdFlags.getUsePropagate()) {
                this.squashDomains();
            }
            this.instancePreFlattening2(false);
            this.instanceFlattening(false);
            this.postFlattening(false);
        }
    }

    public void dryrun() {
        this.processPreamble();
        if (CmdFlags.getDominiontrans()) {
            this.classLevelFlattening();
        } else {
            this.instancePreFlattening1();
            if (CmdFlags.getUsePropagate()) {
                this.squashDomains();
            }
            this.instancePreFlattening2(false);
            this.instanceFlattening(false);
        }
    }

    public void processPreamble() {
        TreeTransformer treeTransformer;
        Object object;
        Object object2;
        Object object3;
        CmdFlags.setOutputReady(false);
        CmdFlags.setAfterAggregate(false);
        ArrayDeque<ASTNode> arrayDeque = this.m.global_symbols.lettings_givens;
        for (int i = 0; i < this.parameters.size(); ++i) {
            object3 = this.parameters.get(i);
            if (!((ASTNode)object3).typecheck(this.m.global_symbols)) {
                CmdFlags.errorExit("Failed type checking in parameter file:" + object3);
            }
            object2 = new TransformMakeSafe(this.m);
            object3 = ((TreeTransformerBottomUp)object2).transform((ASTNode)object3);
            object = ((TreeTransformerBottomUp)object2).getContextCts();
            if (object != null) {
                arrayDeque.addLast(new Where((ASTNode)object));
            }
            treeTransformer = new TransformSimplify();
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
            object3 = transformQuantifiedExpression.transform((ASTNode)object3);
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            object3 = this.fixIndexDomainsLetting((ASTNode)object3);
            this.parameters.set(i, (ASTNode)object3);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(((ASTNode)object3).getChild(0), ((ASTNode)object3).getChild(1));
            for (int j = i + 1; j < this.parameters.size(); ++j) {
                this.parameters.set(j, replaceASTNode.transform(this.parameters.get(j)));
            }
        }
        while (arrayDeque.size() != 0) {
            ASTNode aSTNode = arrayDeque.removeFirst();
            if (!aSTNode.typecheck(this.m.global_symbols)) {
                CmdFlags.errorExit("Failed type checking:" + aSTNode);
            }
            object3 = new TransformMakeSafe(this.m);
            aSTNode = ((TreeTransformerBottomUp)object3).transform(aSTNode);
            object2 = ((TreeTransformerBottomUp)object3).getContextCts();
            if (object2 != null) {
                arrayDeque.addLast(new Where((ASTNode)object2));
            }
            object = new TransformSimplify();
            aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode);
            if (!CmdFlags.getDominiontrans()) {
                treeTransformer = new TransformQuantifiedExpression(this.m);
                aSTNode = ((TreeTransformerTopdown)treeTransformer).transform(aSTNode);
            }
            if ((aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode)) instanceof Letting) {
                aSTNode = this.fixIndexDomainsLetting(aSTNode);
                this.processLetting(aSTNode);
                continue;
            }
            if (aSTNode instanceof Find) {
                this.processFind(aSTNode);
                continue;
            }
            if (aSTNode instanceof Where) {
                this.processWhere(aSTNode);
                continue;
            }
            assert (aSTNode instanceof Given);
            this.processGiven(aSTNode);
        }
        if (this.parameters.size() > 0) {
            CmdFlags.warning("Number of givens in model file does not match number of lettings in parameter file.");
        }
        this.parameters = null;
        if (!this.m.typecheck()) {
            CmdFlags.errorExit("Failed type checking after substituting in lettings.");
        }
        if (CmdFlags.getVerbose()) {
            CmdFlags.println("Model before undef handling:");
            CmdFlags.println(this.m);
        }
        this.removeMatrixIndexedMatrices();
        if (!this.m.constraints.typecheck2(this.m.global_symbols)) {
            CmdFlags.errorExit("Failed type checking.");
        }
        TransformMakeSafe transformMakeSafe = new TransformMakeSafe(this.m);
        this.m.transform(transformMakeSafe);
        this.m.simplify();
    }

    public void instancePreFlattening1() {
        Object object;
        Object object2;
        if (!CmdFlags.getMinionSNStrans() && this.m.sns != null) {
            object2 = ((SNS)this.m.sns).deactivateEarly();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object2));
            this.m.simplify();
        }
        object2 = new TransformExistsVar(this.m);
        this.m.transform((TreeTransformer)object2);
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        this.m.transform(transformQuantifiedExpression);
        this.destroyMatrices();
        if (this.m.sns != null) {
            object = ((SNSIncumbentMapping)this.m.sns.getChild(0)).makeIncumbentDisable();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object));
            this.m.simplify();
        }
        if (CmdFlags.getGraphColSymBreak()) {
            object = new TransformGCAssignClique(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseVarSymBreaking()) {
            this.writeModelAsJSON(this.m);
        }
    }

    public void instancePreFlattening2(boolean bl) {
        TreeTransformer treeTransformer;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TreeTransformer treeTransformer2;
        TreeTransformer treeTransformer3;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper2;
        Object object;
        TreeTransformer treeTransformer4;
        TransformMatrixDeref transformMatrixDeref = new TransformMatrixDeref(this.m, bl);
        this.m.transform(transformMatrixDeref);
        if (this.m.objective != null) {
            this.processObjective(bl);
        }
        if (CmdFlags.amo_detect) {
            treeTransformer4 = new TransformExtractBoolsInSums(this.m);
            this.m.transform(treeTransformer4);
        }
        treeTransformer4 = new TransformTrimElement(this.m);
        this.m.transform(treeTransformer4);
        TransformNormalise transformNormalise = new TransformNormalise(this.m);
        this.m.transform(transformNormalise);
        if ((!CmdFlags.getMinionSNStrans() || bl) && this.m.sns != null) {
            object = ((SNS)this.m.sns).deactivate();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object));
            this.m.simplify();
            this.m.sns = null;
        }
        if (CmdFlags.getRemoveRedundantVars()) {
            object = new RemoveRedundantVars();
            ((RemoveRedundantVars)object).transform(this.m);
        }
        if (CmdFlags.getUseAggregate()) {
            object = new TransformCollectAlldiff(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper2 = new TransformCollectGCC(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper2);
        }
        CmdFlags.setAfterAggregate(true);
        if (CmdFlags.getUseDeleteVars() && CmdFlags.getUseAggregate()) {
            this.m.simplify();
        }
        object = new TransformAlldiffExcept(this.m);
        this.m.transform((TreeTransformer)object);
        treeTransformerBottomUpNoWrapper2 = new TransformOccurrence();
        this.m.transform(treeTransformerBottomUpNoWrapper2);
        if (CmdFlags.getUseBoundVars() && (CmdFlags.getMiniontrans() || bl)) {
            treeTransformer3 = new TransformForBoundVars(this.m);
            this.m.transform(treeTransformer3);
        }
        treeTransformer3 = new TransformGCCSum(this.m);
        this.m.transform(treeTransformer3);
        this.m.transform(transformNormalise);
        Tabulation tabulation = new Tabulation(this.m);
        tabulation.process(bl);
        TransformLexAlldiff transformLexAlldiff = new TransformLexAlldiff(this.m);
        this.m.transform(transformLexAlldiff);
        if (!CmdFlags.getSattrans() || bl) {
            treeTransformer2 = new TransformSafeElementOne(this.m);
            this.m.transform(treeTransformer2);
        }
        if (CmdFlags.getFlatzinctrans() && !bl) {
            treeTransformer2 = new TransformReifyAlldiff(this.m);
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformDecomposeNegativeTable(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
            treeTransformer = new TransformDecomposeReifLex2(this.m);
            this.m.transform(treeTransformer);
        }
        if (CmdFlags.getChuffedtrans() && !bl) {
            treeTransformer2 = new TransformOccurrenceToSum();
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getFlatzinctrans() && !CmdFlags.getGecodetrans() && !CmdFlags.getChuffedtrans()) {
            treeTransformer2 = new TransformOccurrenceToSum();
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
            this.m.transform(treeTransformerBottomUpNoWrapper);
            treeTransformer = new TransformDecomposeAlldiff(this.m);
            this.m.transform(treeTransformer);
            TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
            this.m.transform(transformDecomposeLex2);
        }
        if (CmdFlags.getSattrans() && !bl) {
            if (CmdFlags.getSatDelFunc()) {
                treeTransformer2 = new TransformDeleteFuncVars(this.m);
                this.m.transform(treeTransformer2);
            }
            treeTransformer2 = new TransformSumToShift(this.m);
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformer2 = new TransformNormalise(this.m);
        this.m.transform(treeTransformer2);
    }

    public void processObjective(boolean bl) {
        ASTNode aSTNode = this.m.objective.getChild(0);
        if (!CmdFlags.getMiniontrans() && !bl && aSTNode.getDimension() > 0) {
            ASTNode aSTNode2 = aSTNode.getChild(1);
            for (int i = 2; i < aSTNode.numChildren(); ++i) {
                Intpair intpair = aSTNode.getChild(i).getBounds();
                NumberConstant numberConstant = NumberConstant.make(intpair.upper - intpair.lower + 1L);
                aSTNode2 = new WeightedSum((ASTNode)new Times(aSTNode2, numberConstant), aSTNode.getChild(i));
            }
            aSTNode = aSTNode2;
            this.m.objective.setChild(0, aSTNode);
        }
        if (aSTNode.getDimension() > 0) {
            assert (aSTNode instanceof CompoundMatrix);
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode.getChild(i);
                this.processObjective1(bl, aSTNode3);
            }
        } else {
            this.processObjective1(bl, aSTNode);
        }
    }

    public void processObjective1(boolean bl, ASTNode aSTNode) {
        if (!aSTNode.isConstant() && !(aSTNode instanceof Identifier)) {
            ASTNode aSTNode2;
            boolean bl2 = true;
            if (aSTNode instanceof MatrixDeref || aSTNode instanceof SafeMatrixDeref) {
                bl2 = false;
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (aSTNode.getChild(i).isConstant()) continue;
                    bl2 = true;
                }
            }
            if (bl2 && !bl && CmdFlags.getMaxsattrans() && this.m.objective.getChild(0) instanceof WeightedSum) {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                aSTNode2 = this.m.objective.getChild(0);
                for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                    arrayList.add(new MultiplyMapper(aSTNode2.getChild(i), NumberConstant.make(((WeightedSum)aSTNode2).getWeight(i))));
                }
                aSTNode.getParent().setChild(aSTNode.getChildNo(), new MaxSATObjective(arrayList));
                bl2 = false;
            }
            if (bl2) {
                ASTNode aSTNode3 = this.m.global_symbols.newAuxHelper(aSTNode);
                aSTNode2 = CmdFlags.getAuxNonFunctional() && this.m.objective.getChild(0) instanceof WeightedSum && CmdFlags.getSattrans() ? (this.m.objective instanceof Minimising ? new LessEqual(aSTNode, aSTNode3) : new LessEqual(aSTNode3, aSTNode)) : new ToVariable(aSTNode, aSTNode3);
                this.m.global_symbols.auxVarRepresentsConstraint(aSTNode3.toString(), aSTNode.toString());
                aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
                this.m.constraints.getChild(0).setParent(null);
                this.m.constraints.setChild(0, new And(aSTNode2, this.m.constraints.getChild(0)));
            }
        }
    }

    public void squashDomains() {
        Object object;
        ASTNode aSTNode;
        Object object2;
        String string;
        ASTNode aSTNode2;
        Model model = this.m.copy();
        Model model2 = null;
        if (CmdFlags.getVerbose()) {
            model2 = this.m.copy();
        }
        if (CmdFlags.amo_detect && CmdFlags.amo_detect_noamoenc) {
            TransformPBToNil transformPBToNil = new TransformPBToNil(this.m);
            this.m.transform(transformPBToNil);
        }
        boolean bl = CmdFlags.getOutputReady();
        boolean bl2 = CmdFlags.getAfterAggregate();
        this.instancePreFlattening2(true);
        this.instanceFlattening(true);
        ArrayList<ASTNode> arrayList = this.postFlattening(true);
        FilteredDomainStore filteredDomainStore = this.m.filt;
        ASTNode aSTNode3 = this.m.incumbentSolution;
        this.m = model;
        this.m.filt = filteredDomainStore;
        this.m.incumbentSolution = aSTNode3;
        CmdFlags.setOutputReady(bl);
        CmdFlags.setAfterAggregate(bl2);
        for (int i = 0; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i).getChild(0);
            ASTNode aSTNode4 = arrayList.get(i).getChild(1);
            assert (aSTNode2 instanceof Identifier);
            assert (aSTNode4.isFiniteSet());
            string = aSTNode2.toString();
            if (this.m.global_symbols.getCategory(string) == 3) {
                object2 = this.m.global_symbols.getDomain(string);
                aSTNode = new Intersect((ASTNode)object2, aSTNode4);
                if (((ASTNode)object2).isBooleanSet()) {
                    object = new TransformSimplify();
                    aSTNode = Intpair.makeDomain(((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain(string, aSTNode);
                continue;
            }
            this.m.filt.auxVarFilteredDomain(string, aSTNode4);
        }
        if (this.m.sns != null && CmdFlags.getMinionSNStrans()) {
            ASTNode aSTNode5 = this.m.sns.getChild(0).getChild(0);
            aSTNode2 = this.m.sns.getChild(0).getChild(1);
            assert (aSTNode5 instanceof CompoundMatrix);
            assert (aSTNode2 instanceof CompoundMatrix);
            for (int i = 1; i < aSTNode5.numChildren(); ++i) {
                string = aSTNode5.getChild(i).toString();
                object2 = aSTNode2.getChild(i).toString();
                aSTNode = this.m.global_symbols.getDomain(string);
                object = new Intersect(aSTNode, this.m.global_symbols.getDomain((String)object2));
                if (this.m.global_symbols.getDomain((String)object2).isBooleanSet()) {
                    TransformSimplify transformSimplify = new TransformSimplify();
                    object = Intpair.makeDomain(transformSimplify.transform((ASTNode)object).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain((String)object2, (ASTNode)object);
            }
        }
        this.m.simplify();
        if (CmdFlags.getVerbose() && !this.m.equals(model2)) {
            System.out.println("Domain filtering changed model:\n" + this.m.toString());
        }
    }

    public void instanceFlattening(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TreeTransformer treeTransformer;
        if ((CmdFlags.getFlatzinctrans() || CmdFlags.getMinizinctrans()) && !bl) {
            treeTransformer = new TransformRemoveSafeTypes(this.m);
            this.m.transform(treeTransformer);
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Rules: Normalisation and CSE");
        }
        treeTransformer = new TransformAlldiffGCCSum(this.m);
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            this.m.transform(treeTransformer);
        }
        TransformNormalise transformNormalise = new TransformNormalise(this.m);
        if (CmdFlags.getUseACCSE()) {
            this.m.transform(transformNormalise);
            object4 = new ACCSE();
            ((ACCSE)object4).flattenCSEs(this.m, "*");
            CmdFlags.stats.put("AC-CSE-Times_number", ((ACCSE)object4).numcse);
            CmdFlags.stats.put("AC-CSE-Times_eliminated_expressions", ((ACCSE)object4).countcse);
            CmdFlags.stats.put("AC-CSE-Times_total_size", ((ACCSE)object4).totallength);
            this.m.simplify();
            ((ACCSE)object4).flattenCSEs(this.m, "xor");
            CmdFlags.stats.put("AC-CSE-Xor_number", ((ACCSE)object4).numcse);
            CmdFlags.stats.put("AC-CSE-Xor_eliminated_expressions", ((ACCSE)object4).countcse);
            CmdFlags.stats.put("AC-CSE-Xor_total_size", ((ACCSE)object4).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSEAlt()) {
            this.m.transform(transformNormalise);
            object4 = new ICSEProduct();
            ((ICSEProduct)object4).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object4 = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object4);
        TransformXor transformXor = new TransformXor(this.m);
        this.m.transform(transformXor);
        if (CmdFlags.getUseCSE()) {
            this.m.transform(transformNormalise);
            object3 = new CSETopLevel();
            ((CSETopLevel)object3).flattenCSEs(this.m);
            CmdFlags.stats.put("CSETopLevel_number", ((CSETopLevel)object3).numcse);
            CmdFlags.stats.put("CSETopLevel_eliminated_expressions", ((CSETopLevel)object3).countcse);
            CmdFlags.stats.put("CSETopLevel_total_size", ((CSETopLevel)object3).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE() || this instanceof DominanceModelContainer && CmdFlags.compressDominance) {
            object3 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveACCSE()) {
                object2 = new ACCSEActiveSum();
                ((ACCSEActiveSum)object2).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum)object2).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum)object2).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum)object2).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum)object2).active_ac_cs_found ? 1 : 0);
            } else if (CmdFlags.getUseActiveACCSE2()) {
                object2 = new ACCSEActiveSum2();
                ((ACCSEActiveSum2)object2).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum2)object2).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum2)object2).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum2)object2).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum2)object2).active_ac_cs_found ? 1 : 0);
            } else {
                ((ACCSE)object3).flattenCSEs(this.m, "+");
                CmdFlags.stats.put("AC-CSE-Sum_number", ((ACCSE)object3).numcse);
                CmdFlags.stats.put("AC-CSE-Sum_eliminated_expressions", ((ACCSE)object3).countcse);
                CmdFlags.stats.put("AC-CSE-Sum_total_size", ((ACCSE)object3).totallength);
            }
        }
        if (CmdFlags.getUseACCSEAlt()) {
            object3 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            object2 = new ICSESum();
            ((ICSESum)object2).flattenCSEs(this.m);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            ((TransformAlldiffGCCSum)treeTransformer).removeImpliedConstraints();
        }
        if (CmdFlags.getSattrans() && !bl) {
            this.decomposeSatEncoding();
        }
        if (CmdFlags.getUseCSE() || CmdFlags.getUseActiveCSE()) {
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveCSE()) {
                object3 = new CSEActive();
                ((CSEActive)object3).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_active_number", ((CSEActive)object3).numcse);
                CmdFlags.stats.put("CSE_active_eliminated_expressions", ((CSEActive)object3).countcse);
                CmdFlags.stats.put("CSE_active_total_size", ((CSEActive)object3).totallength);
            } else {
                object3 = new CSE();
                ((CSE)object3).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_number", ((CSE)object3).numcse);
                CmdFlags.stats.put("CSE_eliminated_expressions", ((CSE)object3).countcse);
                CmdFlags.stats.put("CSE_total_size", ((CSE)object3).totallength);
            }
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Model may have changed by CSE. Model after rule application:\n" + this.m.toString());
        }
        object3 = new TransformEqual(this.m, bl);
        this.m.transform((TreeTransformer)object3);
        object2 = new TransformEqualConst(bl);
        this.m.transform((TreeTransformer)object2);
        if (CmdFlags.table_squash == 1 || CmdFlags.table_squash == 3) {
            object = new TransformShortTableSquash(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.table_squash == 2 || CmdFlags.table_squash == 3) {
            object = new TransformTableToShortTable(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getSMTtrans() && !bl) {
            object = new TransformToFlatSMT(this.m, bl);
            this.m.transform((TreeTransformer)object);
        } else {
            object = new TransformToFlat(this.m, bl);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.element_gac) {
            object = new ElementGAC();
            ((ElementGAC)object).transform(this.m);
        }
        if (CmdFlags.factor_encoding) {
            object = new FactorEncoding();
            ((FactorEncoding)object).factorEncoding(this.m);
            this.m.simplify();
        }
        if (CmdFlags.getFlatzinctrans() && !bl) {
            object = new TransformToFlatGecode(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getExpandShortTab() || (CmdFlags.getFlatzinctrans() || CmdFlags.getMinizinctrans()) && !bl) {
            object = new TransformExpandShortTable(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getChuffedtrans() && !bl) {
            object = new TransformModToTable(this.m);
            this.m.transform((TreeTransformer)object);
            TransformDivToTable transformDivToTable = new TransformDivToTable(this.m);
            this.m.transform(transformDivToTable);
        }
        if ((CmdFlags.getFlatzinctrans() || CmdFlags.getMinizinctrans()) && !bl) {
            object = new TransformPowToTable(this.m);
            this.m.transform((TreeTransformer)object);
        }
        object = new TransformMappingToTable(this.m);
        this.m.transform((TreeTransformer)object);
    }

    public ArrayList<ASTNode> postFlattening(boolean bl) {
        block24: {
            Object object;
            Object object2;
            if (CmdFlags.getFlatzinctrans() && !bl) {
                this.fznFlattening();
                return null;
            }
            if (CmdFlags.getMinizinctrans() && !bl) {
                this.minizincOutput();
                return null;
            }
            if (CmdFlags.getSattrans() && !CmdFlags.getSMTtrans() && !bl) {
                return this.satPrepOutput();
            }
            if (CmdFlags.getSMTtrans() && !bl) {
                return this.smtPrepOutput();
            }
            TransformSumEq transformSumEq = new TransformSumEq(bl);
            this.m.transform(transformSumEq);
            if (CmdFlags.getMakeTables() && !bl) {
                this.makeTables();
            }
            this.m.simplify();
            if (CmdFlags.getOptWarmStart() && this.m.objective != null && bl) {
                object2 = new MinionSolver();
                try {
                    object = ((MinionSolver)object2).optWarmStart(this.m);
                    if (object != null) {
                        this.m.incumbentSolution = object;
                        long l = ((Solution)object).optval;
                        ASTNode aSTNode = this.m.objective.getChild(0);
                        Less less = this.m.objective instanceof Minimising ? new Less(aSTNode, NumberConstant.make(l)) : new Less((ASTNode)NumberConstant.make(l), aSTNode);
                        System.out.println("Adding warm start constraint: " + less);
                        this.m.constraints.getChild(0).setParent(null);
                        this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), less));
                        this.m.simplify();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (CmdFlags.minionfile != null);
            object2 = CmdFlags.minionfile;
            if (!(this instanceof DominanceModelContainer)) {
                try {
                    object = new FileOutputStream((String)object2);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
                    this.m.toMinion(bufferedWriter, bl);
                    bufferedWriter.flush();
                    ((FileOutputStream)object).getFD().sync();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not open file for Minion output.");
                }
                CmdFlags.println("Created output file " + (bl ? "for domain filtering " : "") + (String)object2);
            }
            if (bl) {
                object = new MinionSolver();
                try {
                    return ((MinionSolver)object).reduceDomains(CmdFlags.getMinion(), (String)object2, this.m);
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not run Minion: " + iOException);
                    break block24;
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.errorExit("Could not run Minion: " + interruptedException);
                    break block24;
                }
            }
            if (CmdFlags.getRunSolver()) {
                object = new MinionSolver();
                try {
                    if (!(this instanceof DominanceModelContainer)) {
                        if (CmdFlags.dominanceRelation) {
                            DominanceModelContainer dominanceModelContainer = new DominanceModelContainer(this.m, this.parameters, (Solver)object);
                            dominanceModelContainer.process();
                        } else {
                            ((MinionSolver)object).findSolutions(CmdFlags.getMinion(), (String)object2, this.m);
                        }
                    }
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not run Minion: " + iOException);
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.errorExit("Could not run Minion: " + interruptedException);
                }
            }
        }
        return null;
    }

    public ArrayList<ASTNode> satPrepOutput() {
        this.decomposeSatEncodingFlat();
        TransformToFlatGecode transformToFlatGecode = new TransformToFlatGecode(this.m);
        this.m.transform(transformToFlatGecode);
        this.m.simplify();
        if (CmdFlags.getTestSolutions()) {
            CmdFlags.checkSolModel = this.m.copy();
        }
        TransformCollectSATDirect transformCollectSATDirect = new TransformCollectSATDirect(this.m);
        transformCollectSATDirect.transform(this.m.constraints);
        if (this.m.objective != null) {
            transformCollectSATDirect.transform(this.m.objective);
        }
        CmdFlags.printlnIfVerbose("About to do m.setupSAT");
        boolean bl = this.m.setupSAT(transformCollectSATDirect.getVarsInConstraints());
        if (!bl) {
            this.createInfoFiles("SAT");
        }
        CmdFlags.printlnIfVerbose("Done m.setupSAT");
        TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
        this.m.constraints = transformSATEncoding.transform(this.m.constraints);
        if (!(this instanceof DominanceModelContainer)) {
            if (CmdFlags.dominanceRelation) {
                if (!CmdFlags.getRunSolver()) {
                    CmdFlags.errorExit("Solution Dominance mode only works on run-solver mode");
                }
                SATSolver sATSolver = this.createSolver();
                DominanceModelContainer dominanceModelContainer = new DominanceModelContainer(this.m, this.parameters, sATSolver);
                dominanceModelContainer.process();
            } else {
                this.satOutput();
            }
        }
        return null;
    }

    public ArrayList<ASTNode> smtPrepOutput() {
        TreeTransformer treeTransformer;
        this.decomposeSatEncodingFlat();
        if (CmdFlags.getUseFlat() || CmdFlags.getUseIDL() || CmdFlags.getUseUF()) {
            treeTransformer = new TransformToFlatGecode(this.m);
            this.m.transform(treeTransformer);
            this.m.simplify();
        }
        if (CmdFlags.getTestSolutions()) {
            CmdFlags.checkSolModel = this.m.copy();
        }
        this.smtTransformations();
        this.smtConfig();
        treeTransformer = new TransformSATEncoding(this.m);
        this.m.constraints = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform(this.m.constraints);
        if (!(this instanceof DominanceModelContainer)) {
            if (CmdFlags.dominanceRelation) {
                if (!CmdFlags.getRunSolver()) {
                    CmdFlags.errorExit("Solution Dominance mode only works on run-solver mode");
                }
                SATSolver sATSolver = this.createSolver();
                DominanceModelContainer dominanceModelContainer = new DominanceModelContainer(this.m, this.parameters, sATSolver);
                dominanceModelContainer.process();
            } else {
                this.smtOutput();
            }
        }
        return null;
    }

    public void smtTransformations() {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        if (CmdFlags.getUseIDL()) {
            treeTransformerBottomUpNoWrapper = new TransformShiftToIDL(this.m);
            treeTransformerBottomUpNoWrapper.transform(this.m.constraints);
        }
        treeTransformerBottomUpNoWrapper = new TransformCollectSMT(this.m);
        treeTransformerBottomUpNoWrapper.transform(this.m.constraints);
        if (CmdFlags.getUseBV()) {
            TransformSizeBV transformSizeBV = new TransformSizeBV(this.m);
            CmdFlags.setBvTraversal(true);
            transformSizeBV.transform(this.m.constraints);
            CmdFlags.setBvTraversal(false);
            BitVector.determineBits();
        }
    }

    public void smtConfig() {
        TransformCollectSATDirect transformCollectSATDirect = new TransformCollectSATDirect(this.m);
        transformCollectSATDirect.transform(this.m.constraints);
        CmdFlags.printlnIfVerbose("About to do m.setupSMT");
        boolean bl = this.m.setupSMT(transformCollectSATDirect.getVarsInConstraints());
        if (!bl) {
            this.createInfoFiles("SMT");
        }
        CmdFlags.printlnIfVerbose("Done m.setupSMT");
    }

    private void makeTables() {
        MinionSolver minionSolver = new MinionSolver();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<Identifier> arrayList2 = new ArrayList<Identifier>();
        categoryentry categoryentry2 = this.m.global_symbols.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                arrayList2.add(new Identifier(this.m, categoryentry2.name));
            }
            categoryentry2 = categoryentry2.next;
        }
        for (int i = 0; i < CmdFlags.make_tables_scope.size(); ++i) {
            arrayList.add((ASTNode)arrayList2.get(CmdFlags.make_tables_scope.get(i)));
        }
        ASTNode aSTNode = null;
        try {
            aSTNode = minionSolver.makeTable(this.m, arrayList);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
        this.m.constraints.getChild(0).setParent(null);
        this.m.constraints = new Top(new And(this.m.constraints.getChild(0), aSTNode));
        this.m.simplify();
    }

    public void makeTableScopes() {
        this.processPreamble();
        this.instancePreFlattening1();
        if (CmdFlags.getUsePropagate()) {
            this.squashDomains();
        }
        CmdFlags.setAfterAggregate(true);
        this.m.simplify();
        CmdFlags.setAfterAggregate(false);
        ArrayList<String> arrayList = this.m.global_symbols.getVarNamesList();
        int n = CmdFlags.make_tab_scope;
        System.out.println(arrayList);
        System.out.println(arrayList.size());
        assert (!CmdFlags.getMakeTables());
        if (n > arrayList.size()) {
            return;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n);
        ArrayList<String> arrayList3 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(i);
            arrayList3.add(arrayList.get(i));
        }
        CmdFlags.make_tables = true;
        String string = CmdFlags.paramfile != null ? CmdFlags.paramfile + "-" : CmdFlags.eprimefile + "-";
        Model model = this.m.copy();
        while (true) {
            System.out.println(arrayList2);
            CmdFlags.make_tables_scope = arrayList2;
            CmdFlags.infofile = string + String.join((CharSequence)"-", arrayList3) + ".info";
            this.instancePreFlattening2(false);
            this.instanceFlattening(false);
            this.postFlattening(false);
            if (!this.incrementArrayList(arrayList2, arrayList2.size() - 1, arrayList.size() - 1)) break;
            for (int i = 0; i < n; ++i) {
                arrayList3.set(i, arrayList.get(arrayList2.get(i)));
            }
            this.m = model.copy();
        }
    }

    private boolean incrementArrayList(ArrayList<Integer> arrayList, int n, int n2) {
        if (n < 0) {
            return false;
        }
        arrayList.set(n, arrayList.get(n) + 1);
        while (arrayList.get(n) > n2) {
            if (!this.incrementArrayList(arrayList, n - 1, n2)) {
                return false;
            }
            arrayList.set(n, arrayList.get(n - 1) + 1);
        }
        return true;
    }

    private void destroyMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                TransformMatrixToAtoms transformMatrixToAtoms = new TransformMatrixToAtoms(entry.getKey(), this.m);
                this.m.transform(transformMatrixToAtoms);
                bl = true;
                continue block0;
            }
        }
    }

    private void removeMatrixIndexedMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                boolean bl2 = false;
                for (int i = 3; i < entry.getValue().numChildren(); ++i) {
                    if (!(entry.getValue().getChild(i) instanceof MatrixDomain)) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                TransformMatrixIndexedMatrix transformMatrixIndexedMatrix = new TransformMatrixIndexedMatrix(entry.getKey(), this.m);
                this.m.transform(transformMatrixIndexedMatrix);
                bl = true;
                continue block0;
            }
        }
    }

    private void classLevelFlattening() {
        Map.Entry<String, ASTNode> entry3;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        Object object;
        Object object2;
        Object object3;
        Map.Entry<String, ASTNode> entry22;
        System.out.println(this.m.toString());
        CmdFlags.setAfterAggregate(true);
        HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry22 : hashMap.entrySet()) {
            if (!(entry22.getValue() instanceof MatrixDomain)) continue;
            TransformMatrixIndicesClass transformMatrixIndicesClass = new TransformMatrixIndicesClass(0, this.m, (String)entry22.getKey());
            this.m.transform(transformMatrixIndicesClass);
            System.out.println(this.m.toString());
        }
        if (this.m.objective != null && !((ASTNode)((Object)(entry22 = this.m.objective.getChild(0)))).isConstant() && !(entry22 instanceof Identifier)) {
            boolean bl = true;
            if (entry22 instanceof MatrixDeref || entry22 instanceof SafeMatrixDeref) {
                bl = false;
                for (int i = 1; i < ((ASTNode)((Object)entry22)).numChildren(); ++i) {
                    if (((ASTNode)((Object)entry22)).getChild(i).getCategory() != 3) continue;
                    bl = true;
                }
            }
            if (bl) {
                PairASTNode pairASTNode = ((ASTNode)((Object)entry22)).getBoundsAST();
                object3 = this.m.global_symbols.newAuxiliaryVariable(pairASTNode.e1, pairASTNode.e2);
                object2 = new ToVariable((ASTNode)((Object)entry22), (ASTNode)object3);
                this.m.global_symbols.auxVarRepresentsConstraint(((ASTNode)object3).toString(), ((ASTNode)((Object)entry22)).toString());
                this.m.objective.setChild(0, (ASTNode)object3);
                this.m.constraints.getChild(0).setParent(null);
                this.m.constraints.setChild(0, new And((ASTNode)object2, this.m.constraints.getChild(0)));
            }
        }
        entry22 = new TransformForallAndToAndForall();
        this.m.transform((TreeTransformer)((Object)entry22));
        TransformMatrixDerefClass transformMatrixDerefClass = new TransformMatrixDerefClass(this.m);
        this.m.transform(transformMatrixDerefClass);
        TransformOccurrence transformOccurrence = new TransformOccurrence();
        this.m.transform(transformOccurrence);
        object3 = new TransformSumEqualSum(this.m);
        this.m.transform((TreeTransformer)object3);
        object2 = new TransformSumLess();
        this.m.transform((TreeTransformer)object2);
        TransformSumLeq transformSumLeq = new TransformSumLeq();
        this.m.transform(transformSumLeq);
        if (CmdFlags.getUseMappers()) {
            object = new TransformSumToShift(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getUseMinionMappers()) {
            object = new TransformProductToMultInQSum(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (!CmdFlags.getUseMappers() && !CmdFlags.getUseMinionMappers()) {
            object = new TransformWSumToSum(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseCSE()) {
            object = new CSEClassIdentical();
            ((CSEClassIdentical)object).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object);
        treeTransformerBottomUpNoWrapper = new TransformEqualClass(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformEqualConstClass transformEqualConstClass = new TransformEqualConstClass();
        this.m.transform(transformEqualConstClass);
        TransformToFlatClass transformToFlatClass = new TransformToFlatClass(this.m);
        this.m.transform(transformToFlatClass);
        TransformConstMatrixClass transformConstMatrixClass = new TransformConstMatrixClass(this.m);
        this.m.transform(transformConstMatrixClass);
        System.out.println("**** Completed class-level flattening ****");
        System.out.println(this.m.toString());
        hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry3 : hashMap.entrySet()) {
            if (!(entry3.getValue() instanceof MatrixDomain)) continue;
            boolean bl = false;
            ArrayList<ASTNode> arrayList = ((MatrixDomain)entry3.getValue()).getMDIndexDomains();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get((int)i).getBoundsAST().e1.equals(NumberConstant.make(0L))) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            CmdFlags.println("About to normalise indices of matrix: " + entry3.getKey());
            TransformMatrixIndicesClass transformMatrixIndicesClass = new TransformMatrixIndicesClass(0, this.m, (String)entry3.getKey());
            this.m.transform(transformMatrixIndicesClass);
            System.out.println(this.m.toString());
        }
        this.m.simplify();
        System.out.println("************************");
        System.out.println("**** After Simplify ****");
        System.out.println("************************");
        System.out.println(this.m.toString());
        System.out.println("************************");
        System.out.println("**** Dominion output ***");
        System.out.println("************************");
        entry3 = new StringBuilder();
        this.m.toDominion((StringBuilder)((Object)entry3));
        System.out.println(((StringBuilder)((Object)entry3)).toString());
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.dominionfile));
            bufferedWriter.append((CharSequence)((Object)entry3));
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for Dominion output.");
        }
    }

    private void fznFlattening() {
        Object object;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TransformSumEqToSum transformSumEqToSum = new TransformSumEqToSum();
        this.m.transform(transformSumEqToSum);
        TransformReifyMin transformReifyMin = new TransformReifyMin(this.m);
        this.m.transform(transformReifyMin);
        TransformAbsReify transformAbsReify = new TransformAbsReify(this.m);
        this.m.transform(transformAbsReify);
        if (CmdFlags.getFlatzinctrans() && !CmdFlags.getGecodetrans()) {
            treeTransformerBottomUpNoWrapper = new TransformTableReify(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getFlatzinctrans() && !CmdFlags.getGecodetrans() && !CmdFlags.getChuffedtrans()) {
            treeTransformerBottomUpNoWrapper = new TransformTableToElement(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        this.m.simplify();
        treeTransformerBottomUpNoWrapper = new TransformCollectBool(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        try {
            object = new FileOutputStream(CmdFlags.fznfile);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
            this.m.toFlatzinc(bufferedWriter);
            bufferedWriter.flush();
            ((FileOutputStream)object).getFD().sync();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for flatzinc output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.fznfile);
        if (CmdFlags.getRunSolver()) {
            object = new FznSolver();
            try {
                ((FznSolver)object).findSolutions(CmdFlags.getFznSolver(), CmdFlags.fznfile, this.m);
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not run flatzinc solver: " + iOException);
            }
            catch (InterruptedException interruptedException) {
                CmdFlags.errorExit("Could not run flatzinc solver: " + interruptedException);
            }
        }
    }

    private void minizincOutput() {
        Object object;
        TransformCollectBool transformCollectBool = new TransformCollectBool(this.m);
        this.m.transform(transformCollectBool);
        StringBuilder stringBuilder = new StringBuilder();
        this.m.toMinizinc(stringBuilder);
        try {
            object = new BufferedWriter(new FileWriter(CmdFlags.minizincfile));
            ((Writer)object).append(stringBuilder);
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for minizinc output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.minizincfile);
        if (CmdFlags.getRunSolver()) {
            object = new MznSolver();
            try {
                ((MznSolver)object).findSolutions("minizinc", CmdFlags.minizincfile, this.m);
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not run minizinc solver: " + iOException);
            }
            catch (InterruptedException interruptedException) {
                CmdFlags.errorExit("Could not run minizinc solver: " + interruptedException);
            }
        }
    }

    private void decomposeSatEncoding() {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        if (CmdFlags.getSMTtrans()) {
            if (CmdFlags.SMTDecompAlldiff()) {
                if (CmdFlags.SMTPairwiseAlldiff()) {
                    treeTransformerBottomUpNoWrapper = new TransformDecomposeAlldiff(this.m);
                    this.m.transform(treeTransformerBottomUpNoWrapper);
                } else {
                    treeTransformerBottomUpNoWrapper = new TransformAlldiffToSums(this.m);
                    this.m.transform(treeTransformerBottomUpNoWrapper);
                }
            }
        } else {
            treeTransformerBottomUpNoWrapper = new TransformAlldiffToSums(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformCountToSum transformCountToSum = new TransformCountToSum();
        this.m.transform(transformCountToSum);
        TransformOccurrenceToSum transformOccurrenceToSum = new TransformOccurrenceToSum();
        this.m.transform(transformOccurrenceToSum);
        TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
        this.m.transform(transformDecomposeLex2);
    }

    private void decomposeSatEncodingFlat() {
        TreeTransformer treeTransformer;
        TreeTransformerBottomUp treeTransformerBottomUp;
        TransformDecomposeMinMax transformDecomposeMinMax = new TransformDecomposeMinMax(this.m);
        this.m.transform(transformDecomposeMinMax);
        TransformElementForSAT2 transformElementForSAT2 = new TransformElementForSAT2(this.m);
        this.m.transform(transformElementForSAT2);
        TransformSumForSAT transformSumForSAT = new TransformSumForSAT();
        this.m.transform(transformSumForSAT);
        if (CmdFlags.getSatPBMDD() || CmdFlags.getSatSumMDD() || CmdFlags.getSatPBGPW() || CmdFlags.getSatSumGPW() || CmdFlags.getSatPBSWC() || CmdFlags.getSatSumSWC() || CmdFlags.getSatPBGGT() || CmdFlags.getSatSumGGT()) {
            treeTransformerBottomUp = new TransformSumToAMOPB(this.m);
            this.m.transform(treeTransformerBottomUp);
        }
        treeTransformerBottomUp = new TransformEncodeSumSpecial(this.m);
        this.m.simplify();
        if (!CmdFlags.getSMTtrans() || CmdFlags.getUseIDL() || CmdFlags.getUseUF()) {
            if (CmdFlags.getSMTtrans()) {
                treeTransformer = new TransformBreakupSum2SMT(this.m);
                this.m.transform(treeTransformer);
            } else {
                treeTransformer = new TransformBreakupSum2(this.m);
                this.m.transform(treeTransformer);
            }
        }
        treeTransformer = new TransformSumEq(false);
        this.m.transform(treeTransformer);
        this.m.transform(transformSumForSAT);
        if (!CmdFlags.getSMTtrans() || CmdFlags.getUseFlat() || CmdFlags.getUseIDL() || CmdFlags.getUseUF()) {
            if (CmdFlags.getSMTtrans()) {
                TransformToFlatSMT transformToFlatSMT = new TransformToFlatSMT(this.m, false);
                this.m.transform(transformToFlatSMT);
            } else {
                TransformToFlat transformToFlat = new TransformToFlat(this.m, false);
                this.m.transform(transformToFlat);
            }
        }
    }

    private void satOutput() {
        boolean bl = this.m.toSAT();
        if (!bl) {
            this.createInfoFiles("SAT");
        }
        if (!CmdFlags.getRunSolver()) {
            if (CmdFlags.interactiveSolver) {
                CmdFlags.errorExit("Interactive Solvers only works on run-solver mode");
            }
        } else if (!CmdFlags.dominanceRelation) {
            if (!CmdFlags.interactiveSolver) {
                CmdFlags.println("Created output SAT file " + CmdFlags.satfile);
            }
            SATSolver sATSolver = this.createSolver();
            try {
                sATSolver.findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SAT solver: " + exception);
            }
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    protected void smtOutput() {
        boolean bl = this.m.toSMT();
        if (!bl) {
            this.createInfoFiles("SMT");
        }
        if (!CmdFlags.interactiveSolver) {
            CmdFlags.println("Created output SMT file " + CmdFlags.smtfile);
        }
        if (!CmdFlags.dominanceRelation && CmdFlags.getRunSolver()) {
            SATSolver sATSolver = this.createSolver();
            try {
                sATSolver.findSolutions(CmdFlags.getSMTSolverPath(), CmdFlags.smtfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SMT solver: " + exception);
            }
            File file = new File(CmdFlags.smtfile);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private SATSolver createSolver() {
        SATSolver sATSolver;
        if (CmdFlags.interactiveSolver) {
            if (!CmdFlags.getRunSolver()) {
                CmdFlags.errorExit("Interactive Solvers only works on run-solver mode");
            }
            sATSolver = CmdFlags.getSMTtrans() ? ((InteractiveSMT)this.m.satModel).getInteractiveSolver() : ((InteractiveSat)this.m.satModel).getInteractiveSolver();
        } else if (CmdFlags.getMaxsattrans()) {
            sATSolver = new OpenWBOSATSolver(this.m);
        } else if (CmdFlags.getSMTtrans()) {
            if (CmdFlags.usingZ3()) {
                sATSolver = new Z3Solver(this.m);
            } else if (CmdFlags.usingBoolector()) {
                sATSolver = new BoolectorSolver(this.m);
            } else {
                assert (CmdFlags.usingYices2());
                sATSolver = new YicesSolver(this.m);
            }
        } else if (CmdFlags.getSatFamily().equals("minisat")) {
            sATSolver = new MinisatSATSolver(this.m);
        } else if (CmdFlags.getSatFamily().equals("glucose")) {
            sATSolver = new GlucoseSATSolver(this.m);
        } else if (CmdFlags.getSatFamily().equals("cadical") || CmdFlags.getSatFamily().equals("kissat")) {
            sATSolver = new CadicalSATSolver(this.m);
        } else if (CmdFlags.getSatFamily().equals("nbc_minisat_all") || CmdFlags.getSatFamily().equals("bc_minisat_all")) {
            sATSolver = new AllMinisatSATSolver(this.m);
        } else {
            assert (CmdFlags.getSatFamily().equals("lingeling"));
            sATSolver = new LingelingSATSolver(this.m);
        }
        return sATSolver;
    }

    private void createInfoFiles(String string) {
        Stats stats = new Stats();
        stats.putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
        stats.putValue("SavileRowClauseOut", "1");
        stats.makeInfoFiles();
        CmdFlags.errorExit("Failed when writing " + string + " encoding to file.");
    }

    private void processGiven(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        ASTNode aSTNode3 = aSTNode.getChild(1);
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared twice.");
        }
        this.m.global_symbols.newVariable(string, aSTNode3, 1);
        if (!CmdFlags.getDominiontrans()) {
            int n = 0;
            ASTNode aSTNode4 = null;
            for (ASTNode aSTNode5 : this.parameters) {
                if (!((Identifier)((Letting)aSTNode5).getChildren().get(0)).getName().equals(string)) continue;
                aSTNode4 = aSTNode5;
                ++n;
            }
            if (n != 1) {
                CmdFlags.errorExit("Parameter ('given') variable " + string + " is defined " + n + " times in parameter file.");
            }
            this.processLetting(aSTNode4);
            this.parameters.remove(aSTNode4);
        }
    }

    private void processLetting(ASTNode aSTNode) {
        Serializable serializable;
        ASTNode aSTNode2;
        assert (aSTNode instanceof Letting);
        ASTNode aSTNode3 = aSTNode.getChild(0);
        String string = aSTNode3.toString();
        if (this.m.global_symbols.hasVariable(string) && this.m.global_symbols.getCategory(string) != 1) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if ((aSTNode2 = aSTNode.getChild(1)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: " + aSTNode, "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        if (this.m.global_symbols.getDomain(string) != null) {
            serializable = this.m.global_symbols.getDomain(string);
            if (((ASTNode)serializable).isSet()) {
                if (aSTNode2.getDimension() > 0 || ((ASTNode)serializable).isBooleanSet() != aSTNode2.isRelation()) {
                    CmdFlags.errorExit("For parameter " + string + ", type of value in parameter file does not match type in given statement.");
                }
            } else {
                assert (serializable instanceof MatrixDomain);
                if (aSTNode2.getDimension() == 0) {
                    CmdFlags.errorExit("For parameter " + string + ", type of value in parameter file does not match type in given statement.");
                }
            }
        }
        if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
            this.m.cmstore.newConstantMatrix(string, aSTNode2);
            serializable = this.m.cmstore.makeLettingsConstantMatrix(string);
            Iterator iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                ASTNode aSTNode4 = (ASTNode)iterator.next();
                this.processLetting(aSTNode4);
            }
            this.m.cmstore.correctIndicesConstantMatrix(string, true);
        } else {
            this.m.substitute(aSTNode.getChild(0), aSTNode2.copy());
        }
    }

    private void processFind(ASTNode aSTNode) {
        assert (aSTNode instanceof Find);
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if (aSTNode.getChild(1).getCategory() > 2) {
            CmdFlags.errorExit("In statement : " + aSTNode, "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        this.m.global_symbols.newVariable(string, aSTNode.getChild(1), 3);
    }

    private void processWhere(ASTNode aSTNode) {
        if (CmdFlags.getDominiontrans()) {
            return;
        }
        if ((aSTNode = aSTNode.getChild(0)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: where " + aSTNode, "Contains an identifier that is not a constant or parameter.");
        }
        if (!aSTNode.equals(new BooleanConstant(true))) {
            CmdFlags.errorExit("In statement: where " + aSTNode, "Does not evaluate to true.");
        }
    }

    private ASTNode fixIndexDomainsLetting(ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (aSTNode.numChildren() == 3 && ((aSTNode2 = aSTNode.getChild(1)) instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
            Pair<ASTNode, Boolean> pair = ConstantMatrixStore.fixIndicesConstantMatrix(aSTNode.getChild(2), aSTNode2.copy());
            if (pair.getSecond().booleanValue()) {
                CmdFlags.warning("The index domains in the matrix literal do not match");
                CmdFlags.warning("the given matrix domain in the following letting statement:");
                CmdFlags.warning(String.valueOf(aSTNode));
            }
            return new Letting(aSTNode.getChild(0), pair.getFirst());
        }
        return aSTNode;
    }

    public ModelContainer copy() {
        Model model = this.m.copy();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model);
        for (int i = 0; i < this.parameters.size(); ++i) {
            arrayList.add(transformFixSTRef.transform(this.parameters.get(i)));
        }
        return new ModelContainer(model, arrayList);
    }

    public void writeModelAsJSON(Model model) {
        SymmetryBreaker symmetryBreaker = new SymmetryBreaker();
        symmetryBreaker.detectAndBreakSymmetries(model);
        model.simplify();
    }
}

