/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import savilerow.ASTNode;
import savilerow.BitVector;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.Minimising;
import savilerow.Model;
import savilerow.NumberMap;
import savilerow.Pair;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.SATSolver;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.Stats;
import savilerow.SymbolTable;

public abstract class SMTSolver
extends SATSolver {
    public SMTSolver(Model model) {
        super(model);
    }

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        if (model.objective != null) {
            if (CmdFlags.getSMTEncodeObjective()) {
                this.findOneSolution(string, string2, model);
            } else {
                this.findObjective(string, string2, model);
            }
        } else if (CmdFlags.getFindAllSolutions() || CmdFlags.getFindNumSolutions() > 1L) {
            this.findMultipleSolutions(string, string2, model);
        } else {
            this.findOneSolution(string, string2, model);
        }
        CmdFlags.rmTempFiles();
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        int n;
        CmdFlags.runningSolver = true;
        ArrayList<String> arrayList = this.getCommand(string, string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList3);
        long l = System.nanoTime();
        int n2 = RunCommand.runCommand(false, arrayList, arrayList2, readProcessOutput);
        l = System.nanoTime() - l;
        Stats stats2 = new Stats();
        this.detectErrors(n2, arrayList3, arrayList2, stats2);
        if (!CmdFlags.usingBoolector()) {
            n = arrayList3.size() - 1;
            if (arrayList3.get(n).contains(")") && !arrayList3.get(n).contains("(")) {
                while (n > 0 && !arrayList3.get(n).contains("(")) {
                    --n;
                }
            }
            List<String> list = arrayList3.subList(n, arrayList3.size());
            arrayList3 = new ArrayList<String>(arrayList3.subList(0, n));
            this.updateStats(stats2, list);
        } else {
            for (n = arrayList3.size() - 1; n > 0 && !arrayList3.get(n).contains(")"); --n) {
            }
            arrayList3 = new ArrayList<String>(arrayList3.subList(0, n + 1));
        }
        if (stats2.getValue("SolverTotalTime").equals("NA")) {
            double d = (double)l / 1.0E9;
            stats2.putValue("SolverTotalTime", String.valueOf(d));
        }
        return new Pair<ArrayList<String>, Stats>(this.handleOutput(arrayList3, stats2), stats2);
    }

    protected ArrayList<String> getCommand(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
        arrayList.addAll(arrayList2);
        arrayList.add(string2);
        return arrayList;
    }

    protected abstract void detectErrors(int var1, ArrayList<String> var2, ArrayList<String> var3, Stats var4);

    protected void updateStats(Stats stats, List<String> list) {
        for (String string : list) {
            String string2;
            String[] stringArray;
            String string3;
            if (!string.contains(":") || (string3 = this.getHeader((stringArray = (string2 = string.split(":")[1]).split("\\s+"))[0])) == null) continue;
            stats.putValue(string3, stringArray[1].replace(")", ""));
        }
    }

    protected abstract String getHeader(String var1);

    protected ArrayList<String> handleOutput(ArrayList<String> arrayList, Stats stats) {
        if (arrayList.size() > 0 && arrayList.get(0).equals("sat")) {
            stats.putValue("SolverSatisfiable", "1");
            return new ArrayList<String>(arrayList.subList(1, arrayList.size()));
        }
        if (arrayList.size() > 0 && arrayList.get(0).equals("unsat")) {
            stats.putValue("SolverSatisfiable", "0");
            return null;
        }
        if (arrayList.size() > 0 && arrayList.get(0).equals("unknown")) {
            stats.putValue("SolverSatisfiable", "0");
            return null;
        }
        if (arrayList.contains("unsat")) {
            stats.putValue("SolverSatisfiable", "0");
            return null;
        }
        CmdFlags.warning("SMT solver produced unexpected output. Assuming no solution found.");
        stats.putValue("SolverSatisfiable", "0");
        return null;
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Sat sat = symbolTable.m.satModel;
        long l = 0L;
        for (String string : arrayList) {
            if (string.startsWith("(model") || string.trim().equals("(")) break;
            String[] stringArray = string.split(" ", 2);
            String string2 = stringArray[0].substring(2);
            String string3 = stringArray[1].substring(0, stringArray[1].length() - 2);
            if (CmdFlags.usingBoolector() && !symbolTable.isBitVector(string2)) {
                if (string3.equals("#b1")) {
                    string3 = "true";
                }
                if (string3.equals("#b0")) {
                    string3 = "false";
                }
            }
            if (string3.equals("true") || string3.equals("false")) {
                NumberMap numberMap;
                long l2 = Long.valueOf(string2.substring(1));
                if (string3.contains("false")) {
                    l2 = -l2;
                }
                if ((numberMap = sat.getDimacsMapping(l2)) != null) {
                    hashMap.put(numberMap.getVariable(), numberMap.getValue());
                    l = l2;
                    continue;
                }
                if (l2 > 0L && (numberMap = sat.orderMappingMin.get(l2)) != null) {
                    hashMap.put(numberMap.getVariable(), numberMap.getValue());
                    l = l2;
                    continue;
                }
                if (l2 > 0L && l < 0L && (numberMap = sat.orderMappingMid.get(l2)) != null) {
                    hashMap.put(numberMap.getVariable(), numberMap.getValue());
                    l = l2;
                    continue;
                }
                if (l2 < 0L && (numberMap = sat.orderMappingMax.get(l2)) != null) {
                    hashMap.put(numberMap.getVariable(), numberMap.getValue());
                    l = l2;
                    continue;
                }
                l = l2;
                continue;
            }
            string3 = string3.replaceAll("[() ]", "");
            if (CmdFlags.getUseBV()) {
                hashMap.put(string2, BitVector.toLong(string3));
                continue;
            }
            hashMap.put(string2, Long.valueOf(string3));
        }
        if (CmdFlags.getTestSolutions()) {
            this.checkSolution(hashMap);
        }
        return hashMap;
    }

    @Override
    protected void dichotomicSearch(Identifier identifier, long l) throws IOException {
        if (this.m.global_symbols.isInteger(this.m.objective.getChild(0).toString())) {
            if (this.m.objective instanceof Minimising) {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(<= " + identifier.getName() + " " + l + ")", true);
            } else {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(>= " + identifier.getName() + " " + l + ")", true);
            }
        } else if (this.m.global_symbols.isBitVector(this.m.objective.getChild(0).toString())) {
            if (this.m.objective instanceof Minimising) {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(bvsle " + identifier.getName() + " " + BitVector.toHexString(l) + ")", true);
            } else {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(bvsge " + identifier.getName() + " " + BitVector.toHexString(l) + ")", true);
            }
        } else {
            super.dichotomicSearch(identifier, l);
        }
    }

    @Override
    protected void boundSearch(ASTNode aSTNode, long l, long l2) throws IOException {
        if (this.m.global_symbols.isInteger(aSTNode.toString())) {
            ((SMT)this.m.satModel).addSMTClauseAfterFinalise2("(<= " + aSTNode.toString() + " " + l + ")", "(>= " + aSTNode.toString() + " " + l2 + ")", false);
        } else if (this.m.global_symbols.isBitVector(aSTNode.toString())) {
            ((SMT)this.m.satModel).addSMTClauseAfterFinalise2("(bvsle " + aSTNode.toString() + " " + BitVector.toHexString(l) + ")", "(bvsge " + aSTNode.toString() + " " + BitVector.toHexString(l2) + ")", false);
        } else {
            super.boundSearch(aSTNode, l, l2);
        }
    }

    @Override
    protected void boundSearchRemovable(ASTNode aSTNode, long l, long l2) throws IOException {
        if (this.m.global_symbols.isInteger(aSTNode.toString())) {
            ((SMT)this.m.satModel).addSMTClauseAfterFinalise2("(<= " + aSTNode.toString() + " " + l + ")", "(>= " + aSTNode.toString() + " " + l2 + ")", true);
        } else if (this.m.global_symbols.isBitVector(aSTNode.toString())) {
            ((SMT)this.m.satModel).addSMTClauseAfterFinalise2("(bvsle " + aSTNode.toString() + " " + BitVector.toHexString(l) + ")", "(bvsge " + aSTNode.toString() + " " + BitVector.toHexString(l2) + ")", true);
        } else {
            super.boundSearchRemovable(aSTNode, l, l2);
        }
    }

    @Override
    protected void findObjectiveLinearAddBound(Identifier identifier, long l) throws IOException {
        if (this.m.global_symbols.isInteger(this.m.objective.getChild(0).toString())) {
            if (this.m.objective instanceof Minimising) {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(< " + identifier.getName() + " " + l + ")", false);
            } else {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(> " + identifier.getName() + " " + l + ")", false);
            }
        } else if (this.m.global_symbols.isBitVector(this.m.objective.getChild(0).toString())) {
            if (this.m.objective instanceof Minimising) {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(bvsle " + identifier.getName() + " " + BitVector.toHexString(l - 1L) + ")", false);
            } else {
                ((SMT)this.m.satModel).addSMTClauseAfterFinalise("(bvsge " + identifier.getName() + " " + BitVector.toHexString(l + 1L) + ")", false);
            }
        } else {
            super.findObjectiveLinearAddBound(identifier, l);
        }
    }

    @Override
    public void addBlockingClause(ArrayList<ASTNode> arrayList, ArrayList<Long> arrayList2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(or ");
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            long l = arrayList2.get(i);
            if (this.m.global_symbols.isInteger(aSTNode.toString())) {
                stringBuilder.append("(distinct " + aSTNode + " " + l + ") ");
                continue;
            }
            if (this.m.global_symbols.isBitVector(aSTNode.toString())) {
                stringBuilder.append("(not (= " + aSTNode + " " + BitVector.toHexString(l) + ")) ");
                continue;
            }
            long l2 = -aSTNode.directEncode(this.m.satModel, l);
            if (l2 == 1L) {
                stringBuilder.append(SMT.toLiteral(aSTNode.orderEncode(this.m.satModel, l - 1L)));
                stringBuilder.append(" ");
                stringBuilder.append(SMT.toLiteral(-aSTNode.orderEncode(this.m.satModel, l)));
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(SMT.toLiteral(l2));
            stringBuilder.append(" ");
        }
        stringBuilder.append(")");
        ((SMT)this.m.satModel).addSMTClauseAfterFinalise(stringBuilder.toString(), false);
    }
}

