/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BooleanConstant;
import savilerow.BooleanDomainFull;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.ConstantMatrixStore;
import savilerow.EmptyMatrix;
import savilerow.Flatten;
import savilerow.Identifier;
import savilerow.InSet;
import savilerow.IntegerDomain;
import savilerow.Intpair;
import savilerow.MDDUtils;
import savilerow.Model;
import savilerow.NegativeTable;
import savilerow.Range;
import savilerow.SATLiteral;
import savilerow.Sat;
import savilerow.SymbolTable;
import savilerow.ToSet;

public class Table
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    protected transient Model m;
    HashSet<Intpair> satisfyingTuples;

    public Table(Model model, ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode copy() {
        return new Table(this.m, this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: First argument of table should be 1-dimensional matrix: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 2) {
            CmdFlags.println("ERROR: Second argument of table should be 2-dimensional matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if ((aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) && this.getChild(1).getCategory() == 0) {
            ASTNode aSTNode2 = this.getChildConst(1);
            if (aSTNode2 == this.getChild(1) && (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                ASTNode aSTNode3 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
                this.getChild(0).setParent(null);
                return new Table(this.m, this.getChild(0), aSTNode3);
            }
            if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                if (aSTNode instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                if (aSTNode.numChildren() == 2) {
                    if (aSTNode == this.getChild(0)) {
                        aSTNode.getChild(1).setParent(null);
                    }
                    return new InSet(aSTNode.getChild(1), new ToSet(new Flatten(aSTNode2)));
                }
                boolean bl = false;
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (!aSTNode.getChild(i).isConstant()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
                    ArrayList<ASTNode> arrayList2 = aSTNode2.getChildren(1);
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        if (!arrayList.get(i).isConstant()) continue;
                        long l = arrayList.get(i).getValue();
                        arrayList.remove(i);
                        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            if (arrayList2.get(j).getChild(i + 1).getValue() != l) continue;
                            ArrayList<ASTNode> arrayList4 = arrayList2.get(j).getChildren(1);
                            arrayList4.remove(i);
                            arrayList3.add(CompoundMatrix.make(arrayList4));
                        }
                        arrayList2 = arrayList3;
                    }
                    ASTNode aSTNode4 = CompoundMatrix.make(arrayList2);
                    aSTNode4 = this.m.cmstore.newConstantMatrixDedup(aSTNode4);
                    if (aSTNode == this.getChild(0)) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            arrayList.get(i).setParent(null);
                        }
                    }
                    return new Table(this.m, CompoundMatrix.make(arrayList), aSTNode4);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new NegativeTable(this.m, this.getChild(0), this.getChild(1));
    }

    @Override
    public String toString() {
        return this.generic_to_string("table");
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(0).numChildren() <= 3) {
            bufferedWriter.append("table(");
        } else {
            bufferedWriter.append("table(");
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
            bufferedWriter.append("{");
            for (int i = 1; i < arrayList.size(); ++i) {
                ArrayList<ASTNode> arrayList2 = arrayList.get(i).getChildren();
                bufferedWriter.append("<");
                for (int j = 1; j < arrayList2.size(); ++j) {
                    arrayList2.get(j).toMinion(bufferedWriter, false);
                    if (j >= arrayList2.size() - 1) continue;
                    bufferedWriter.append(", ");
                }
                bufferedWriter.append(">");
                if (i >= arrayList.size() - 1) continue;
                bufferedWriter.append(", ");
            }
            bufferedWriter.append("}");
        } else {
            this.getChild(1).toMinion(bufferedWriter, false);
        }
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("table(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getGecodetrans()) {
            bufferedWriter.append("constraint gecode_table_int(");
        } else {
            bufferedWriter.append("constraint table_int(");
        }
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",[");
        ASTNode aSTNode = this.getChildConst(1);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = 1; j < aSTNode.getChild(i).numChildren(); ++j) {
                aSTNode.getChild(i).getChild(j).toFlatzinc(bufferedWriter, false);
                bufferedWriter.append(",");
            }
        }
        bufferedWriter.append("]);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("table(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ConstantMatrixStore.printMzn2darray(stringBuilder, this.getChild(1));
        } else {
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.toSATHelper2(sat);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.toSATHelper(sat, l, true);
    }

    public void toSATHelper(Sat sat, long l, boolean bl) throws IOException {
        ASTNode aSTNode = this.getChildConst(1);
        ArrayList<Long> arrayList = new ArrayList<Long>(aSTNode.numChildren());
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            ASTNode aSTNode2 = aSTNode.getChild(i);
            long l2 = sat.createAuxSATVariable();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int j = 1; j < aSTNode2.numChildren(); ++j) {
                long l3 = aSTNode2.getChild(j).getValue();
                long l4 = this.getChild(0).getChild(j).directEncode(sat, l3);
                sat.addClause(-l2, l4);
                arrayList2.add(-l4);
            }
            arrayList2.add(l2);
            sat.addClause(arrayList2);
            arrayList.add(l2);
        }
        if (bl) {
            sat.addClauseReified(arrayList, l);
        } else {
            sat.addClause(arrayList);
        }
    }

    public void toSATHelper2(Sat sat) throws IOException {
        ASTNode aSTNode = this.getChildConst(1);
        ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
        if (this.getChild(0).numChildren() == 3) {
            this.satisfyingTuples = new HashSet();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.satisfyingTuples.add(new Intpair(arrayList.get(i).getChild(1).getValue(), arrayList.get(i).getChild(2).getValue()));
            }
            sat.supportEncodingBinary(this, this.getChild(0).getChild(1), this.getChild(0).getChild(2));
            this.satisfyingTuples = null;
            return;
        }
        if (CmdFlags.sat_table_mdd) {
            MDDUtils.MDDEncode(this.getChild(0).getChildren(1), this.getChildConst(1).getChildren(1), sat);
        } else {
            int n;
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
                ASTNode aSTNode2 = this.getChild(0).getChild(i);
                if (aSTNode2 instanceof Identifier) {
                    arrayList2.add(((Identifier)aSTNode2).getDomain());
                    continue;
                }
                if (aSTNode2.isConstant()) {
                    arrayList2.add(new IntegerDomain(new Range(aSTNode2, aSTNode2)));
                    continue;
                }
                if (aSTNode2 instanceof SATLiteral) {
                    arrayList2.add(new BooleanDomainFull());
                    continue;
                }
                assert (false) : "Unknown type contained in table constraint:" + aSTNode2;
            }
            ArrayList<Long> arrayList3 = new ArrayList<Long>(arrayList.size());
            for (n = 0; n < arrayList.size(); ++n) {
                boolean bl = true;
                for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
                    if (((ASTNode)arrayList2.get(i - 1)).containsValue(arrayList.get(n).getChild(i).getValue())) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    arrayList.set(n, arrayList.get(arrayList.size() - 1));
                    arrayList.remove(arrayList.size() - 1);
                    --n;
                    continue;
                }
                arrayList3.add(sat.createAuxSATVariable());
            }
            for (n = 1; n < this.getChild(0).numChildren(); ++n) {
                ASTNode aSTNode3 = this.getChild(0).getChild(n);
                ArrayList<Intpair> arrayList4 = ((ASTNode)arrayList2.get(n - 1)).getIntervalSet();
                long l = Intpair.numValues(arrayList4);
                ArrayList arrayList5 = new ArrayList((int)l);
                int n2 = 0;
                while ((long)n2 < l) {
                    arrayList5.add(new ArrayList());
                    ++n2;
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    long l2 = arrayList.get(n2).getChild(n).getValue();
                    int n3 = -1;
                    int n4 = 0;
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        Intpair intpair = arrayList4.get(i);
                        if (l2 >= intpair.lower && l2 <= intpair.upper) {
                            n3 = (int)(l2 - intpair.lower + (long)n4);
                            break;
                        }
                        n4 = (int)((long)n4 + (intpair.upper - intpair.lower + 1L));
                    }
                    if (n3 == -1) {
                        assert (false) : "Should be no invalid tuples";
                        sat.addClause(-arrayList3.get(n2).longValue());
                        continue;
                    }
                    ((ArrayList)arrayList5.get(n3)).add(arrayList3.get(n2));
                }
                n2 = 0;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    for (long j = arrayList4.get((int)i).lower; j <= arrayList4.get((int)i).upper; ++j) {
                        sat.addClauseReified((ArrayList)arrayList5.get(n2), aSTNode3.directEncode(sat, j));
                        ++n2;
                    }
                }
            }
            sat.addClause(arrayList3);
        }
    }

    @Override
    public boolean test(long l, long l2) {
        return this.satisfyingTuples.contains(new Intpair(l, l2));
    }
}

