/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.MakeTable;
import savilerow.Model;
import savilerow.NegativeTable;
import savilerow.Table;
import savilerow.TableShort;
import savilerow.TabulationUtils;
import savilerow.Tag;

public class Tabulation {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    private static boolean verbose = false;
    private Model m;
    private TabulationUtils tu;
    private long nodelimit;

    public Tabulation(Model model) {
        this.m = model;
        this.tu = new TabulationUtils(this.m);
        this.nodelimit = CmdFlags.tabulate_nolimit ? Long.MAX_VALUE : 300000L;
    }

    public void process(boolean bl) {
        this.processMakeTable(this.m.constraints);
        if (!(bl || CmdFlags.make_short_tab != 3 && CmdFlags.make_short_tab != 4)) {
            HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = this.buildScopesList(this.m.constraints);
            this.identicalScopes(this.m.constraints, hashMap);
            this.applyHeuristicsBool(this.m.constraints);
        }
    }

    private void processMakeTable(ASTNode aSTNode) {
        if (aSTNode instanceof MakeTable) {
            if (CmdFlags.make_short_tab == 0) {
                ASTNode aSTNode2 = aSTNode.getParent();
                int n = aSTNode.getChildNo();
                aSTNode.getChild(0).setParent(null);
                aSTNode2.setChild(n, aSTNode.getChild(0));
                this.processMakeTable(aSTNode2.getChild(n));
            } else {
                ASTNode aSTNode3 = this.tabulate(aSTNode.getChild(0), Long.MAX_VALUE, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, "MakeTableFunction");
                aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
            }
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.processMakeTable(aSTNode.getChild(i));
            }
        }
    }

    private void identicalScopes(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        for (Map.Entry<ArrayList<ASTNode>, ArrayList<ASTNode>> entry : hashMap.entrySet()) {
            ASTNode aSTNode2;
            ArrayList<ASTNode> arrayList = entry.getValue();
            if (arrayList.size() <= 1) continue;
            And and = new And(arrayList);
            if (verbose) {
                System.out.println("H4");
                System.out.println("Trying ct:" + and);
            }
            if ((aSTNode2 = this.tabulate(and, this.nodelimit, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, "IdenticalScopes")) == null) continue;
            this.replaceConstraintSet(arrayList, aSTNode2);
            arrayList.clear();
            arrayList.add(aSTNode2);
        }
    }

    private HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> buildScopesList(ASTNode aSTNode) {
        HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = new HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>>();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (aSTNode3 instanceof Table || aSTNode3 instanceof TableShort || aSTNode3 instanceof NegativeTable || aSTNode3 instanceof Tag) continue;
                assert (aSTNode3.isRelation());
                ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode3);
                ASTNode.sortByAlpha(arrayList);
                if (!hashMap.containsKey(arrayList)) {
                    hashMap.put(arrayList, new ArrayList());
                }
                hashMap.get(arrayList).add(aSTNode3);
            }
        }
        return hashMap;
    }

    private void replaceConstraintSet(ArrayList<ASTNode> arrayList, ASTNode aSTNode) {
        ASTNode aSTNode2 = arrayList.get(0);
        aSTNode2.getParent().setChild(aSTNode2.getChildNo(), aSTNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i);
            aSTNode2.getParent().setChild(aSTNode2.getChildNo(), new BooleanConstant(true));
        }
    }

    private void applyHeuristicsBool(ASTNode aSTNode) {
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3;
                String string;
                ASTNode aSTNode4 = aSTNode2.getChild(i);
                if (aSTNode4 instanceof And || !aSTNode4.isRelation() || aSTNode4 instanceof Table || aSTNode4 instanceof TableShort || aSTNode4 instanceof NegativeTable || aSTNode4 instanceof BooleanConstant || (string = this.heuristic(aSTNode4)) == null || (aSTNode3 = this.tabulate(aSTNode4, this.nodelimit, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, string)) == null) continue;
                aSTNode2.setChild(i, aSTNode3);
            }
        }
    }

    private String heuristic(ASTNode aSTNode) {
        ASTNode aSTNode2;
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesDup(aSTNode);
        if (arrayList.size() < arrayList2.size() && arrayList.size() <= 10) {
            if (verbose) {
                System.out.println("H1");
            }
            return "DuplicateVariables";
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            if (verbose) {
                System.out.println("H2");
            }
            return "LargeAST";
        }
        if (!aSTNode.strongProp() && arrayList.size() <= 10 && (aSTNode2 = this.m.constraints.getChild(0)) instanceof And) {
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (!aSTNode3.strongProp()) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!aSTNode3.contains(arrayList.get(j))) continue;
                    if (verbose) {
                        System.out.println("H3");
                    }
                    return "WeakPropagation";
                }
            }
        }
        return null;
    }

    public boolean contains(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == aSTNode2) {
            return true;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (!this.contains(aSTNode.getChild(i), aSTNode2)) continue;
            return true;
        }
        return false;
    }

    public ASTNode tabulate(ASTNode aSTNode, long l, boolean bl, String string) {
        ASTNode aSTNode2;
        ASTNode aSTNode3 = this.tu.normalise(aSTNode);
        if (CmdFlags.tabulate_diagnostics) {
            CmdFlags.println(ANSI_RED + string + ANSI_RESET + "   Attempting tabulation: " + aSTNode3);
        }
        TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(aSTNode, bl);
        if (retPair.nodereplace != null) {
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("\u001b[32mTabulated\u001b[0m by retrieving from cache.");
            }
            return retPair.nodereplace.current_node;
        }
        long l2 = -1L;
        if (!bl) {
            aSTNode2 = this.tu.makeTableLong(aSTNode3, l);
            l2 = this.tu.nodecount;
        } else {
            aSTNode2 = l == Long.MAX_VALUE ? this.tu.makeTableShort(aSTNode3, l, l, l) : this.tu.makeTableShort(aSTNode3, 10000L, 100000L, 100000L);
        }
        if (aSTNode2 == null) {
            this.tu.saveToFailCache(retPair.expstring);
            if (verbose) {
                System.out.println("Adding to failCache:" + retPair.expstring);
            }
        } else {
            this.tu.saveToCacheNormalised(retPair.expstring, aSTNode3, aSTNode2);
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("\u001b[32mTabulated\u001b[0m in nodes:" + l2);
            }
        }
        return aSTNode2;
    }
}

