(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    663053,      16878]
NotebookOptionsPosition[    662482,      16855]
NotebookOutlinePosition[    662818,      16870]
CellTagsIndexPosition[    662775,      16867]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Inequalities for the triangle scenario (classical case)", "Subsection",
 CellChangeTimes->{{3.71620655917719*^9, 3.716206576635255*^9}, {
  3.716208266523627*^9, 3.7162082666356497`*^9}, {3.716210159413844*^9, 
  3.716210161573709*^9}}],

Cell["\<\
In the following we provide the inequalities obtained from the calculations \
labelled Case 1 and Case 2 in Section III of the article \
\[OpenCurlyDoubleQuote]Non - Shannon inequalities in the entropy vector \
approach to causal structures\[CloseCurlyDoubleQuote]. These inequalities are \
of the form a H (X) + b H (Y) + c H (Z) + d H (XY) + e H (XZ) + f H (YZ) + g \
H (XYZ) \[GreaterEqual] 0. The coefficients a, b, c, d, e, f and g of all \
irredundant inequalities are in the following listed as the rows of a matrix.\
\>", "Text",
 CellChangeTimes->{{3.7162069441073685`*^9, 3.716206961909353*^9}, {
  3.716206992356022*^9, 3.716207088029649*^9}, {3.7162082522928677`*^9, 
  3.7162082525730667`*^9}, {3.7162084876037188`*^9, 3.716208503689339*^9}, {
  3.716210324018527*^9, 3.716210325657267*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"case1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "4", ",", "3", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "6", ",", "4", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "4", ",", "6", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "7", ",", "4", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "4", ",", "7", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "7", ",", "6", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "6", ",", "7", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "6", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "7", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "6", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "6", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "7", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "6", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "7", ",", "7", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", "11", ",", "11", ",", "9", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", "11", ",", "9", ",", "11", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", "9", ",", "11", ",", "11", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "6", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "7", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "5"}], ",", "7", ",", "6", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "8", ",", "6", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "9", ",", "7", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "3"}], ",", "8", ",", "6", ",", "6", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "6", ",", "7", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "7", ",", "9", ",", "6", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "7", ",", "6", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "9", ",", "8", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "8", ",", "9", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", "9", ",", "9", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", "8", ",", "9", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", "9", ",", "9", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", "9", ",", "8", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "12", ",", "9", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "9", ",", "12", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", "12", ",", "12", ",", "9", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", "9", ",", "12", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "12", ",", "9", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "9", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "12", ",", "13", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "13", ",", "12", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", "13", ",", "12", ",", "12", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "17", ",", "15", ",", "15", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "15", ",", "17", ",", "15", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "15", ",", "15", ",", "17", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "21"}], ",", "20", ",", "15", ",", "20", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "21"}], ",", "15", ",", "20", ",", "20", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "21"}], ",", "20", ",", "20", ",", "15", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "21"}], ",", "15", ",", "20", ",", "20", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "20"}], ",", "20", ",", "20", ",", "15", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "20"}], ",", "20", ",", "15", ",", "20", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "9"}], ",", "11", ",", "11", ",", "12", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", "11", ",", "12", ",", "11", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "7"}], ",", "12", ",", "11", ",", "11", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "26", ",", "24", ",", "18", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "26", ",", "18", ",", "24", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "24", ",", "26", ",", "18", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "24", ",", "18", ",", "26", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "18", ",", "26", ",", "24", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "18", ",", "24", ",", "26", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", "23", ",", "18", ",", "20", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", "18", ",", "23", ",", "20", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", "23", ",", "20", ",", "18", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", "18", ",", "20", ",", "23", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", "20", ",", "23", ",", "18", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", "20", ",", "18", ",", "23", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", "11", ",", "14", ",", "13", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", "11", ",", "13", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", "14", ",", "11", ",", "13", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", "13", ",", "11", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "14", ",", "13", ",", "11", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "13", ",", "14", ",", "11", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "12"}], ",", "14", ",", "14", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "11"}], ",", "14", ",", "14", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "14", ",", "14", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "14"}], ",", "14", ",", "15", ",", "17", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "12"}], ",", "15", ",", "14", ",", "17", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "14"}], ",", "14", ",", "17", ",", "15", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", "17", ",", "14", ",", "15", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "12"}], ",", "15", ",", "17", ",", "14", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "10"}], ",", "17", ",", "15", ",", "14", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "17", ",", "16", ",", "18", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "16", ",", "17", ",", "18", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", "17", ",", "18", ",", "16", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", "16", ",", "18", ",", "17", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", "18", ",", "17", ",", "16", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", "18", ",", "16", ",", "17", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "26", ",", "24", ",", "24", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "24", ",", "26", ",", "24", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "27"}], ",", "26", ",", "24", ",", "24", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "27"}], ",", "24", ",", "24", ",", "26", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "24"}], ",", "24", ",", "26", ",", "24", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "24"}], ",", "24", ",", "24", ",", "26", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "21", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", "21", ",", "22", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "22", ",", "21", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", "21", ",", "22", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", "22", ",", "22", ",", "21", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", "22", ",", "21", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "22", ",", "23", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "18"}], ",", "22", ",", "22", ",", "23", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "23", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", "23", ",", "22", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", "22", ",", "23", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", "23", ",", "22", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "21"}], ",", "22", ",", "23", ",", "26", ",", 
       RowBox[{"-", "28"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "19"}], ",", "23", ",", "22", ",", "26", ",", 
       RowBox[{"-", "28"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "21"}], ",", "22", ",", "26", ",", "23", ",", 
       RowBox[{"-", "28"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "15"}], ",", "26", ",", "22", ",", "23", ",", 
       RowBox[{"-", "28"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "19"}], ",", "23", ",", "26", ",", "22", ",", 
       RowBox[{"-", "28"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "15"}], ",", "26", ",", "23", ",", "22", ",", 
       RowBox[{"-", "28"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "23"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "22"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "23"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "20"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "22"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "20"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "25"}], ",", "27", ",", "28", ",", "30", ",", 
       RowBox[{"-", "33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "23"}], ",", "28", ",", "27", ",", "30", ",", 
       RowBox[{"-", "33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "25"}], ",", "27", ",", "30", ",", "28", ",", 
       RowBox[{"-", "33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "19"}], ",", "30", ",", "27", ",", "28", ",", 
       RowBox[{"-", "33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", "28", ",", "30", ",", "27", ",", 
       RowBox[{"-", "33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", "30", ",", "28", ",", "27", ",", 
       RowBox[{"-", "33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "33"}], ",", "35", ",", "35", ",", "33", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "32"}], ",", "35", ",", "35", ",", "33", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "33"}], ",", "35", ",", "33", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "30"}], ",", "33", ",", "35", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "32"}], ",", "35", ",", "33", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "30"}], ",", "33", ",", "35", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", "41", ",", "41", ",", "45", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "46"}], ",", "41", ",", "45", ",", "41", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "42"}], ",", "45", ",", "41", ",", "41", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "29"}], ",", "27", ",", "30", ",", "36", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "23"}], ",", "30", ",", "27", ",", "36", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "29"}], ",", "27", ",", "36", ",", "30", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "19"}], ",", "36", ",", "27", ",", "30", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", "30", ",", "36", ",", "27", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", "36", ",", "30", ",", "27", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", "35", ",", "36", ",", "44", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", "36", ",", "35", ",", "44", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "39"}], ",", "35", ",", "44", ",", "36", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "29"}], ",", "44", ",", "35", ",", "36", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "33"}], ",", "36", ",", "44", ",", "35", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "29"}], ",", "44", ",", "36", ",", "35", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "58", ",", "48", ",", "60", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "48", ",", "58", ",", "60", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", "58", ",", "60", ",", "48", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", "48", ",", "60", ",", "58", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", "60", ",", "58", ",", "48", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", "60", ",", "48", ",", "58", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", "41", ",", "39", ",", "42", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", "39", ",", "41", ",", "42", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", "41", ",", "42", ",", "39", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", "39", ",", "42", ",", "41", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", "42", ",", "41", ",", "39", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", "42", ",", "39", ",", "41", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "59", ",", "57", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "57", ",", "59", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", "59", ",", "57", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", "57", ",", "57", ",", "59", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", "57", ",", "59", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", "57", ",", "57", ",", "59", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", "48", ",", "43", ",", "50", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", "43", ",", "48", ",", "50", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", "48", ",", "50", ",", "43", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", "43", ",", "50", ",", "48", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", "50", ",", "48", ",", "43", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", "50", ",", "43", ",", "48", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", "56", ",", "54", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", "54", ",", "56", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", "56", ",", "54", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", "54", ",", "54", ",", "56", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", "54", ",", "56", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", "54", ",", "54", ",", "56", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", "82", ",", "72", ",", "85", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", "72", ",", "82", ",", "85", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", "82", ",", "85", ",", "72", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", "72", ",", "85", ",", "82", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", "85", ",", "82", ",", "72", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", "85", ",", "72", ",", "82", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "63"}], ",", "56", ",", "60", ",", "72", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "51"}], ",", "60", ",", "56", ",", "72", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "63"}], ",", "56", ",", "72", ",", "60", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "45"}], ",", "72", ",", "56", ",", "60", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", "60", ",", "72", ",", "56", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", "72", ",", "60", ",", "56", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", "94", ",", "84", ",", "90", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", "84", ",", "94", ",", "90", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", "94", ",", "90", ",", "84", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", "84", ",", "90", ",", "94", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", "90", ",", "94", ",", "84", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", "90", ",", "84", ",", "94", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "63"}], ",", "73", ",", "73", ",", "75", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "58"}], ",", "73", ",", "73", ",", "75", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "63"}], ",", "73", ",", "75", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "56"}], ",", "75", ",", "73", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "58"}], ",", "73", ",", "75", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "56"}], ",", "75", ",", "73", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "73"}], ",", "73", ",", "78", ",", "90", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "63"}], ",", "78", ",", "73", ",", "90", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "73"}], ",", "73", ",", "90", ",", "78", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "51"}], ",", "90", ",", "73", ",", "78", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "63"}], ",", "78", ",", "90", ",", "73", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "51"}], ",", "90", ",", "78", ",", "73", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", "147", ",", "137", ",", "155", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", "137", ",", "147", ",", "155", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", "147", ",", "155", ",", "137", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", "137", ",", "155", ",", "147", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", "155", ",", "147", ",", "137", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", "155", ",", "137", ",", "147", ",", 
       RowBox[{"-", "125"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6702428679018793`*^9, 3.670242869577631*^9}, 
   3.6702446264952784`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"case2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "4", ",", "3", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "4", ",", "7", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "6", ",", "7", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "7", ",", "6", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "7", ",", "4", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "4", ",", "6", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "6", ",", "4", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "6", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "3"}], ",", "8", ",", "6", ",", "6", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "8", ",", "6", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "7", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "6", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", "6", ",", "6", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "6", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "7", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "7"}], ",", "7", ",", "6", ",", "6", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "7", ",", "7", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "8", ",", "9", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", "9", ",", "8", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", "8", ",", "9", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", "9", ",", "8", ",", "9", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", "9", ",", "9", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "8"}], ",", "9", ",", "9", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "10", ",", "5", ",", "11", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "5", ",", "10", ",", "11", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "5", ",", "11", ",", "10", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "10", ",", "11", ",", "5", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "11", ",", "5", ",", "10", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "11", ",", "10", ",", "5", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "10", ",", "11", ",", "11", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "11", ",", "10", ",", "11", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", "10", ",", "11", ",", "11", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", "11", ",", "10", ",", "11", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", "11", ",", "11", ",", "10", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "11"}], ",", "11", ",", "11", ",", "10", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "9"}], ",", "10", ",", "10", ",", "15", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "9"}], ",", "11", ",", "11", ",", "12", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "7"}], ",", "12", ",", "11", ",", "11", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", "11", ",", "12", ",", "11", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "4"}], ",", "15", ",", "10", ",", "10", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "9"}], ",", "10", ",", "15", ",", "10", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", "11", ",", "11", ",", "9", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", "9", ",", "11", ",", "11", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", "11", ",", "9", ",", "11", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "9", ",", "12", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "12", ",", "9", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "9", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", "9", ",", "12", ",", "12", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "12", ",", "9", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "11"}], ",", "12", ",", "12", ",", "9", ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "12", ",", "13", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "13", ",", "12", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", "13", ",", "12", ",", "12", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", "13", ",", "14", ",", "13", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", "14", ",", "13", ",", "13", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", "13", ",", "13", ",", "14", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", "13", ",", "14", ",", "13", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", "13", ",", "13", ",", "14", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "13"}], ",", "14", ",", "13", ",", "13", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "11"}], ",", "14", ",", "14", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "12"}], ",", "14", ",", "14", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "11"}], ",", "14", ",", "14", ",", "14", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "10", ",", "16", ",", "16", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "16", ",", "10", ",", "16", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "14"}], ",", "16", ",", "10", ",", "16", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "15"}], ",", "10", ",", "16", ",", "16", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "14"}], ",", "16", ",", "16", ",", "10", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "15"}], ",", "16", ",", "16", ",", "10", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", "11", ",", "16", ",", "16", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", "16", ",", "16", ",", "11", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", "16", ",", "11", ",", "16", ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "16", ",", "17", ",", "18", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "17", ",", "16", ",", "18", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", "18", ",", "16", ",", "17", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", "18", ",", "17", ",", "16", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", "16", ",", "18", ",", "17", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "15"}], ",", "17", ",", "18", ",", "16", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "15", ",", "15", ",", "17", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "15", ",", "17", ",", "15", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "17", ",", "15", ",", "15", ",", 
       RowBox[{"-", "11"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", "17", ",", "17", ",", "18", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "11"}], ",", "18", ",", "17", ",", "17", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "15"}], ",", "17", ",", "18", ",", "17", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", "17", ",", "18", ",", "20", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", "18", ",", "17", ",", "20", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "16", ",", "19", ",", "18", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", "19", ",", "16", ",", "18", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "12"}], ",", "20", ",", "17", ",", "18", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "12"}], ",", "20", ",", "18", ",", "17", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "17"}], ",", "17", ",", "20", ",", "18", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "17"}], ",", "18", ",", "20", ",", "17", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", "16", ",", "18", ",", "19", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", "18", ",", "16", ",", "19", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", "18", ",", "19", ",", "16", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", "19", ",", "18", ",", "16", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "16"}], ",", "19", ",", "19", ",", "18", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "17"}], ",", "19", ",", "19", ",", "18", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "15"}], ",", "18", ",", "19", ",", "19", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "17"}], ",", "19", ",", "18", ",", "19", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "15"}], ",", "18", ",", "19", ",", "19", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "16"}], ",", "19", ",", "18", ",", "19", ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", "16", ",", "20", ",", "19", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", "20", ",", "16", ",", "19", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "17"}], ",", "19", ",", "16", ",", "20", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "20"}], ",", "16", ",", "19", ",", "20", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "17"}], ",", "19", ",", "20", ",", "16", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "20"}], ",", "20", ",", "19", ",", "16", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", "18", ",", "18", ",", "21", ",", 
       RowBox[{"-", "17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "20"}], ",", "18", ",", "21", ",", "18", ",", 
       RowBox[{"-", "17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "17"}], ",", "21", ",", "18", ",", "18", ",", 
       RowBox[{"-", "17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", "19", ",", "19", ",", "23", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "14"}], ",", "23", ",", "19", ",", "19", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "20"}], ",", "19", ",", "23", ",", "19", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "22"}], ",", "21", ",", "16", ",", "21", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "22"}], ",", "16", ",", "21", ",", "21", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "21"}], ",", "21", ",", "16", ",", "21", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "21"}], ",", "21", ",", "21", ",", "16", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "22"}], ",", "21", ",", "21", ",", "16", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "22"}], ",", "16", ",", "21", ",", "21", ",", 
       RowBox[{"-", "14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", "21", ",", "22", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "21", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", "22", ",", "21", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", "22", ",", "22", ",", "21", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", "21", ",", "22", ",", "22", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "22", ",", "21", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", "18", ",", "23", ",", "20", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", "23", ",", "18", ",", "20", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", "18", ",", "20", ",", "23", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", "20", ",", "18", ",", "23", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", "20", ",", "23", ",", "18", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "23"}], ",", "23", ",", "20", ",", "18", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "18"}], ",", "22", ",", "22", ",", "23", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "22", ",", "23", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", "23", ",", "22", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", "22", ",", "23", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "16"}], ",", "23", ",", "22", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "18"}], ",", "22", ",", "23", ",", "22", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", "24", ",", "25", ",", "23", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", "25", ",", "24", ",", "23", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", "23", ",", "24", ",", "25", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", "23", ",", "25", ",", "24", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", "24", ",", "23", ",", "25", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "23"}], ",", "25", ",", "23", ",", "24", ",", 
       RowBox[{"-", "24"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "22"}], ",", "25", ",", "26", ",", "25", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "24"}], ",", "26", ",", "25", ",", "25", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "22"}], ",", "25", ",", "25", ",", "26", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "27", ",", "25", ",", "19", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "25", ",", "19", ",", "27", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "19", ",", "25", ",", "27", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "25", ",", "27", ",", "19", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "27", ",", "19", ",", "25", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "19", ",", "27", ",", "25", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "19", ",", "28", ",", "27", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", "28", ",", "19", ",", "27", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "25"}], ",", "27", ",", "19", ",", "28", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "27"}], ",", "19", ",", "27", ",", "28", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "25"}], ",", "27", ",", "28", ",", "19", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "27"}], ",", "28", ",", "27", ",", "19", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "22"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "23"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "20"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "23"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "20"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "22"}], ",", "27", ",", "27", ",", "27", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "25", ",", "27", ",", "25", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", "27", ",", "25", ",", "25", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "28"}], ",", "25", ",", "25", ",", "27", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "28"}], ",", "27", ",", "25", ",", "25", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "25"}], ",", "25", ",", "25", ",", "27", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "25"}], ",", "25", ",", "27", ",", "25", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "30"}], ",", "29", ",", "18", ",", "29", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "30"}], ",", "18", ",", "29", ",", "29", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "30"}], ",", "29", ",", "29", ",", "18", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "30"}], ",", "18", ",", "29", ",", "29", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "29"}], ",", "29", ",", "18", ",", "29", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "29"}], ",", "29", ",", "29", ",", "18", ",", 
       RowBox[{"-", "16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "26"}], ",", "30", ",", "30", ",", "28", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "27"}], ",", "30", ",", "30", ",", "28", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "23"}], ",", "28", ",", "30", ",", "30", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "27"}], ",", "30", ",", "28", ",", "30", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "23"}], ",", "28", ",", "30", ",", "30", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "26"}], ",", "30", ",", "28", ",", "30", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", "26", ",", "26", ",", "31", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", "26", ",", "31", ",", "26", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", "31", ",", "26", ",", "26", ",", 
       RowBox[{"-", "19"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", "31", ",", "23", ",", "32", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", "23", ",", "31", ",", "32", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "32"}], ",", "31", ",", "32", ",", "23", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "29"}], ",", "32", ",", "23", ",", "31", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "32"}], ",", "23", ",", "32", ",", "31", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "29"}], ",", "32", ",", "31", ",", "23", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "34"}], ",", "34", ",", "32", ",", "28", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "34"}], ",", "32", ",", "34", ",", "28", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "32"}], ",", "28", ",", "32", ",", "34", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "34"}], ",", "34", ",", "28", ",", "32", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "32"}], ",", "28", ",", "34", ",", "32", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "34"}], ",", "32", ",", "28", ",", "34", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "28"}], ",", "33", ",", "34", ",", "34", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "30"}], ",", "34", ",", "33", ",", "34", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "27"}], ",", "34", ",", "34", ",", "33", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "30"}], ",", "34", ",", "34", ",", "33", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "28"}], ",", "33", ",", "34", ",", "34", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "27"}], ",", "34", ",", "33", ",", "34", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "33"}], ",", "32", ",", "35", ",", "36", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "33"}], ",", "35", ",", "32", ",", "36", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "26"}], ",", "36", ",", "32", ",", "35", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "26"}], ",", "36", ",", "35", ",", "32", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "33"}], ",", "32", ",", "36", ",", "35", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "33"}], ",", "35", ",", "36", ",", "32", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "32"}], ",", "35", ",", "35", ",", "33", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "33"}], ",", "35", ",", "35", ",", "33", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "33"}], ",", "35", ",", "33", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "30"}], ",", "33", ",", "35", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "30"}], ",", "33", ",", "35", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "32"}], ",", "35", ",", "33", ",", "35", ",", 
       RowBox[{"-", "34"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "39", ",", "37", ",", "22", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "22", ",", "37", ",", "39", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "37", ",", "22", ",", "39", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "37", ",", "39", ",", "22", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "22", ",", "39", ",", "37", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "39", ",", "22", ",", "37", ",", 
       RowBox[{"-", "18"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", "22", ",", "40", ",", "39", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", "40", ",", "22", ",", "39", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "37"}], ",", "39", ",", "22", ",", "40", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "39"}], ",", "22", ",", "39", ",", "40", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "37"}], ",", "39", ",", "40", ",", "22", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "39"}], ",", "40", ",", "39", ",", "22", ",", 
       RowBox[{"-", "22"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", "29", ",", "37", ",", "39", ",", 
       RowBox[{"-", "23"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", "39", ",", "37", ",", "29", ",", 
       RowBox[{"-", "23"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", "29", ",", "39", ",", "37", ",", 
       RowBox[{"-", "23"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", "37", ",", "39", ",", "29", ",", 
       RowBox[{"-", "23"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", "39", ",", "29", ",", "37", ",", 
       RowBox[{"-", "23"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "41"}], ",", "37", ",", "29", ",", "39", ",", 
       RowBox[{"-", "23"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "39", ",", "37", ",", "40", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "37", ",", "39", ",", "40", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "40"}], ",", "37", ",", "40", ",", "39", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "31"}], ",", "40", ",", "37", ",", "39", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "40"}], ",", "39", ",", "40", ",", "37", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "31"}], ",", "40", ",", "39", ",", "37", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "35"}], ",", "40", ",", "41", ",", "41", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "35"}], ",", "41", ",", "40", ",", "41", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "29"}], ",", "41", ",", "40", ",", "41", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "29"}], ",", "41", ",", "41", ",", "40", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "35"}], ",", "40", ",", "41", ",", "41", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "35"}], ",", "41", ",", "41", ",", "40", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "44"}], ",", "26", ",", "43", ",", "44", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "44"}], ",", "43", ",", "26", ",", "44", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "44"}], ",", "43", ",", "44", ",", "26", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "44"}], ",", "26", ",", "44", ",", "43", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "41"}], ",", "44", ",", "26", ",", "43", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "41"}], ",", "44", ",", "43", ",", "26", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "42", ",", "40", ",", "37", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", "40", ",", "42", ",", "37", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "37"}], ",", "37", ",", "40", ",", "42", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "40"}], ",", "42", ",", "37", ",", "40", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "37"}], ",", "37", ",", "42", ",", "40", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "40"}], ",", "40", ",", "37", ",", "42", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", "39", ",", "41", ",", "42", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", "41", ",", "39", ",", "42", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", "42", ",", "39", ",", "41", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", "41", ",", "42", ",", "39", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", "42", ",", "41", ",", "39", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", "39", ",", "42", ",", "41", ",", 
       RowBox[{"-", "41"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "37"}], ",", "41", ",", "42", ",", "43", ",", 
       RowBox[{"-", "45"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "39"}], ",", "42", ",", "41", ",", "43", ",", 
       RowBox[{"-", "45"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "32"}], ",", "43", ",", "42", ",", "41", ",", 
       RowBox[{"-", "45"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "39"}], ",", "42", ",", "43", ",", "41", ",", 
       RowBox[{"-", "45"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "41"}], ",", "43", ",", "43", ",", "36", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "42"}], ",", "43", ",", "43", ",", "36", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "32"}], ",", "43", ",", "41", ",", "42", ",", 
       RowBox[{"-", "45"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "37"}], ",", "41", ",", "43", ",", "42", ",", 
       RowBox[{"-", "45"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "42"}], ",", "43", ",", "36", ",", "43", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "38"}], ",", "36", ",", "43", ",", "43", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "38"}], ",", "36", ",", "43", ",", "43", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "41"}], ",", "43", ",", "36", ",", "43", ",", 
       RowBox[{"-", "36"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", "35", ",", "41", ",", "45", ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", "45", ",", "41", ",", "35", ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", "35", ",", "45", ",", "41", ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", "41", ",", "45", ",", "35", ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", "41", ",", "35", ",", "45", ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "47"}], ",", "45", ",", "35", ",", "41", ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", "45", ",", "40", ",", "43", ",", 
       RowBox[{"-", "39"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", "40", ",", "45", ",", "43", ",", 
       RowBox[{"-", "39"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "43"}], ",", "45", ",", "43", ",", "40", ",", 
       RowBox[{"-", "39"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "40"}], ",", "43", ",", "40", ",", "45", ",", 
       RowBox[{"-", "39"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "43"}], ",", "40", ",", "43", ",", "45", ",", 
       RowBox[{"-", "39"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "40"}], ",", "43", ",", "45", ",", "40", ",", 
       RowBox[{"-", "39"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", "41", ",", "41", ",", "45", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "46"}], ",", "41", ",", "45", ",", "41", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "42"}], ",", "45", ",", "41", ",", "41", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "49", ",", "44", ",", "32", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "44", ",", "32", ",", "49", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "44", ",", "49", ",", "32", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "32", ",", "44", ",", "49", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "32", ",", "49", ",", "44", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "49", ",", "32", ",", "44", ",", 
       RowBox[{"-", "25"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "38"}], ",", "46", ",", "46", ",", "46", ",", 
       RowBox[{"-", "53"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "39"}], ",", "46", ",", "46", ",", "46", ",", 
       RowBox[{"-", "53"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", "46", ",", "46", ",", "46", ",", 
       RowBox[{"-", "53"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "39"}], ",", "46", ",", "46", ",", "46", ",", 
       RowBox[{"-", "53"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "33"}], ",", "46", ",", "46", ",", "46", ",", 
       RowBox[{"-", "53"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "38"}], ",", "46", ",", "46", ",", "46", ",", 
       RowBox[{"-", "53"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", "46", ",", "44", ",", "49", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", "44", ",", "46", ",", "49", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "35"}], ",", "49", ",", "44", ",", "46", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "46"}], ",", "46", ",", "49", ",", "44", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "35"}], ",", "49", ",", "46", ",", "44", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "46"}], ",", "44", ",", "49", ",", "46", ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", "43", ",", "48", ",", "50", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", "48", ",", "43", ",", "50", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", "43", ",", "50", ",", "48", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", "50", ",", "43", ",", "48", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", "50", ",", "48", ",", "43", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "43"}], ",", "48", ",", "50", ",", "43", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "49", ",", "44", ",", "44", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", "44", ",", "49", ",", "44", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "50"}], ",", "44", ",", "44", ",", "49", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "44"}], ",", "44", ",", "44", ",", "49", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "50"}], ",", "49", ",", "44", ",", "44", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "44"}], ",", "44", ",", "49", ",", "44", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "43"}], ",", "48", ",", "49", ",", "46", ",", 
       RowBox[{"-", "49"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "45"}], ",", "49", ",", "48", ",", "46", ",", 
       RowBox[{"-", "49"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "39"}], ",", "46", ",", "49", ",", "48", ",", 
       RowBox[{"-", "49"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "45"}], ",", "49", ",", "46", ",", "48", ",", 
       RowBox[{"-", "49"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "39"}], ",", "46", ",", "48", ",", "49", ",", 
       RowBox[{"-", "49"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "43"}], ",", "48", ",", "46", ",", "49", ",", 
       RowBox[{"-", "49"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "52"}], ",", "40", ",", "48", ",", "51", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "52"}], ",", "48", ",", "40", ",", "51", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "49"}], ",", "51", ",", "48", ",", "40", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "52"}], ",", "48", ",", "51", ",", "40", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "52"}], ",", "40", ",", "51", ",", "48", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "49"}], ",", "51", ",", "40", ",", "48", ",", 
       RowBox[{"-", "35"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", "54", ",", "56", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", "56", ",", "54", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", "54", ",", "54", ",", "56", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", "56", ",", "54", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", "54", ",", "56", ",", "54", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "51"}], ",", "54", ",", "54", ",", "56", ",", 
       RowBox[{"-", "56"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "57"}], ",", "53", ",", "55", ",", "57", ",", 
       RowBox[{"-", "51"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "57"}], ",", "55", ",", "53", ",", "57", ",", 
       RowBox[{"-", "51"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "45"}], ",", "57", ",", "53", ",", "55", ",", 
       RowBox[{"-", "51"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "45"}], ",", "57", ",", "55", ",", "53", ",", 
       RowBox[{"-", "51"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "57"}], ",", "55", ",", "57", ",", "53", ",", 
       RowBox[{"-", "51"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "57"}], ",", "53", ",", "57", ",", "55", ",", 
       RowBox[{"-", "51"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "49"}], ",", "57", ",", "58", ",", "61", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "51"}], ",", "58", ",", "57", ",", "61", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "53"}], ",", "59", ",", "59", ",", "54", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "54"}], ",", "59", ",", "59", ",", "54", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "42"}], ",", "61", ",", "58", ",", "57", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "51"}], ",", "58", ",", "61", ",", "57", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "42"}], ",", "61", ",", "57", ",", "58", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "49"}], ",", "57", ",", "61", ",", "58", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "54"}], ",", "59", ",", "54", ",", "59", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "48"}], ",", "54", ",", "59", ",", "59", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "48"}], ",", "54", ",", "59", ",", "59", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "53"}], ",", "59", ",", "54", ",", "59", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "48", ",", "58", ",", "60", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "58", ",", "48", ",", "60", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", "58", ",", "60", ",", "48", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", "60", ",", "58", ",", "48", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", "48", ",", "60", ",", "58", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", "60", ",", "48", ",", "58", ",", 
       RowBox[{"-", "40"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "57", ",", "59", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", "59", ",", "57", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", "57", ",", "57", ",", "59", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", "59", ",", "57", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", "57", ",", "59", ",", "57", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "63"}], ",", "57", ",", "57", ",", "59", ",", 
       RowBox[{"-", "47"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "62"}], ",", "63", ",", "58", ",", "62", ",", 
       RowBox[{"-", "57"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "62"}], ",", "58", ",", "63", ",", "62", ",", 
       RowBox[{"-", "57"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "52"}], ",", "62", ",", "58", ",", "63", ",", 
       RowBox[{"-", "57"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "62"}], ",", "63", ",", "62", ",", "58", ",", 
       RowBox[{"-", "57"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "52"}], ",", "62", ",", "63", ",", "58", ",", 
       RowBox[{"-", "57"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "62"}], ",", "58", ",", "62", ",", "63", ",", 
       RowBox[{"-", "57"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "64"}], ",", "65", ",", "67", ",", "58", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "64"}], ",", "67", ",", "65", ",", "58", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "56"}], ",", "58", ",", "65", ",", "67", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "56"}], ",", "58", ",", "67", ",", "65", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "64"}], ",", "65", ",", "58", ",", "67", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "64"}], ",", "67", ",", "58", ",", "65", ",", 
       RowBox[{"-", "58"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "73", ",", "68", ",", "38", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "68", ",", "38", ",", "73", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "68", ",", "73", ",", "38", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "38", ",", "68", ",", "73", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "38", ",", "73", ",", "68", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "73", ",", "38", ",", "68", ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "69"}], ",", 
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "72"}], ",", "48", ",", "68", ",", "71", ",", 
       RowBox[{"-", "43"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "69"}], ",", 
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "72"}], ",", "68", ",", "48", ",", "71", ",", 
       RowBox[{"-", "43"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "69"}], ",", 
       RowBox[{"-", "72"}], ",", "48", ",", "71", ",", "68", ",", 
       RowBox[{"-", "43"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "69"}], ",", "71", ",", "68", ",", "48", ",", 
       RowBox[{"-", "43"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "69"}], ",", 
       RowBox[{"-", "72"}], ",", "68", ",", "71", ",", "48", ",", 
       RowBox[{"-", "43"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "69"}], ",", "71", ",", "48", ",", "68", ",", 
       RowBox[{"-", "43"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", "72", ",", "73", ",", "73", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", "73", ",", "72", ",", "73", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "54"}], ",", "73", ",", "73", ",", "72", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "63"}], ",", "73", ",", "73", ",", "72", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "54"}], ",", "73", ",", "72", ",", "73", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "61"}], ",", "72", ",", "73", ",", "73", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "58"}], ",", "73", ",", "73", ",", "75", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "63"}], ",", "73", ",", "73", ",", "75", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "56"}], ",", "75", ",", "73", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "63"}], ",", "73", ",", "75", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "58"}], ",", "73", ",", "75", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "56"}], ",", "75", ",", "73", ",", "73", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "73", ",", "68", ",", "74", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "68", ",", "73", ",", "74", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "74"}], ",", "68", ",", "74", ",", "73", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "56"}], ",", "74", ",", "68", ",", "73", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "56"}], ",", "74", ",", "73", ",", "68", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "74"}], ",", "73", ",", "74", ",", "68", ",", 
       RowBox[{"-", "67"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "76"}], ",", "74", ",", "64", ",", "73", ",", 
       RowBox[{"-", "59"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "76"}], ",", "64", ",", "74", ",", "73", ",", 
       RowBox[{"-", "59"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "67"}], ",", "73", ",", "64", ",", "74", ",", 
       RowBox[{"-", "59"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "76"}], ",", "64", ",", "73", ",", "74", ",", 
       RowBox[{"-", "59"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "76"}], ",", "74", ",", "73", ",", "64", ",", 
       RowBox[{"-", "59"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "67"}], ",", "73", ",", "74", ",", "64", ",", 
       RowBox[{"-", "59"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "77", ",", "72", ",", "68", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "72", ",", "77", ",", "68", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "66"}], ",", "68", ",", "72", ",", "77", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "66"}], ",", "68", ",", "77", ",", "72", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "74"}], ",", "72", ",", "68", ",", "77", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "74"}], ",", "77", ",", "68", ",", "72", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "79", ",", "74", ",", "80", ",", 
       RowBox[{"-", "79"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", "74", ",", "79", ",", "80", ",", 
       RowBox[{"-", "79"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "62"}], ",", "80", ",", "74", ",", "79", ",", 
       RowBox[{"-", "79"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "74"}], ",", "79", ",", "80", ",", "74", ",", 
       RowBox[{"-", "79"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "62"}], ",", "80", ",", "79", ",", "74", ",", 
       RowBox[{"-", "79"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "74"}], ",", "74", ",", "80", ",", "79", ",", 
       RowBox[{"-", "79"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "79"}], ",", "73", ",", "75", ",", "85", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "79"}], ",", "75", ",", "73", ",", "85", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "61"}], ",", "85", ",", "73", ",", "75", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "79"}], ",", "75", ",", "85", ",", "73", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "61"}], ",", "85", ",", "75", ",", "73", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "79"}], ",", "73", ",", "85", ",", "75", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "75"}], ",", 
       RowBox[{"-", "73"}], ",", "81", ",", "82", ",", "76", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "75"}], ",", "82", ",", "81", ",", "76", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "75"}], ",", 
       RowBox[{"-", "63"}], ",", "76", ",", "82", ",", "81", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "75"}], ",", "82", ",", "76", ",", "81", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "75"}], ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "63"}], ",", "76", ",", "81", ",", "82", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "75"}], ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "73"}], ",", "81", ",", "76", ",", "82", ",", 
       RowBox[{"-", "82"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", "58", ",", "83", ",", "85", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", "83", ",", "58", ",", "85", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "88"}], ",", "58", ",", "85", ",", "83", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "88"}], ",", "83", ",", "85", ",", "58", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "86"}], ",", "85", ",", "83", ",", "58", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "86"}], ",", "85", ",", "58", ",", "83", ",", 
       RowBox[{"-", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", "82", ",", "72", ",", "85", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", "72", ",", "82", ",", "85", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", "85", ",", "82", ",", "72", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", "85", ",", "72", ",", "82", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", "72", ",", "85", ",", "82", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "87"}], ",", "82", ",", "85", ",", "72", ",", 
       RowBox[{"-", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "84"}], ",", "76", ",", "88", ",", "93", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "84"}], ",", "88", ",", "76", ",", "93", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "84"}], ",", "76", ",", "93", ",", "88", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "67"}], ",", "93", ",", "76", ",", "88", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "67"}], ",", "93", ",", "88", ",", "76", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "84"}], ",", "88", ",", "93", ",", "76", ",", 
       RowBox[{"-", "85"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", 
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "85"}], ",", "88", ",", "93", ",", "97", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", 
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "85"}], ",", "93", ",", "88", ",", "97", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "70"}], ",", "97", ",", "88", ",", "93", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "70"}], ",", 
       RowBox[{"-", "85"}], ",", "93", ",", "97", ",", "88", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "70"}], ",", "97", ",", "93", ",", "88", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "70"}], ",", 
       RowBox[{"-", "85"}], ",", "88", ",", "97", ",", "93", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", "94", ",", "84", ",", "90", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", "84", ",", "94", ",", "90", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", "84", ",", "90", ",", "94", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", "90", ",", "84", ",", "94", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", "90", ",", "94", ",", "84", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "99"}], ",", "94", ",", "90", ",", "84", ",", 
       RowBox[{"-", "70"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "103"}], ",", 
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "104"}], ",", "74", ",", "94", ",", "100", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "103"}], ",", 
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "104"}], ",", "94", ",", "74", ",", "100", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "103"}], ",", "100", ",", "94", ",", "74", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "103"}], ",", 
       RowBox[{"-", "104"}], ",", "74", ",", "100", ",", "94", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "103"}], ",", 
       RowBox[{"-", "104"}], ",", "94", ",", "100", ",", "74", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "103"}], ",", "100", ",", "74", ",", "94", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", "97", ",", "99", ",", "94", ",", 
       RowBox[{"-", "102"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", "99", ",", "97", ",", "94", ",", 
       RowBox[{"-", "102"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "76"}], ",", "94", ",", "97", ",", "99", ",", 
       RowBox[{"-", "102"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "76"}], ",", "94", ",", "99", ",", "97", ",", 
       RowBox[{"-", "102"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "88"}], ",", "97", ",", "94", ",", "99", ",", 
       RowBox[{"-", "102"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "88"}], ",", "99", ",", "94", ",", "97", ",", 
       RowBox[{"-", "102"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "100"}], ",", "88", ",", "96", ",", "109", ",", 
       RowBox[{"-", "93"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "100"}], ",", "96", ",", "88", ",", "109", ",", 
       RowBox[{"-", "93"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "79"}], ",", "109", ",", "88", ",", "96", ",", 
       RowBox[{"-", "93"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "100"}], ",", "88", ",", "109", ",", "96", ",", 
       RowBox[{"-", "93"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "79"}], ",", "109", ",", "96", ",", "88", ",", 
       RowBox[{"-", "93"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "100"}], ",", "96", ",", "109", ",", "88", ",", 
       RowBox[{"-", "93"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "83"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", "89", ",", "104", ",", "105", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "83"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", "104", ",", "89", ",", "105", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "83"}], ",", 
       RowBox[{"-", "99"}], ",", "89", ",", "105", ",", "104", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "83"}], ",", "105", ",", "89", ",", "104", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "83"}], ",", "105", ",", "104", ",", "89", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "83"}], ",", 
       RowBox[{"-", "99"}], ",", "104", ",", "105", ",", "89", ",", 
       RowBox[{"-", "95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", "101", ",", "96", ",", "110", ",", 
       RowBox[{"-", "107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", "96", ",", "101", ",", "110", ",", 
       RowBox[{"-", "107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "72"}], ",", "110", ",", "96", ",", "101", ",", 
       RowBox[{"-", "107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "72"}], ",", "110", ",", "101", ",", "96", ",", 
       RowBox[{"-", "107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "98"}], ",", "96", ",", "110", ",", "101", ",", 
       RowBox[{"-", "107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "98"}], ",", "101", ",", "110", ",", "96", ",", 
       RowBox[{"-", "107"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", "109", ",", "104", ",", "104", ",", 
       RowBox[{"-", "109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", "104", ",", "109", ",", "104", ",", 
       RowBox[{"-", "109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "86"}], ",", "104", ",", "104", ",", "109", ",", 
       RowBox[{"-", "109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "86"}], ",", "104", ",", "109", ",", "104", ",", 
       RowBox[{"-", "109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "98"}], ",", "104", ",", "104", ",", "109", ",", 
       RowBox[{"-", "109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "86"}], ",", 
       RowBox[{"-", "98"}], ",", "109", ",", "104", ",", "104", ",", 
       RowBox[{"-", "109"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "122"}], ",", "92", ",", "117", ",", "110", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "122"}], ",", "117", ",", "92", ",", "110", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "122"}], ",", "92", ",", "110", ",", "117", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "119"}], ",", "110", ",", "117", ",", "92", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "122"}], ",", "117", ",", "110", ",", "92", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "119"}], ",", "110", ",", "92", ",", "117", ",", 
       RowBox[{"-", "75"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "119"}], ",", "114", ",", "104", ",", "125", ",", 
       RowBox[{"-", "105"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "119"}], ",", "104", ",", "114", ",", "125", ",", 
       RowBox[{"-", "105"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "98"}], ",", "125", ",", "104", ",", "114", ",", 
       RowBox[{"-", "105"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "119"}], ",", "104", ",", "125", ",", "114", ",", 
       RowBox[{"-", "105"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "98"}], ",", "125", ",", "114", ",", "104", ",", 
       RowBox[{"-", "105"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "119"}], ",", "114", ",", "125", ",", "104", ",", 
       RowBox[{"-", "105"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "109"}], ",", "118", ",", "123", ",", "121", ",", 
       RowBox[{"-", "129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "109"}], ",", "123", ",", "118", ",", "121", ",", 
       RowBox[{"-", "129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "94"}], ",", "121", ",", "118", ",", "123", ",", 
       RowBox[{"-", "129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "94"}], ",", "121", ",", "123", ",", "118", ",", 
       RowBox[{"-", "129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "109"}], ",", "118", ",", "121", ",", "123", ",", 
       RowBox[{"-", "129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "109"}], ",", "123", ",", "121", ",", "118", ",", 
       RowBox[{"-", "129"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "111"}], ",", 
       RowBox[{"-", "109"}], ",", "129", ",", "130", ",", "130", ",", 
       RowBox[{"-", "148"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "111"}], ",", "130", ",", "129", ",", "130", ",", 
       RowBox[{"-", "148"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "111"}], ",", 
       RowBox[{"-", "93"}], ",", "130", ",", "130", ",", "129", ",", 
       RowBox[{"-", "148"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "111"}], ",", "130", ",", "130", ",", "129", ",", 
       RowBox[{"-", "148"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "111"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "93"}], ",", "130", ",", "129", ",", "130", ",", 
       RowBox[{"-", "148"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "111"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "109"}], ",", "129", ",", "130", ",", "130", ",", 
       RowBox[{"-", "148"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "124"}], ",", 
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "142"}], ",", "112", ",", "137", ",", "145", ",", 
       RowBox[{"-", "110"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "124"}], ",", 
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "142"}], ",", "137", ",", "112", ",", "145", ",", 
       RowBox[{"-", "110"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "124"}], ",", 
       RowBox[{"-", "142"}], ",", "112", ",", "145", ",", "137", ",", 
       RowBox[{"-", "110"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "124"}], ",", "145", ",", "137", ",", "112", ",", 
       RowBox[{"-", "110"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "124"}], ",", 
       RowBox[{"-", "142"}], ",", "137", ",", "145", ",", "112", ",", 
       RowBox[{"-", "110"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "124"}], ",", "145", ",", "112", ",", "137", ",", 
       RowBox[{"-", "110"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "113"}], ",", 
       RowBox[{"-", "129"}], ",", 
       RowBox[{"-", "119"}], ",", "134", ",", "139", ",", "140", ",", 
       RowBox[{"-", "145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "113"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "129"}], ",", "139", ",", "134", ",", "140", ",", 
       RowBox[{"-", "145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "129"}], ",", 
       RowBox[{"-", "113"}], ",", "140", ",", "139", ",", "134", ",", 
       RowBox[{"-", "145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "113"}], ",", 
       RowBox[{"-", "129"}], ",", "139", ",", "140", ",", "134", ",", 
       RowBox[{"-", "145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "129"}], ",", 
       RowBox[{"-", "113"}], ",", 
       RowBox[{"-", "119"}], ",", "134", ",", "140", ",", "139", ",", 
       RowBox[{"-", "145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "129"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "113"}], ",", "140", ",", "134", ",", "139", ",", 
       RowBox[{"-", "145"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "134"}], ",", "138", ",", "143", ",", "128", ",", 
       RowBox[{"-", "131"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "134"}], ",", "143", ",", "138", ",", "128", ",", 
       RowBox[{"-", "131"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "114"}], ",", "128", ",", "138", ",", "143", ",", 
       RowBox[{"-", "131"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "114"}], ",", "128", ",", "143", ",", "138", ",", 
       RowBox[{"-", "131"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "134"}], ",", "138", ",", "128", ",", "143", ",", 
       RowBox[{"-", "131"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "134"}], ",", 
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "134"}], ",", "143", ",", "128", ",", "138", ",", 
       RowBox[{"-", "131"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", "137", ",", "147", ",", "155", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", "147", ",", "137", ",", "155", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", "155", ",", "137", ",", "147", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", "137", ",", "155", ",", "147", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "157"}], ",", "147", ",", "155", ",", "137", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "157"}], ",", 
       RowBox[{"-", "139"}], ",", "155", ",", "147", ",", "137", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "165"}], ",", 
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "168"}], ",", "120", ",", "152", ",", "163", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "165"}], ",", 
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "168"}], ",", "152", ",", "120", ",", "163", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "165"}], ",", "163", ",", "152", ",", "120", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "165"}], ",", 
       RowBox[{"-", "168"}], ",", "120", ",", "163", ",", "152", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "165"}], ",", 
       RowBox[{"-", "168"}], ",", "152", ",", "163", ",", "120", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "168"}], ",", 
       RowBox[{"-", "165"}], ",", "163", ",", "120", ",", "152", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "166"}], ",", 
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "178"}], ",", "148", ",", "173", ",", "160", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "166"}], ",", 
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "178"}], ",", "173", ",", "148", ",", "160", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "166"}], ",", 
       RowBox[{"-", "178"}], ",", "148", ",", "160", ",", "173", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "166"}], ",", "160", ",", "148", ",", "173", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "166"}], ",", "160", ",", "173", ",", "148", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "178"}], ",", 
       RowBox[{"-", "166"}], ",", 
       RowBox[{"-", "178"}], ",", "173", ",", "160", ",", "148", ",", 
       RowBox[{"-", "125"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "169"}], ",", 
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "184"}], ",", "136", ",", "176", ",", "183", ",", 
       RowBox[{"-", "127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "169"}], ",", 
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "184"}], ",", "176", ",", "136", ",", "183", ",", 
       RowBox[{"-", "127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "169"}], ",", 
       RowBox[{"-", "184"}], ",", "136", ",", "183", ",", "176", ",", 
       RowBox[{"-", "127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "169"}], ",", 
       RowBox[{"-", "184"}], ",", "176", ",", "183", ",", "136", ",", 
       RowBox[{"-", "127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "169"}], ",", "183", ",", "176", ",", "136", ",", 
       RowBox[{"-", "127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "169"}], ",", "183", ",", "136", ",", "176", ",", 
       RowBox[{"-", "127"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "138"}], ",", 
       RowBox[{"-", "159"}], ",", 
       RowBox[{"-", "149"}], ",", "174", ",", "179", ",", "185", ",", 
       RowBox[{"-", "200"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "138"}], ",", 
       RowBox[{"-", "149"}], ",", 
       RowBox[{"-", "159"}], ",", "179", ",", "174", ",", "185", ",", 
       RowBox[{"-", "200"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "149"}], ",", 
       RowBox[{"-", "159"}], ",", 
       RowBox[{"-", "138"}], ",", "185", ",", "179", ",", "174", ",", 
       RowBox[{"-", "200"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "149"}], ",", 
       RowBox[{"-", "138"}], ",", 
       RowBox[{"-", "159"}], ",", "179", ",", "185", ",", "174", ",", 
       RowBox[{"-", "200"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "159"}], ",", 
       RowBox[{"-", "138"}], ",", 
       RowBox[{"-", "149"}], ",", "174", ",", "185", ",", "179", ",", 
       RowBox[{"-", "200"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "159"}], ",", 
       RowBox[{"-", "149"}], ",", 
       RowBox[{"-", "138"}], ",", "185", ",", "174", ",", "179", ",", 
       RowBox[{"-", "200"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "164"}], ",", 
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "194"}], ",", "218", ",", "223", ",", "218", ",", 
       RowBox[{"-", "241"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "164"}], ",", 
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "194"}], ",", "223", ",", "218", ",", "218", ",", 
       RowBox[{"-", "241"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "164"}], ",", "218", ",", "218", ",", "223", ",", 
       RowBox[{"-", "241"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "164"}], ",", "218", ",", "223", ",", "218", ",", 
       RowBox[{"-", "241"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "164"}], ",", 
       RowBox[{"-", "194"}], ",", "218", ",", "218", ",", "223", ",", 
       RowBox[{"-", "241"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "164"}], ",", 
       RowBox[{"-", "194"}], ",", "223", ",", "218", ",", "218", ",", 
       RowBox[{"-", "241"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "199"}], ",", 
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "232"}], ",", "184", ",", "224", ",", "241", ",", 
       RowBox[{"-", "185"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "199"}], ",", 
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "232"}], ",", "224", ",", "184", ",", "241", ",", 
       RowBox[{"-", "185"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "199"}], ",", 
       RowBox[{"-", "232"}], ",", "184", ",", "241", ",", "224", ",", 
       RowBox[{"-", "185"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "199"}], ",", 
       RowBox[{"-", "232"}], ",", "224", ",", "241", ",", "184", ",", 
       RowBox[{"-", "185"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "199"}], ",", "241", ",", "224", ",", "184", ",", 
       RowBox[{"-", "185"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "232"}], ",", 
       RowBox[{"-", "199"}], ",", "241", ",", "184", ",", "224", ",", 
       RowBox[{"-", "185"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "206"}], ",", 
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "233"}], ",", "243", ",", "218", ",", "245", ",", 
       RowBox[{"-", "225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "206"}], ",", 
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "233"}], ",", "218", ",", "243", ",", "245", ",", 
       RowBox[{"-", "225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "206"}], ",", 
       RowBox[{"-", "233"}], ",", "243", ",", "245", ",", "218", ",", 
       RowBox[{"-", "225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "206"}], ",", "245", ",", "218", ",", "243", ",", 
       RowBox[{"-", "225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "206"}], ",", 
       RowBox[{"-", "233"}], ",", "218", ",", "245", ",", "243", ",", 
       RowBox[{"-", "225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "233"}], ",", 
       RowBox[{"-", "206"}], ",", "245", ",", "243", ",", "218", ",", 
       RowBox[{"-", "225"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "203"}], ",", 
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "248"}], ",", "224", ",", "240", ",", "245", ",", 
       RowBox[{"-", "213"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "203"}], ",", 
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "248"}], ",", "240", ",", "224", ",", "245", ",", 
       RowBox[{"-", "213"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "203"}], ",", "245", ",", "224", ",", "240", ",", 
       RowBox[{"-", "213"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "203"}], ",", "245", ",", "240", ",", "224", ",", 
       RowBox[{"-", "213"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "203"}], ",", 
       RowBox[{"-", "248"}], ",", "224", ",", "245", ",", "240", ",", 
       RowBox[{"-", "213"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "248"}], ",", 
       RowBox[{"-", "203"}], ",", 
       RowBox[{"-", "248"}], ",", "240", ",", "245", ",", "224", ",", 
       RowBox[{"-", "213"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.670242856424058*^9, 3.670242863850728*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Inequalities for the causal structure relevant for the information causality \
game (classical case)\
\>", "Subsection",
 CellChangeTimes->{{3.716206591493862*^9, 3.7162066318442492`*^9}, {
  3.716210143550262*^9, 3.716210146414287*^9}}],

Cell[TextData[{
 "In the following we provide the inequalities from the calculations of \
Section III C of the article \[OpenCurlyDoubleQuote]Non - Shannon \
inequalities in the entropy vector approach to causal structures\
\[CloseCurlyDoubleQuote]. These inequalities are of the form a H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + b H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "1"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + c H (Z) + d H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["Y", 
     RowBox[{
      RowBox[{"|", "R"}], "=", "0"}]]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + e H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["Y", 
     RowBox[{
      RowBox[{"|", "R"}], "=", "1"}]]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + f H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + g H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z) + h H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + i H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + j H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "1"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z) + k H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "1"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + l H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "1"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + m H (Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + n H (Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + o H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z) + p H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + q H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + r H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + s H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + t H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "1"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + u H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "1"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + v H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "0"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") + w H ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["X", "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Z ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", 
    RowBox[{
     RowBox[{"|", "R"}], "=", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ")  >= 0. The coefficients a, b, ..., w of all irredundant inequalities are \
in the following listed as the rows of a matrix."
}], "Text",
 CellChangeTimes->{{3.7162071148661013`*^9, 3.7162071148671103`*^9}, {
  3.716207173400959*^9, 3.716207191118122*^9}, {3.7162075340811224`*^9, 
  3.7162079736833725`*^9}, {3.7162080754537163`*^9, 3.7162081865103445`*^9}, {
  3.716208522148324*^9, 3.7162085308863335`*^9}, {3.7162096427438717`*^9, 
  3.7162099123900013`*^9}, {3.716210015259184*^9, 3.716210017394547*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"infcaus", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "12", ",", "6", ",", 
       "13", ",", "15", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "6", ",", "12", ",", "15", ",", 
       "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "13", ",", "15", ",", 
       "12", ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "15", ",", "13", ",", "6", ",", 
       "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "13", ",", "15", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "15", ",", "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", 
       "12", ",", "13", ",", "15", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", "12",
        ",", "15", ",", "13", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "9", ",", "13", ",", "15", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "12", ",", "6", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "9", ",", "15", ",", "13", ",", 
       "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "12", ",", "13", ",", "15", ",", 
       "1", ",", "12", ",", "6", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "12", ",", "15", ",", "13", ",", 
       "1", ",", "6", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "12", ",", "6", ",", 
       "13", ",", "15", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "6", ",", "12", ",", "15", ",", 
       "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "13", ",", "15", ",", 
       "12", ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "15", ",", "13", ",", "6", ",", 
       "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "13", ",", "15", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "15", ",", "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", 
       "12", ",", "13", ",", "15", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", "12",
        ",", "15", ",", "13", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "9", ",", "13", ",", "15", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "12", ",", "6", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "9", ",", "15", ",", "13", ",", 
       "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "12", ",", "13", ",", "15", ",", 
       "1", ",", "12", ",", "6", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "12", ",", "15", ",", "13", ",", 
       "1", ",", "6", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "6", ",", "12", ",", "7",
        ",", "21", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "12", ",", "6", ",", "21", ",", "7",
        ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "7", ",", "21", ",", "6",
        ",", "12", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "21", ",", "7", ",", "12", ",", "6",
        ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "7", ",", "21", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "21", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", 
       "12", ",", "7", ",", "21", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", "12",
        ",", "21", ",", "7", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "9", ",", "7", ",", "21", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "6", ",", "12", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "9", ",", "21", ",", "7", ",", "1",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "12", ",", "6", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "12", ",", "7", ",", "21", ",", 
       "1", ",", "6", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "12", ",", "21", ",", "7", ",", "1",
        ",", "12", ",", "6", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "6", ",", "12", ",", "7",
        ",", "21", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "12", ",", "6", ",", "21", ",", "7",
        ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "7", ",", "21", ",", "6",
        ",", "12", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "21", ",", "7", ",", "12", ",", "6",
        ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "7", ",", "21", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "21", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", 
       "12", ",", "7", ",", "21", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", "12",
        ",", "21", ",", "7", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "9", ",", "7", ",", "21", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "6", ",", "12", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "9", ",", "21", ",", "7", ",", "1",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "12", ",", "6", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "12", ",", "7", ",", "21", ",", 
       "1", ",", "6", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "12", ",", "21", ",", "7", ",", "1",
        ",", "12", ",", "6", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", "10", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "1", ",", "16", ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "21", ",", "13", ",", "3", ",", "3",
        ",", "0", ",", 
       RowBox[{"-", "19"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", "10", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "1", ",", "16", ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "21", ",", "13", ",", "3", ",", "3",
        ",", "0", ",", 
       RowBox[{"-", "19"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "2", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "2", ",", "0", ",", "1", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "2", ",", "1", ",", "0", ",", "1", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "11"}], ",", "1", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "15", ",", "7", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "2", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "2", ",", "0", ",", "1", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "2", ",", "1", ",", "0", ",", "1", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "1", ",", "0", ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "1", ",", "1", 
       ",", "0", ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "0", ",", "3", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "0", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "3", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", "3", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "0", ",", "1", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "1", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "3", ",", "0", ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", "3", ",", "3", 
       ",", "0", ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "0", ",", "3", 
       ",", "0", ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "1", ",", "1", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "0", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "0", ",", "3", ",", "1", 
       ",", "0", ",", "3", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "1", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", "3", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "1", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "2", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "1", ",", "0", 
       ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "2", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "2", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "3", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "2", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "3", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "2", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "2", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "2", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "3", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "2", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "2", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "2", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "3", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "0", ",", "0", ",", "3", 
       ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", "3", ",", "2", ",", "0", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", "0", ",", "2", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", "0", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "2", ",", "0", 
       ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "1", ",", "0", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", "0", 
       ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", "0", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "3", ",", "0", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "2", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "1", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "2", ",", "6", ",", "2", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "6", ",", "2", ",", "6", ",", "2", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "2", ",", "6", ",", "2", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "6", ",", "2", ",", "6", ",", "2", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "2", ",", "6", ",", "2", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "6", ",", "2", ",", "6", ",", "2", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "2", ",", "6", ",", "2", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "6", ",", "2", ",", "6", ",", "2", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "3", ",", "3", ",", "2", ",", "6", ",", "3", 
       ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "2", 
       ",", "3", ",", "6", ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "12", ",", "6", ",", 
       "13", ",", "15", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "6", ",", "12", ",", "15", ",", 
       "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "13", ",", "15", ",", 
       "12", ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "15", ",", "13", ",", "6", ",", 
       "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "12", ",", "6", ",", 
       "13", ",", "15", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "13", ",", "15", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "6", ",", "12", ",", "15", ",", 
       "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "15", ",", "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "13", ",", "15", ",", 
       "12", ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", 
       "12", ",", "13", ",", "15", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "15", ",", "13", ",", "6", ",", 
       "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", "12",
        ",", "15", ",", "13", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "13", ",", "15", ",", "0", ",", 
       "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "9", ",", "13", ",", "15", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "12", ",", "6", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "9", ",", "15", ",", "13", ",", 
       "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "15", ",", "13", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", 
       "12", ",", "13", ",", "15", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "12", ",", "13", ",", "15", ",", 
       "1", ",", "12", ",", "6", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", "12",
        ",", "15", ",", "13", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "12", ",", "15", ",", "13", ",", 
       "1", ",", "6", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "12", ",", "9", ",", "13", ",", "15", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "12", ",", "6", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "12", ",", "9", ",", "15", ",", "13", ",", 
       "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "6", ",", "12", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", "9", ",", "12", ",", "13", ",", "15", ",", 
       "1", ",", "12", ",", "6", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "4"}], ",", "9", ",", "12", ",", "15", ",", "13", ",", 
       "1", ",", "6", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "6", ",", "12", ",", "7",
        ",", "21", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "12", ",", "6", ",", "21", ",", "7",
        ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "7", ",", "21", ",", "6",
        ",", "12", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "21", ",", "7", ",", "12", ",", "6",
        ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "7", ",", "21", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "21", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", 
       "12", ",", "7", ",", "21", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", "12",
        ",", "21", ",", "7", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "9", ",", "7", ",", "21", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "6", ",", "12", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "9", ",", "21", ",", "7", ",", "1",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "12", ",", "6", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "12", ",", "7", ",", "21", ",", 
       "1", ",", "6", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "12", ",", "21", ",", "7", ",", "1",
        ",", "12", ",", "6", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "6", ",", "12", ",", "7",
        ",", "21", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "12", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "12", ",", "6", ",", "21", ",", "7",
        ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "9", ",", "7", ",", "21", ",", "6",
        ",", "12", ",", "0", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "9", ",", "21", ",", "7", ",", "12", ",", "6",
        ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "1", ",", "9", ",", "6", ",", "12", ",", 
       "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "7", ",", "21", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "9", ",", "12", ",", "6", ",", "12",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "21", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "1", ",", "6", ",", "12", ",", 
       "12", ",", "7", ",", "21", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "12", ",", "6", ",", "12",
        ",", "21", ",", "7", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "12", ",", "9", ",", "7", ",", "21", ",", 
       "1", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "6", ",", "12", ",", "0", ",", "0",
        ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "9", ",", "21", ",", "7", ",", "1",
        ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "12", ",", "6", ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "13"}], ",", "9", ",", "12", ",", "7", ",", "21", ",", 
       "1", ",", "6", ",", "12", ",", 
       RowBox[{"-", "5"}], ",", "13", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "12", ",", "21", ",", "7", ",", "1",
        ",", "12", ",", "6", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", "6", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "16", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0", ",", "9", ",", "9", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", "6", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", "6", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", "6", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", "6", 
       ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0", ",", "9", ",", "9", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "4"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", "6", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "16", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "11"}], ",", "1", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "15", ",", "7", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "2", ",", "6", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "7", ",", "3", ",", "6", 
       ",", "2", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "7", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "6", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "7", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", "1", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "12", ",", "4", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "2", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "2", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "3", ",", "7", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "7", ",", "3", ",", "7", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "3", ",", "7", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "7", ",", "3", ",", "7", 
       ",", "3", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "7", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "6", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "0", ",", "3", ",", "7", 
       ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", "3", ",", "0", ",", "7", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "6", ",", "3", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "6", ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "3", ",", "0", ",", "4", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0", ",", "3", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "6", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "6", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "2", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "2", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "7", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "1", ",", "0", ",", "4", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "3", ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "2", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "3", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "2", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "2", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "2", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "2", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", "3", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", "3", ",", "2", ",", "0", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", "0", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "2", ",", "0", 
       ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", "0", 
       ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "3", ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "2", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "2", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "2", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "2", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "2", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", "1", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "1", ",", "13", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "12", ",", "4", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "16"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "2", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "1", ",", "0", ",", "4", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "3", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "3", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "7", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "3", ",", "3", 
       ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "7", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "3", ",", "3", 
       ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "7", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "3", ",", "0", ",", "4", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "4", 
       ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "3", ",", "0", ",", "4", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "4", 
       ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", "7", ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "2", ",", "1", ",", "0", ",", "3", 
       ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "2", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "1", ",", "2", ",", "0", ",", "3", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "1", 
       ",", "2", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "8", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "12", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "9"}], ",", "1", ",", "6", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", "4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "8", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "2"}], ",", "12", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "9", ",", "1", ",", "6", 
       ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "7"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "7", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "6", ",", "4", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "6", ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "0", ",", "4", ",", "6", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "0", ",", "4", ",", "6", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "6", ",", "4", ",", "1", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "6", ",", "4", ",", "1", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "4", ",", "6", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "4", ",", "6", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "6", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "6", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "1"}], ",", "4", ",", "4", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "6", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "1"}], ",", "4", ",", "4", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "4", ",", "4", 
       ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "4", ",", "4", 
       ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "4", ",", "4", 
       ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "6", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", "4", ",", "4", 
       ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "4", ",", "6", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "4", ",", "6", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "6", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "6", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "6", ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "1", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "4", 
       ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "4", 
       ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "1", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "4", ",", "6", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "4", ",", "6", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "6", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "1", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "6", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "6", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "6", ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "3", 
       ",", "6", ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "0", ",", "4", ",", "6", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "0", ",", "4", ",", "6", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "6", ",", "4", ",", "1", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "6", ",", "4", ",", "1", 
       ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "4", ",", "6", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "4", ",", "6", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "6", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "6", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "3", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "6", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "4", ",", "4", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "7", ",", "7", ",", "9", 
       ",", "9", ",", "0", ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "7", ",", "7", ",", "9", 
       ",", "9", ",", "0", ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "4", ",", "4", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "9", ",", "9", ",", "7", ",", "7", 
       ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "15", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "9", ",", "9", ",", "7", ",", "7", 
       ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "9", ",", "9", ",", "7", 
       ",", "7", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "9", ",", "9", ",", "7", 
       ",", "7", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "4", ",", "4", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", "5", 
       ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "9", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "9"}], ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "15", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", "5", 
       ",", 
       RowBox[{"-", "1"}], ",", "9", ",", "9", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "9"}], ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "9", ",", "9", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "9", ",", "9", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "6", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "4", ",", "4", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", "0", ",", "9", ",", "9", 
       ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "15", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", "0", ",", "9", ",", "9", 
       ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", "0", ",", "9", ",", "9", 
       ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", "0", ",", "9", ",", "9", 
       ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", "7", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0", ",", "15", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", "7", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "7", ",", "7", ",", "0", ",", "6", 
       ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "7", ",", "7", ",", "0", ",", "6", 
       ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "0", ",", "0", ",", "15", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "0", ",", "0", ",", "0", ",", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", "9", ",", "9", ",", 
       RowBox[{"-", "3"}], ",", "7", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "15", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "7", ",", "7", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "7", ",", "7", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", "5", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "9"}], ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "15", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", "5", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "9"}], ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "9", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "6", ",", 
       RowBox[{"-", "6"}], ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "4", ",", "4", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "12"}], ",", "0", ",", "7", ",", "7", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "9"}], ",", "6", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "3", ",", "4", ",", "4", ",", "3", 
       ",", "6", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "7", ",", "7", ",", "9", ",", "9", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "15", ",", 
       RowBox[{"-", "15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "7", ",", "7", ",", "9", ",", "9", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", 
       RowBox[{"-", "9"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "3", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", "5", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "0", ",", "0", ",", "3", 
       ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", "0", ",", "2", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "2", ",", "0", ",", "1", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "3", ",", "1", ",", "0", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "2", ",", "3", ",", "0", ",", "0", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "1", ",", "3", ",", "0", ",", "1", 
       ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "2", ",", "1", ",", "0", ",", "3", 
       ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "2", 
       ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "1", ",", "2", ",", "0", ",", "3", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "3", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "3", ",", "1", 
       ",", "2", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "2", ",", "6", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "5", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "7", ",", "3", ",", "6", 
       ",", "2", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "3", ",", "7", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "6", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "5", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "7", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "2", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "2", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", "7", ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "6", ",", "4", ",", "3", ",", "1", 
       ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "3", ",", "7", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "7", ",", "3", ",", "7", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "3", ",", "7", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "6", ",", "7", ",", "3", ",", "7", 
       ",", "3", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "3", ",", "7", ",", "0", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "6", ",", "7", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "6", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "0", ",", "3", ",", "7", 
       ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", "3", ",", "0", ",", "7", ",", "3", 
       ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "6", ",", "3", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "6", ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "3", ",", "0", ",", "4", 
       ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0", ",", "3", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0", ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "7", ",", "3", ",", 
       RowBox[{"-", "1"}], ",", "3", ",", "0", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "3"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "3", ",", "3", ",", "0", ",", "2", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "3", ",", "3", ",", "4", 
       ",", "4", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "3", ",", "3", ",", "4", ",", "4", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "4", ",", "4", ",", "3", 
       ",", "3", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "4", ",", "4", ",", "3", ",", "3", 
       ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "4", ",", "4", ",", "0", ",", "0", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "3", ",", "3", ",", "0", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "4", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "3", ",", "3", ",", "0", 
       ",", "4", ",", "4", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "3", ",", "3", ",", "0", ",", "1", 
       ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "3", ",", "3", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", "4", ",", "1", 
       ",", "3", ",", "3", ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", 
       RowBox[{"-", "4"}], ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "5", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "5", ",", "4", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "4", ",", 
       RowBox[{"-", "2"}], ",", "0", ",", "5", ",", "4", ",", "0", ",", "0", 
       ",", "0", ",", 
       RowBox[{"-", "5"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712927824607945*^9, 3.7129278592641087`*^9}, {
   3.716205710429849*^9, 3.7162057123415003`*^9}, 3.7162065891433487`*^9}]
}, Open  ]]
},
WindowSize->{1263, 547},
WindowMargins->{{68, Automatic}, {Automatic, 201}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 242, 3, 45, "Subsection"],
Cell[825, 27, 814, 12, 71, "Text"],
Cell[1642, 41, 46790, 1327, 1132, "Input"],
Cell[48435, 1370, 130796, 3684, 3312, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179268, 5059, 247, 5, 45, "Subsection"],
Cell[179518, 5066, 6599, 263, 126, "Text"],
Cell[186120, 5331, 476346, 11521, 20192, "Input"]
}, Open  ]]
}
]
*)

