/*
 * Decompiled with CFR 0.152.
 */
package buildIntelligentProxy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class BuildProxy {
    private static String proxyName;
    private static String packageName;
    private static ArrayList<String> proxyMethodSignatures;
    private static ArrayList<String> URLs;
    private static ArrayList<ArrayList<String>> serviceMethodNames;
    private static String outputDir;
    private static ArrayList<String> pathName;
    private static String JAVA_HOME;
    private static String AXIS2_HOME;
    private static String w2jCommand;
    private static ArrayList<Integer> serviceMethodParameters;
    private static ArrayList<String> serviceMethodReturnType;

    private static void deletefile(String file) {
        File f1 = new File(file);
        boolean success = f1.delete();
        if (!success) {
            System.out.println("Deletion failed. " + file);
        } else {
            System.out.println("File deleted. " + file);
        }
    }

    private static void parseConfigEnv(String envCfgFilePath) {
        JAVA_HOME = "";
        try {
            FileInputStream fstream = new FileInputStream(envCfgFilePath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = br.readLine();
            if (strLine != null) {
                JAVA_HOME = strLine;
            }
            System.out.println(JAVA_HOME);
            strLine = br.readLine();
            if (strLine != null) {
                AXIS2_HOME = "AXIS2_HOME=" + System.getProperty("user.dir") + strLine;
                System.out.println(AXIS2_HOME);
            }
            if ((strLine = br.readLine()) != null) {
                w2jCommand = strLine;
            }
            System.out.println(w2jCommand);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private static void parseConfig(String cfgFilePath) {
        proxyName = "";
        packageName = "";
        proxyMethodSignatures = new ArrayList();
        URLs = new ArrayList();
        serviceMethodNames = new ArrayList();
        try {
            FileInputStream fstream = new FileInputStream(cfgFilePath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = br.readLine();
            if (strLine != null) {
                proxyName = strLine;
            }
            if ((strLine = br.readLine()) != null) {
                packageName = strLine;
                while ((strLine = br.readLine()) != null && !strLine.equals("")) {
                    proxyMethodSignatures.add(strLine);
                }
            }
            serviceMethodParameters = new ArrayList();
            serviceMethodReturnType = new ArrayList();
            int i = 0;
            while (i < proxyMethodSignatures.size()) {
                System.out.println(proxyMethodSignatures.get(i));
                String[] str = BuildProxy.getArgList(proxyMethodSignatures.get(i));
                int numParameters = (str.length - 2) / 2;
                System.out.println("numParameters = " + numParameters);
                serviceMethodParameters.add(numParameters);
                serviceMethodReturnType.add(str[0]);
                ++i;
            }
            i = 0;
            while (i < proxyMethodSignatures.size()) {
                System.out.println(proxyMethodSignatures.get(i));
                ++i;
            }
            do {
                String serviceWsdlUrl = br.readLine();
                ArrayList<String> webServiceMethodSignatures = new ArrayList<String>();
                while ((strLine = br.readLine()) != null && !strLine.equals("")) {
                    webServiceMethodSignatures.add(strLine);
                }
                serviceMethodNames.add(webServiceMethodSignatures);
                URLs.add(serviceWsdlUrl);
            } while (strLine != null);
            in.close();
            i = 0;
            while (i < serviceMethodNames.size()) {
                int j = 0;
                while (j < serviceMethodNames.get(i).size()) {
                    System.out.println(String.valueOf(URLs.get(i)) + " " + serviceMethodNames.get(i).get(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private static String stubNameFromWsdlUrl(String wsdlUrl) {
        int start = wsdlUrl.lastIndexOf("/") + 1;
        int end = wsdlUrl.lastIndexOf("?");
        String result = wsdlUrl.substring(start, end);
        return result;
    }

    private static String[] getArgList(String methodSignature) {
        String str = methodSignature;
        String delims = "[(,) ]+";
        String[] tokens = str.split(delims);
        return tokens;
    }

    private static void generateIntelligentProxy() throws Exception, IOException {
        String[] str;
        BufferedWriter out = null;
        String proxyFile = String.valueOf(outputDir) + "/" + proxyName + ".java";
        BuildProxy.deletefile(proxyFile);
        try {
            FileWriter fstream = new FileWriter(proxyFile, true);
            out = new BufferedWriter(fstream);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        out.write("package " + packageName + ";");
        out.newLine();
        out.newLine();
        out.write("import org.apache.axis2.addressing.EndpointReference;");
        out.newLine();
        out.write("import org.apache.log4j.*;");
        out.newLine();
        out.write("import java.util.*;");
        out.newLine();
        out.write("import ipSupportTool.*;");
        out.newLine();
        out.newLine();
        out.write("// The namespaces for the concrete services (NB: these are application specific!)");
        out.newLine();
        String nam = String.valueOf(outputDir) + "/build/classes";
        File aFile = new File(nam);
        pathName = BuildProxy.Process2(aFile);
        int i = 0;
        while (i < pathName.size()) {
            out.write("import " + pathName.get(i).substring(8) + ".*;");
            out.newLine();
            ++i;
        }
        out.newLine();
        out.newLine();
        out.write("// The Intelligent Proxy class");
        out.newLine();
        out.write("public class " + proxyName + " extends IPSupport{");
        out.newLine();
        out.newLine();
        out.write("   // The actual stubs (NB: these are application specific!)");
        out.newLine();
        i = 1;
        while (i <= URLs.size()) {
            out.write("   private ");
            out.write(BuildProxy.stubNameFromWsdlUrl(URLs.get(i - 1)));
            out.write("Stub stub" + i + ";");
            out.newLine();
            ++i;
        }
        out.newLine();
        out.write("   // Setup the log4j logger ");
        out.newLine();
        out.write("   static Logger logger = Logger.getLogger(\"\");");
        out.newLine();
        out.newLine();
        out.write("   // Create a Model updater");
        out.newLine();
        out.write("   private Model model; ");
        out.newLine();
        out.newLine();
        out.newLine();
        out.write("   // Constructor (NB: these are application specific!)");
        out.newLine();
        out.write("   public " + proxyName + "(String methodName, String prefix, Model model) throws Exception {");
        out.newLine();
        out.newLine();
        out.write("    \t super(methodName, prefix);");
        out.newLine();
        out.newLine();
        out.write("         //1. Initialise the Model updater with the initial model provided");
        out.newLine();
        out.write("          this.model = model; ");
        out.newLine();
        out.newLine();
        out.write("       // 2. Initialise stubs for each concrete service");
        out.newLine();
        i = 1;
        while (i <= URLs.size()) {
            out.write("       // 2." + i + " Initialise stub for web service number " + i);
            out.newLine();
            out.write("       stub" + i);
            out.write(" = new ");
            out.write(String.valueOf(BuildProxy.stubNameFromWsdlUrl(URLs.get(i - 1))) + "Stub();");
            out.newLine();
            out.write("       EndpointReference targetEpr" + i + " = new EndpointReference(" + '\"' + URLs.get(i - 1) + '\"' + ");");
            out.newLine();
            out.write("       stub" + i + "._getServiceClient().setTargetEPR(targetEpr" + i + ");");
            out.newLine();
            out.newLine();
            ++i;
        }
        out.write("       // 3. Create the service array");
        out.newLine();
        out.write("       // 3.1. Instantiate array");
        out.newLine();
        out.write("       services = new Service[" + URLs.size() + "];");
        out.newLine();
        out.write("       // 3.2. Declare arrays of abstract web method names, costs and a priory success rates");
        out.newLine();
        out.write("       String[] methodNames;");
        out.newLine();
        out.write("       double[] costs;");
        out.newLine();
        out.write("       double[] aPrioriSuccessRates;");
        out.newLine();
        out.newLine();
        out.write("       // 3.3. Instantiate services");
        out.newLine();
        i = 0;
        while (i < serviceMethodNames.size()) {
            String a = "";
            String b = "";
            String c = "";
            int j = 0;
            while (j < serviceMethodNames.get(i).size()) {
                if (!serviceMethodNames.get(i).get(j).equals("-")) {
                    if (a.length() > 0) {
                        a = String.valueOf(a) + ", ";
                        b = String.valueOf(b) + ", ";
                        c = String.valueOf(c) + ", ";
                    }
                    String[] tmp = BuildProxy.getArgList(proxyMethodSignatures.get(j));
                    a = String.valueOf(a) + "\"" + tmp[1] + "\"";
                    b = String.valueOf(b) + "0.45";
                    c = String.valueOf(c) + "0.958";
                }
                ++j;
            }
            int v = i + 1;
            out.write("       // 3.3." + v + ". Instantiate service " + v);
            out.newLine();
            out.write("       methodNames = new String[] { " + a + " };");
            out.newLine();
            out.write("       costs = new double[] { " + b + " };");
            out.newLine();
            out.write("       aPrioriSuccessRates = new double[] { " + c + " };");
            out.newLine();
            out.write("       services[" + i + "] = new Service(methodNames, costs, aPrioriSuccessRates);");
            out.newLine();
            out.newLine();
            ++i;
        }
        out.write("       // 4. Instantiate the SLAs for the abstract methods, indices for the abstract methods and the last service index hashmap");
        out.newLine();
        out.write("       slas = new HashMap<String,MethodSLA>();");
        out.newLine();
        i = 0;
        while (i < proxyMethodSignatures.size()) {
            str = BuildProxy.getArgList(proxyMethodSignatures.get(i));
            out.write("       slas.put(\"" + str[1] + "\", new MethodSLA(0.0, Double.MAX_VALUE)); // anything is acceptable until the client tells otherwise");
            out.newLine();
            ++i;
        }
        out.write("\t}");
        out.newLine();
        out.newLine();
        i = 0;
        while (i < proxyMethodSignatures.size()) {
            str = BuildProxy.getArgList(proxyMethodSignatures.get(i));
            out.write("   // Abstract web method \"" + str[1] + "\" ");
            out.newLine();
            out.write("   public " + proxyMethodSignatures.get(i) + " throws Exception {");
            out.newLine();
            out.newLine();
            out.write("        //1. Update the model updater class");
            out.newLine();
            out.write("        model.nextInvocation(\"sendAlarm\");");
            out.newLine();
            out.newLine();
            out.write("       // 2. Remember index of used concrete service");
            out.newLine();
            out.write("      int serviceIndex = getServiceIndex(\"" + str[1] + "\");");
            out.newLine();
            out.newLine();
            out.write("      // 3. Local variable for result");
            out.newLine();
            out.write("           " + serviceMethodReturnType.get(i) + " result;");
            out.newLine();
            out.newLine();
            out.write("      // 4. Use the identified concrete service");
            out.newLine();
            out.write("      try{");
            out.newLine();
            out.write("         // 4.1. Invoke web method");
            out.newLine();
            out.write("         switch (serviceIndex) {");
            out.newLine();
            int lastServiceThatHasMethod = 0;
            int j = 1;
            while (j <= URLs.size()) {
                if (!serviceMethodNames.get(j - 1).get(i).equals("-")) {
                    lastServiceThatHasMethod = j;
                }
                ++j;
            }
            j = 1;
            while (j <= URLs.size()) {
                String webMethodName = serviceMethodNames.get(j - 1).get(i);
                if (!webMethodName.equals("-")) {
                    String className = String.valueOf(BuildProxy.stubNameFromWsdlUrl(URLs.get(j - 1))) + "Stub";
                    String webMethodNameUpperCase = serviceMethodNames.get(j - 1).get(i);
                    char[] stringArray = webMethodNameUpperCase.toCharArray();
                    stringArray[0] = Character.toUpperCase(stringArray[0]);
                    webMethodNameUpperCase = new String(stringArray);
                    out.newLine();
                    if (j < lastServiceThatHasMethod) {
                        int j_minus_1 = j - 1;
                        out.write("         case " + j_minus_1 + ": ");
                    } else {
                        out.write("         default:");
                    }
                    out.newLine();
                    out.write("             //create the request");
                    out.newLine();
                    int numParam2 = serviceMethodParameters.get(i);
                    if (numParam2 > 0) {
                        out.write("             " + className + "." + webMethodNameUpperCase + " request" + j + " = new " + className + "." + webMethodNameUpperCase + "();");
                        out.newLine();
                        int r = 0;
                        while (r < numParam2) {
                            out.write("             request" + j + ".setArgs" + r + "(a" + r + ");");
                            out.newLine();
                            ++r;
                        }
                        out.newLine();
                        out.write("             //Invoke the service");
                        out.newLine();
                        out.write("             " + className + "." + webMethodNameUpperCase + "Response response" + j + " = stub" + j + "." + webMethodName + "(request" + j + ");");
                    } else {
                        out.write("             //Invoke the service");
                        out.newLine();
                        out.write("             " + className + "." + webMethodNameUpperCase + "Response response" + j + " = stub" + j + "." + webMethodName + "();");
                    }
                    out.newLine();
                    out.newLine();
                    out.write("             // Return the result");
                    out.newLine();
                    out.write("             result = response" + j + ".get_return();");
                    out.newLine();
                    out.newLine();
                    out.write("             // Done");
                    out.newLine();
                    out.write("             break;");
                    out.newLine();
                }
                ++j;
            }
            out.newLine();
            out.write("           }");
            out.newLine();
            out.write("           // 4.2. Record success");
            out.newLine();
            out.write("           services[serviceIndex].recordSuccess(\"" + str[1] + "\");");
            out.newLine();
            out.newLine();
            out.write("           // 4.3 Return result");
            out.newLine();
            out.write("           return result;");
            out.newLine();
            out.newLine();
            out.write("        }");
            out.newLine();
            out.newLine();
            out.write("        // 5. Handle exception");
            out.newLine();
            out.write("        catch (Exception ex){");
            out.newLine();
            out.newLine();
            out.write("           // 5.1 Log an error message");
            out.newLine();
            out.write("           System.out.println(ex.getMessage());");
            out.newLine();
            out.write("           logger.error(\"Exception: \" + ex.getMessage());");
            out.newLine();
            out.newLine();
            out.write("           // 5.2. Record failure ");
            out.newLine();
            out.write("           services[serviceIndex].recordFailure(\"" + str[1] + "\");");
            out.newLine();
            out.newLine();
            out.write("           // 5.3. Throw exception");
            out.newLine();
            out.write("           throw ex;");
            out.newLine();
            out.write("        }");
            out.newLine();
            out.newLine();
            out.write("    }");
            out.newLine();
            out.newLine();
            ++i;
        }
        out.newLine();
        out.write("}");
        out.close();
    }

    public static void executeCommand(String wsdlURL) {
        BuildProxy.deletefile(String.valueOf(outputDir) + "/build.xml");
        try {
            Runtime rt = Runtime.getRuntime();
            String[] env2 = new String[]{JAVA_HOME, AXIS2_HOME};
            Process pr = rt.exec(String.valueOf(w2jCommand) + " -uri " + wsdlURL + " -o " + outputDir, env2);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
            int exitVal = pr.waitFor();
            System.out.println("Exited with error code " + exitVal);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static void executeCommandAnt() {
        try {
            Runtime rt = Runtime.getRuntime();
            String[] env = new String[]{JAVA_HOME, AXIS2_HOME};
            File wdir = new File(outputDir);
            Process pr = rt.exec("ant", env, wdir);
            pr = rt.exec("mkdir " + outputDir + "/src/net/" + packageName);
            pr = rt.exec("cp " + outputDir + "/" + proxyName + ".java" + " " + outputDir + "/src/net/" + packageName + "/" + proxyName + ".java");
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
            int exitVal = pr.waitFor();
            System.out.println("Exited with error code " + exitVal);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    private static void generateStubs() {
        int i = 0;
        while (i < URLs.size()) {
            String wsdlUrl = URLs.get(i);
            System.out.println(wsdlUrl);
            BuildProxy.executeCommand(wsdlUrl);
            ++i;
        }
        BuildProxy.executeCommandAnt();
    }

    static ArrayList<String> Process2(File aFile) {
        ArrayList<String> x = new ArrayList<String>();
        String thisDirectory = aFile.getName();
        File[] listOfFiles = aFile.listFiles();
        boolean hasSubdirectories = false;
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isDirectory()) {
                hasSubdirectories = true;
                ArrayList<String> b = BuildProxy.Process2(listOfFiles[i]);
                int j = 0;
                while (j < b.size()) {
                    x.add(String.valueOf(thisDirectory) + "." + b.get(j));
                    ++j;
                }
            }
            ++i;
        }
        if (!hasSubdirectories) {
            x.add(thisDirectory);
        }
        return x;
    }

    static boolean interestingFile(String aFileName) {
        return aFileName.contains("Stub") && !aFileName.contains("$");
    }

    static ArrayList<String> traverseDirectory(File node) {
        File[] listofFiles;
        ArrayList<String> fileNames = new ArrayList<String>();
        File[] fileArray = listofFiles = node.listFiles();
        int n = listofFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File aFile = fileArray[n2];
            if (aFile.isDirectory()) {
                fileNames.addAll(BuildProxy.traverseDirectory(aFile));
            } else if (BuildProxy.interestingFile(aFile.getName())) {
                String name = aFile.getName();
                int dot = name.lastIndexOf(46);
                String base = dot == -1 ? name : name.substring(0, dot);
                fileNames.add(base);
            }
            ++n2;
        }
        return fileNames;
    }

    public void exeBuildProxy() {
        BuildProxy.parseConfigEnv("envConfig.txt");
        try {
            outputDir = String.valueOf(System.getProperty("user.dir")) + "/proxy";
            System.out.println("Code generated in " + outputDir);
            BuildProxy.parseConfig(String.valueOf(System.getProperty("user.dir")) + "/config.temp");
            try {
                BuildProxy.generateIntelligentProxy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            BuildProxy.generateStubs();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }
}

