/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AddNewProxyMethodDialog;
import gui.ConcreteServicePanel;
import gui.LoadNewWsdlDialog;
import gui.MenuBar;
import gui.WebServiceMethodList;
import gui.WebServiceMethodListListener;
import gui.WebServiceNamePanel;
import holtjp.proxygen.proxy.ProxyModel;
import holtjp.proxygen.proxy.WebServiceMap;
import holtjp.proxygen.webservice.Parameter;
import holtjp.proxygen.webservice.WebService;
import holtjp.proxygen.webservice.WebServiceMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    final ProxyModel model = new ProxyModel();
    private final GUI gui;
    private final JList mapList;
    final DefaultListModel dlm = new DefaultListModel();
    final JList proxyMethodList;
    final JList wsdlMethodList;
    private final Map<String, WebService> webServices;

    public GUI() {
        super("Proxygen");
        this.gui = this;
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1350, 650));
        this.webServices = new HashMap<String, WebService>();
        Panel lists = new Panel();
        lists.setLayout(new GridLayout(1, 3, 5, 5));
        ImageIcon add = new ImageIcon("images/add.gif");
        JButton jb1 = new JButton(add);
        jb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new AddNewProxyMethodDialog(GUI.this.gui, GUI.this.gui).setVisible(true);
            }
        });
        ImageIcon delete = new ImageIcon("images/del.gif");
        JButton jb2 = new JButton(delete);
        jb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int idx = GUI.this.proxyMethodList.getSelectedIndex();
                System.out.println("remove fired with idx " + idx);
                if (idx >= 0 && idx < GUI.this.model.getSize()) {
                    GUI.this.proxyMethodList.clearSelection();
                    WebServiceMethod m = (WebServiceMethod)GUI.this.model.getElementAt(idx);
                    GUI.this.model.removeProxyMethod(m.getOperationName());
                }
            }
        });
        this.proxyMethodList = new WebServiceMethodList(this.model, true);
        this.proxyMethodList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                GUI.this.rebuildMappingList();
            }
        });
        JButton proxyGen = new JButton("Generate Proxy");
        jb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        WebServiceNamePanel proxyNamePanel = new WebServiceNamePanel(this.gui, jb1, jb2, this.proxyMethodList, proxyGen);
        JPanel proxyColumn = new JPanel(new GridLayout(4, 1, 5, 0));
        proxyColumn.setLayout(new BorderLayout());
        proxyColumn.add((Component)proxyNamePanel, "North");
        lists.add(proxyColumn);
        ImageIcon add2 = new ImageIcon("images/add.gif");
        JButton loadWsdl2 = new JButton(add2);
        loadWsdl2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("* before *" + GUI.this.mapList.getModel().getSize() + " elements");
                new LoadNewWsdlDialog(GUI.this.gui, GUI.this.gui).setVisible(true);
                System.out.println("**" + GUI.this.mapList.getModel().getSize() + " elements");
                System.out.println("** Element 1 is " + GUI.this.mapList.getModel().getElementAt(0));
                System.out.println("** Element 1 is a " + GUI.this.mapList.getModel().getElementAt(0).getClass().getCanonicalName());
            }
        });
        this.mapList = new WebServiceMethodList(this.dlm, false);
        this.mapList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                System.out.println("Selection changed");
                if (GUI.this.mapList.getSelectedIndex() == -1) {
                    return;
                }
                WebServiceMethod m = (WebServiceMethod)GUI.this.dlm.getElementAt(GUI.this.mapList.getSelectedIndex());
                System.out.println(m.getUrl());
                WebService ws = (WebService)GUI.this.webServices.get(m.getUrl());
                if (ws != null) {
                    System.out.println("Changing model");
                    GUI.this.wsdlMethodList.setModel(ws);
                }
            }
        });
        ImageIcon link = new ImageIcon("images/link.gif");
        JButton addToMap = new JButton(link);
        addToMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (GUI.this.wsdlMethodList.getSelectedIndex() < 0) {
                    return;
                }
                if (GUI.this.proxyMethodList.getSelectedIndex() < 0) {
                    return;
                }
                WebServiceMethod m = (WebServiceMethod)GUI.this.wsdlMethodList.getModel().getElementAt(GUI.this.wsdlMethodList.getSelectedIndex());
                WebServiceMethod pm = (WebServiceMethod)GUI.this.proxyMethodList.getModel().getElementAt(GUI.this.proxyMethodList.getSelectedIndex());
                GUI.this.model.mapRealMethod(pm.getOperationName(), m);
                GUI.this.rebuildMappingList();
            }
        });
        ImageIcon unlink = new ImageIcon("images/unlink2.gif");
        JButton removeMapping = new JButton(unlink);
        removeMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (GUI.this.mapList.getSelectedIndex() < 0) {
                    return;
                }
                if (GUI.this.proxyMethodList.getSelectedIndex() < 0) {
                    return;
                }
                WebServiceMethod m = (WebServiceMethod)GUI.this.dlm.get(GUI.this.mapList.getSelectedIndex());
                WebServiceMethod pm = (WebServiceMethod)GUI.this.proxyMethodList.getModel().getElementAt(GUI.this.proxyMethodList.getSelectedIndex());
                GUI.this.model.removeMapping(pm.getOperationName(), m.getUrl());
                GUI.this.rebuildMappingList();
            }
        });
        JButton exitButton = new JButton("Exit");
        jb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        this.wsdlMethodList = new WebServiceMethodList(new DefaultListModel(), true);
        JPanel proxyMapcolumn = new JPanel(new BorderLayout());
        ConcreteServicePanel concreteServicePanel = new ConcreteServicePanel(this.gui, this.mapList, loadWsdl2, addToMap, removeMapping, this.wsdlMethodList, exitButton);
        proxyMapcolumn.add((Component)concreteServicePanel, "North");
        lists.add(proxyMapcolumn);
        this.proxyMethodList.addListSelectionListener(new WebServiceMethodListListener(this.proxyMethodList, concreteServicePanel));
        this.wsdlMethodList.addListSelectionListener(new WebServiceMethodListListener(this.wsdlMethodList, concreteServicePanel));
        this.add((Component)lists, "Center");
        this.add((Component)new MenuBar(this), "North");
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GUI();
            }
        });
    }

    public void addNewWebService(WebService ws) {
        this.webServices.put(ws.getURL(), ws);
        this.model.makeMap(ws.getURL());
        this.rebuildMappingList();
    }

    private void rebuildMappingList() {
        if (this.proxyMethodList.getSelectedIndex() == -1) {
            this.dlm.clear();
            return;
        }
        WebServiceMethod m = (WebServiceMethod)this.model.getElementAt(this.proxyMethodList.getSelectedIndex());
        if (m != null) {
            this.dlm.clear();
            Iterator<WebServiceMap> it = this.model.getProxyMapIterator();
            while (it.hasNext()) {
                WebServiceMap wsm = it.next();
                if (wsm.getMapped(m.getOperationName()) != null) {
                    this.dlm.addElement(wsm.getMapped(m.getOperationName()));
                    continue;
                }
                this.dlm.addElement(new WebServiceMethod(wsm.getURL(), "-", "", new Parameter[0]));
            }
        }
    }
}

