/*
 * Decompiled with CFR 0.152.
 */
package holtjp.proxygen.proxy;

import holtjp.proxygen.proxy.WebServiceMap;
import holtjp.proxygen.webservice.WebServiceMethod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class ProxyModel
extends AbstractListModel {
    private static final long serialVersionUID = -3015484160709406717L;
    String packageName = "";
    String className = "";
    List<WebServiceMap> webServiceMaps = new ArrayList<WebServiceMap>();
    List<WebServiceMethod> methods = new ArrayList<WebServiceMethod>();

    public void addProxyClassName(String className) {
        this.className = className;
    }

    public void addProxyPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void reset() {
        this.webServiceMaps.clear();
        this.methods.clear();
    }

    public void addProxyMethod(WebServiceMethod method) {
        this.methods.add(method);
        this.fireIntervalAdded(this, this.methods.size(), this.methods.size());
        for (WebServiceMethod m : this.methods) {
            System.out.println(m.toString());
        }
    }

    public void removeProxyMethod(String opName) {
        Iterator<WebServiceMethod> it = this.methods.iterator();
        int i = 0;
        while (it.hasNext()) {
            WebServiceMethod m = it.next();
            if (m.getOperationName().equals(opName)) {
                it.remove();
                break;
            }
            ++i;
        }
        for (WebServiceMap map : this.webServiceMaps) {
            map.unMap(opName);
        }
        this.fireIntervalRemoved(this, i, i);
    }

    public void mapRealMethod(String mapTo, WebServiceMethod method) {
        String url = method.getUrl();
        for (WebServiceMethod pmethod : this.methods) {
            if (!pmethod.getOperationName().equals(mapTo)) continue;
            this.makeMap(url);
            this.getMappingFor(url).mapTo(mapTo, method);
            return;
        }
    }

    public void makeMap(String url) {
        for (WebServiceMap map : this.webServiceMaps) {
            if (!map.getURL().equals(url)) continue;
            return;
        }
        this.webServiceMaps.add(new WebServiceMap(url));
    }

    public WebServiceMap getMappingFor(String url) {
        for (WebServiceMap map : this.webServiceMaps) {
            if (!map.getURL().equals(url)) continue;
            return map;
        }
        return null;
    }

    public void removeMapping(String proxyMethod, String url) {
        WebServiceMap wsm = this.getMappingFor(url);
        if (wsm != null) {
            wsm.unMap(proxyMethod);
        }
    }

    public Iterator<WebServiceMethod> getProxyMethodIterator() {
        return this.methods.iterator();
    }

    public Iterator<WebServiceMap> getProxyMapIterator() {
        return this.webServiceMaps.iterator();
    }

    public String toString() {
        String ret = String.valueOf(this.className) + "\n";
        ret = String.valueOf(ret) + this.packageName + "\n";
        for (WebServiceMethod m : this.methods) {
            ret = String.valueOf(ret) + m.toString() + "\n";
        }
        for (WebServiceMap map : this.webServiceMaps) {
            ret = String.valueOf(ret) + "\n";
            ret = String.valueOf(ret) + map.getURL() + "\n";
            for (WebServiceMethod m : this.methods) {
                WebServiceMethod method = map.getMapped(m.getOperationName());
                ret = method == null ? String.valueOf(ret) + "-\n" : String.valueOf(ret) + method.getOperationName() + "\n";
            }
        }
        return ret;
    }

    @Override
    public Object getElementAt(int arg0) {
        return this.methods.get(arg0);
    }

    @Override
    public int getSize() {
        return this.methods.size();
    }
}

