/*
 * Decompiled with CFR 0.152.
 */
package holtjp.proxygen.webservice;

import holtjp.proxygen.webservice.Parameter;
import holtjp.proxygen.webservice.WebService;
import holtjp.proxygen.webservice.WebServiceMethod;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.WSDLException;

public class EasyWSDLWebService
extends WebService {
    private static final long serialVersionUID = 6722051196997923701L;

    @Override
    public void load(URL url) {
        this.url = url.toString();
        this.methods.clear();
        try {
            this.debug("Reading wsdl");
            long t = System.currentTimeMillis();
            Description desc = WSDLFactory.newInstance().newWSDLReader().read(url);
            this.debug("Time to parse wsdl, " + (System.currentTimeMillis() - t) + " milliseconds");
            for (InterfaceType iface : desc.getInterfaces()) {
                this.debug("Parsing " + iface.getOperations().size() + " operations");
                for (Operation op : iface.getOperations()) {
                    ParameterList params = new ParameterList();
                    for (Part param : ((Input)op.getInput()).getParts()) {
                        params.addList(this.parseSimpleTypes(param.getElement()));
                    }
                    ParameterList returnType = new ParameterList();
                    for (Part param : ((Output)op.getOutput()).getParts()) {
                        returnType.addList(this.parseSimpleTypes(param.getElement()));
                    }
                    String rt = "void";
                    if (returnType.size() == 1) {
                        rt = returnType.toArray()[0].getType();
                    } else if (returnType.size() > 1) {
                        rt = "Map<String,Object>";
                        rt = "string";
                    }
                    this.methods.add(new WebServiceMethod(url.toString(), op.getQName().getLocalPart(), rt, params.toArray()));
                }
            }
        }
        catch (WSDLException e) {
            System.out.println("Could not parse the supplied WSDL file");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Could not access the supplied WSDL file");
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            System.out.println("Could not use supplied URL for WSDL");
            e.printStackTrace();
        }
    }

    private void debug(String string) {
        System.out.println(string);
    }

    private ParameterList parseSimpleTypes(Element e) {
        return this.parseSimpleTypes(e, "");
    }

    private ParameterList parseSimpleTypes(Element e, String prefix) {
        Type t = (Type)e.getType();
        ParameterList params = new ParameterList();
        if (t instanceof ComplexType) {
            ComplexType ct = (ComplexType)t;
            if (ct.hasSequence()) {
                for (Element seqE : ((Sequence)ct.getSequence()).getElements()) {
                    params.addList(this.parseSimpleTypes(seqE, e.getQName().getLocalPart()));
                }
            } else if (!ct.hasComplexContent() && !ct.hasSimpleContent()) {
                ct.hasChoice();
            }
        } else {
            params.add(t.getQName().getLocalPart(), String.valueOf(prefix) + "." + e.getQName().getLocalPart());
        }
        return params;
    }

    private class ParameterList {
        private List<Parameter> params = new ArrayList<Parameter>();

        public void addList(ParameterList a) {
            this.params.addAll(a.params);
        }

        public void add(String t, String n) {
            this.params.add(new Parameter(t, n));
        }

        private Parameter[] toArray() {
            Parameter[] r = new Parameter[this.params.size()];
            int i = 0;
            Iterator<Parameter> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                Parameter s;
                r[i] = s = iterator.next();
                ++i;
            }
            return r;
        }

        private int size() {
            return this.params.size();
        }
    }
}

