/*
 * Decompiled with CFR 0.152.
 */
package holtjp.proxygen.webservice;

import holtjp.proxygen.webservice.Parameter;
import holtjp.proxygen.webservice.WebService;
import holtjp.proxygen.webservice.WebServiceMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLWebService
extends WebService {
    private static final long serialVersionUID = 1L;

    public WSDLWebService(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = dbFactory.newDocumentBuilder().parse(stream);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression inputExp = xPath.compile("./input");
            XPathExpression outputExp = xPath.compile("./output");
            if (xPath.compile("description").evaluate(doc, XPathConstants.NODE) != null) {
                System.out.println("WSDL 2.0");
                NodeList operations = (NodeList)xPath.compile("/description/interface/operation").evaluate(doc, XPathConstants.NODESET);
                if (operations.getLength() > 0) {
                    int i = 0;
                    while (i < operations.getLength()) {
                        Node operation = operations.item(i);
                        String opName = operation.getAttributes().getNamedItem("name").getNodeValue();
                        Node inp = (Node)inputExp.evaluate(operation, XPathConstants.NODE);
                        String elementInput = inp.getAttributes().getNamedItem("element").getNodeValue().split(":")[1];
                        ArrayList<String> arguments = new ArrayList<String>();
                        ArrayList<String> argumentTypes = new ArrayList<String>();
                        NodeList inputSchemaNode = (NodeList)xPath.compile("/description/types/schema/element[@name='" + elementInput + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);
                        int k = 0;
                        while (k < inputSchemaNode.getLength()) {
                            Node partElement = inputSchemaNode.item(k);
                            arguments.add(partElement.getAttributes().getNamedItem("name").getNodeValue());
                            argumentTypes.add(partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1]);
                            ++k;
                        }
                        Node out = (Node)outputExp.evaluate(operation, XPathConstants.NODE);
                        String elementOutput = out.getAttributes().getNamedItem("element").getNodeValue().split(":")[1];
                        NodeList outputSchemaNode = (NodeList)xPath.compile("/description/types/schema/element[@name='" + elementOutput + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);
                        int k2 = 0;
                        while (k2 < outputSchemaNode.getLength()) {
                            Node partElement = outputSchemaNode.item(k2);
                            elementOutput = partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1];
                            ++k2;
                        }
                        Parameter[] p = new Parameter[arguments.size()];
                        int ii = 0;
                        while (ii < p.length) {
                            p[ii] = new Parameter((String)argumentTypes.get(ii), (String)arguments.get(ii));
                            ++ii;
                        }
                        this.methods.add(new WebServiceMethod("test.url.ignore.com", opName, elementOutput, p));
                        ++i;
                    }
                }
            } else {
                System.out.println("WSDL 1.0");
                NodeList operations = (NodeList)xPath.compile("/definitions/portType/operation").evaluate(doc, XPathConstants.NODESET);
                if (operations.getLength() > 0) {
                    System.out.println(operations.getLength());
                    int i = 0;
                    while (i < operations.getLength()) {
                        Node operation = operations.item(i);
                        String opName = operation.getAttributes().getNamedItem("name").getNodeValue();
                        Node inp = (Node)inputExp.evaluate(operation, XPathConstants.NODE);
                        String messageInput = inp.getAttributes().getNamedItem("message").getNodeValue().split(":")[1];
                        Node parameter = (Node)xPath.compile("/definitions/message[@name='" + messageInput + "']/part").evaluate(doc, XPathConstants.NODE);
                        ArrayList<String> arguments = new ArrayList<String>();
                        ArrayList<String> argumentTypes = new ArrayList<String>();
                        if (parameter != null) {
                            String inpSchemaName = parameter.getAttributes().getNamedItem("element").getNodeValue().split("\\:")[1];
                            NodeList inputSchemaNode = (NodeList)xPath.compile("/definitions/types/schema/element[@name='" + inpSchemaName + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);
                            int k = 0;
                            while (k < inputSchemaNode.getLength()) {
                                Node partElement = inputSchemaNode.item(k);
                                arguments.add(partElement.getAttributes().getNamedItem("name").getNodeValue());
                                argumentTypes.add(partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1]);
                                ++k;
                            }
                        }
                        Node out = (Node)outputExp.evaluate(operation, XPathConstants.NODE);
                        String messageOutput = out.getAttributes().getNamedItem("message").getNodeValue().split(":")[1];
                        parameter = (Node)xPath.compile("/definitions/message[@name='" + messageOutput + "']/part").evaluate(doc, XPathConstants.NODE);
                        String schemaOutput = "";
                        if (parameter != null) {
                            String outSchemaName = parameter.getAttributes().getNamedItem("element").getNodeValue().split("\\:")[1];
                            NodeList outputSchemaNode = (NodeList)xPath.compile("/definitions/types/schema/element[@name='" + outSchemaName + "']/complexType/sequence/element").evaluate(doc, XPathConstants.NODESET);
                            int k = 0;
                            while (k < outputSchemaNode.getLength()) {
                                Node partElement = outputSchemaNode.item(k);
                                schemaOutput = partElement.getAttributes().getNamedItem("type").getNodeValue().split("\\:")[1];
                                ++k;
                            }
                        }
                        Parameter[] p = new Parameter[arguments.size()];
                        int ii = 0;
                        while (ii < p.length) {
                            p[ii] = new Parameter((String)argumentTypes.get(ii), (String)arguments.get(ii));
                            ++ii;
                        }
                        this.methods.add(new WebServiceMethod("test.url.ignore.com", opName, schemaOutput, p));
                        ++i;
                    }
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(URL url) {
    }
}

