/*
 * Decompiled with CFR 0.152.
 */
package holtjp.proxygen.webservice;

import holtjp.proxygen.webservice.Parameter;

public class WebServiceMethod {
    private final String url;
    private final String operationName;
    private final String returnType;
    private final Parameter[] parameters;

    public WebServiceMethod(String url, String operationName, String returnType, Parameter[] params) {
        this.url = url;
        this.operationName = operationName;
        this.returnType = returnType;
        this.parameters = params;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getUrl() {
        return this.url;
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public Parameter getParameter(int i) {
        if (i < 0 || i >= this.parameters.length) {
            return null;
        }
        return this.parameters[i];
    }

    public String toString() {
        String ret = String.valueOf(this.returnType) + " " + this.operationName + "(";
        boolean p = false;
        Parameter[] parameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            if (p) {
                ret = String.valueOf(ret) + ", ";
            } else {
                p = true;
            }
            ret = String.valueOf(ret) + param;
            ++n2;
        }
        return String.valueOf(ret) + ")";
    }

    public boolean compatible(WebServiceMethod other) {
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.length) {
            if (!this.parameters[i].equalType(other.parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

