/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;

public class ModelGenerator {
    public static void main(String[] args) {
        String xmlFilePath = args[0];
        if (new File(xmlFilePath).exists()) {
            String fileName = new File(xmlFilePath).getName();
            int suffixIndex = fileName.indexOf(".");
            fileName = suffixIndex > 0 ? fileName.substring(0, suffixIndex) : fileName;
            String filePath = new File(xmlFilePath).getParent();
            if (filePath == null) {
                try {
                    filePath = new File(".").getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Translator t = new Translator(xmlFilePath);
            PrismModel pm = t.processXML();
            pm.generateWorkFlowModel(String.valueOf(filePath) + File.separator + fileName + ".pm");
            pm.generatePctlFormulae(String.valueOf(filePath) + File.separator + fileName + ".pctl");
        } else {
            System.out.println("Error: Could not find " + xmlFilePath);
        }
    }
}

