/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PrismModel {
    final String STATE_NAME = "a";
    private String moduleName = "WorkFlow";
    public HashMap<String, State> states = new HashMap();
    private HashMap<String, Edge> edges = new HashMap();
    private HashMap<String, Boolean> marked = new HashMap();
    private ArrayList<String> pctlFormulae = new ArrayList();

    public ArrayList<String> getPctls() {
        return this.pctlFormulae;
    }

    public void addpctlFormulae(String formula) {
        this.pctlFormulae.add(formula);
    }

    public void addState(State state) {
        this.states.put(state.id, state);
        this.marked.put(state.id, Boolean.FALSE);
    }

    public void addEdge(Edge edge) {
        this.edges.put(edge.id, edge);
    }

    public State findState(String attr) {
        for (Map.Entry<String, State> entry : this.states.entrySet()) {
            State s = entry.getValue();
            if (!s.name.contentEquals(attr) && !s.id.contentEquals(attr) && !s.incomingEdges.contentEquals(attr) && !s.outgoingEdges.contentEquals(attr) && !s.type.contentEquals(attr)) continue;
            return s;
        }
        return null;
    }

    private ArrayList<Edge> outgoingEdges(State s) {
        ArrayList<Edge> egdeArray = new ArrayList<Edge>();
        String[] stringArray = s.outgoingEdges();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            egdeArray.add(this.edges.get(id));
            ++n2;
        }
        return egdeArray;
    }

    private String generateWorkFlowModel(State source) {
        ArrayList<Edge> destinations;
        String module = "";
        if (this.marked.get(source.id).booleanValue()) {
            return module;
        }
        if (source == this.findState("InitialNode1")) {
            module = String.valueOf(module) + "\nmodule " + this.moduleName + "\n" + "a" + " : [0.." + (this.states.size() - 1) + "] init " + this.findState((String)"InitialNode1").n + ";\n";
        }
        if ((destinations = this.outgoingEdges(source)).isEmpty()) {
            module = String.valueOf(module) + "[" + source.name + "] (" + "a" + "=" + source.n + ") -> 1.0:(" + "a" + "'=" + source.n + ");\n";
            return module;
        }
        module = String.valueOf(module) + "[" + source.name + "] (" + "a" + "=" + source.n + ") -> ";
        int count = 0;
        for (Edge e : destinations) {
            State destination = this.states.get(e.target);
            String lineEnd = count < destinations.size() - 1 ? "+" : ";\n";
            module = String.valueOf(module) + e.pTransition + ":(" + "a" + "'=" + destination.n + ")" + lineEnd;
            ++count;
        }
        this.markState(source);
        for (Edge e : destinations) {
            module = String.valueOf(module) + this.generateWorkFlowModel(this.states.get(e.target));
        }
        return module;
    }

    private void markState(State init) {
        this.marked.put(init.id, Boolean.TRUE);
    }

    private String generateRewards() {
        String output = "rewards\n";
        for (String sName : this.states.keySet()) {
            State s = this.states.get(sName);
            if (!s.type.contentEquals("uml:OpaqueAction")) continue;
            output = String.valueOf(output) + "(a=" + s.n + ") : %" + s.name + "_COST;\n";
        }
        return String.valueOf(output) + "endrewards\n";
    }

    private String generateLabels() {
        String output = "//pctl formulae\n";
        for (String pctl : this.pctlFormulae) {
            output = String.valueOf(output) + "//" + pctl + "\n";
        }
        output = String.valueOf(output) + "//parameterised probability values\n";
        for (State s : this.getStates()) {
            if (!s.type.contentEquals("uml:OpaqueAction")) continue;
            output = String.valueOf(output) + "const double " + s.name + "_p = %" + s.name + ";\n";
        }
        output = String.valueOf(output) + "//labels\n";
        for (State s : this.getStates()) {
            output = String.valueOf(output) + "label \"" + s.name + "\" = " + "a" + "=" + s.n + ";\n";
        }
        return output;
    }

    private void write(String fileName, String output) {
        try {
            PrintWriter fileout = new PrintWriter(fileName, "UTF-8");
            fileout.println(output);
            fileout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void generateWorkFlowModel(String fileName) {
        this.write(fileName, this.generateWorkFlowModel());
    }

    public String generateWorkFlowModel() {
        for (String mark : this.marked.keySet()) {
            this.marked.put(mark, Boolean.FALSE);
        }
        return "dtmc\n" + this.generateLabels() + this.generateRewards() + this.generateWorkFlowModel(this.findState("InitialNode1")) + "endmodule\n";
    }

    public String generatePctlFormulae() {
        String output = "";
        for (String p : this.pctlFormulae) {
            output = String.valueOf(output) + p + "\n";
        }
        return output;
    }

    public String toString() {
        return this.generateWorkFlowModel();
    }

    public Edge getEdge(String id) {
        return this.edges.get(id);
    }

    public ArrayList<State> getStates() {
        ArrayList<State> stateArray = new ArrayList<State>();
        for (Map.Entry<String, State> entry : this.states.entrySet()) {
            stateArray.add(entry.getValue());
        }
        return stateArray;
    }

    public void generatePctlFormulae(String fileName) {
        this.write(fileName, this.generatePctlFormulae());
    }
}

